<?php

namespace app\models;

use Yii;

/**
 * This is the model class for table "bills".
 *
 * @property int $id
 * @property string $date
 * @property int $userId
 * @property string $dueDate
 * @property string $comment
 * @property int $paid
 * @property int $company
 * @property int $status
 * @property int $paytype
 * @property int $clientId
 *
 * @property Billcontent[] $billcontents
 * @property Billpayments[] $billpayments
 * @property Accounts $billby0
 * @property Uzers $user
 */
class Bills extends \yii\db\ActiveRecord
{
    /**
     * {@inheritdoc}
     */
    
    public $billamount, $from, $to ,$numbername;
    
    public static function tableName()
    {
        return 'bills';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['date', 'userId', 'dueDate','currency','paytype','clientId','status'], 'required'],
            [['userId', 'paid', 'company','paytype','status'], 'integer'],
            [['date', 'dueDate','comment'], 'safe'],
           [['userId'], 'exist', 'skipOnError' => true, 'targetClass' => Uzers::className(), 'targetAttribute' => ['userId' => 'id']],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'id' => 'Bill #',
            'date' => 'Bill Date',
            'userId' => 'Registered by',
            'dueDate' => 'Due Date',
            'paid' => 'Paid',
            'company' => 'Company',
            'billamount'=>'Amount',
            'currency'=>'Currency',
            'paytype'=>'Payment method',
            'clientId'=>'Client',
            'comment'=>'Comments/clients invoices #',
            'numbername'=>'Bill #',
        ];
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getBillcontents()
    {
        return $this->hasMany(Billcontent::className(), ['billId' => 'id']);
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getBillpayments()
    {
        return $this->hasMany(Billpayments::className(), ['billId' => 'id']);
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getBillby0()
    {
        return $this->hasOne(Accounts::className(), ['id' => 'billby']);
    }
    
     public function getClient()
    {
        return $this->hasOne(Clients::className(), ['id' => 'clientId']);
    }


    /**
     * @return \yii\db\ActiveQuery
     */
    public function getUser()
    {
        return $this->hasOne(Uzers::className(), ['id' => 'userId']);
    }
    
    public function getPaytype($payt){
        
        if ($payt==1) return 'Cash';
        elseif ($payt==2) return 'Cheque';
        elseif ($payt==3) return 'TT';
    }
    
    public function checkDueBills(){
        $available=0;
        
        $bills= Bills::find()->where(['paid'=>0,'company'=>\Yii::$app->session->get('company'), 'userId'=>\Yii::$app->user->getId()])->all();
        
        if ($bills != null){
            foreach ($bills as $bill){
                if ($bill->dueDate <= date('Y-m-d')){
                    $available=$available+1;
                }
            }
        }
        
        return $available;
    }
    
        public function getAccountId($cId){
        
        $nm= Clients::findOne($cId)->name;
        $accounts= Accounts::find()->all();
        $id=null;
        if ($accounts != null){
            foreach ($accounts as $account){
                if (stripos($nm,$account->name)!== false){
                    $id=$account->id;
                }
            }
        }
        return $id;
    }
    
        
    public function getBillsIdByDates($f,$t,$c){
        
        $ret=null;
       $alls=Bills::find()->where("date >= '$f' and date <= '$t' and company=:c and currency=:kr", [':kr'=>$c,':c'=>\Yii::$app->session->get('company')])->all();
    
       if($alls != null){
           foreach ($alls as $all){
               $ret[]= $all->id;    
           }
       }
       
       return $ret;
    }
    
    public function getBillsIdOfThisyear(){
        
        $ret=null;
        $f=date('Y').'-01-01';
       $alls=Bills::find()->where("date >= '$f' and company=:c", [':c'=>\Yii::$app->session->get('company')])->all();
    
       if($alls != null){
           foreach ($alls as $all){
               $ret[]= $all->id;    
           }
       }
       
       return $ret;
    }
    
    
    public function getUnpaidbillsbyclient($clientId,$c){
        
        $ret=null;
       $alls=Bills::find()->where("clientId=:cid and company=:c and currency=:kr and paid=:pd", [':pd'=>0,':kr'=>$c,':cid'=>$clientId,':c'=>\Yii::$app->session->get('company')])->all();
    
       if($alls != null){
           foreach ($alls as $all){
               $ret[]= $all->id;    
           }
       }
       
       return $ret;
    }
    
    
        
    public function getBillNo($company,$bill){
    
        $alpha='A';
        $return=null;
        $b=0;       
            Billname::setBillNo($bill,$company,$alpha);
            $b=Billname::find()->where(['billid'=>$bill])->one();
               
            $return=$b->no.'/'.date('Y',strtotime($b->date));
               
     return $return;
                
    }
    
    
    public function reverseBillNo($no){
        
        $number = preg_replace('/[^0-9]/', '', $no);
        $all=array();
        
        $billno=Billname::find()->where(['no'=>$number,'comp'=>\Yii::$app->session->get('company')])->all();
        if ($billno != null) {
            foreach ($billno as $bill){
                $all[]=$bill->billid;
            }
        }
        
        return $all;
    }
    
    
        public function getNoCarCostByTime($from,$to){
        
        $f=date('Y-m-d',strtotime($from));
        $t=date('Y-m-d',strtotime($to));
        $totalExpT=0;
        
        $bills= Bills::find()->where("date >= '$f' and date <= '$t' and company=:c", [':c'=>\Yii::$app->session->get('company')])->all();
        
        if ($bills != null){
            foreach ($bills as $bill){
                if (Wshopbills::findOne(['billid'=>$bill->id]) != null){
                    $billIds[]=$bill->id;
                }
            }
        }
        
        
        
        $billcontentsnocar=Billcontent::find()->where(['billId'=>$billIds])-> all();
        
        if ($billcontentsnocar != null){
            foreach ($billcontentsnocar as $nocar){
                
                if (empty($nocar->carId)){
                    if (Bills::findOne($nocar->billId)->currency==1){
                        $totalExpT=$totalExpT + $nocar->amount*$nocar->count;
                       
                    }
                }
            }
            
        }
        
        return $totalExpT;
        
    }
    
        public function getCarCostByTime($from,$to,$car){
        
        $f=date('Y-m-d',strtotime($from));
        $t=date('Y-m-d',strtotime($to));
        $totalExpT=0;
        
        $bills= Bills::find()->where("date >= '$f' and date <= '$t' and company=:c", [':c'=>\Yii::$app->session->get('company')])->all();
        
        if ($bills != null){
            foreach ($bills as $bill){
                if (Wshopbills::findOne(['billid'=>$bill->id]) != null){
                    $billIds[]=$bill->id;
                }
            }
        }
        
        
        
        $billcontents=Billcontent::find()->where(['billId'=>$billIds,'carId'=>$car])-> all();
        
        if ($billcontents != null){
            foreach ($billcontents as $content){
                
                if (Bills::findOne($content->billId)->currency==1){
                    $totalExpT=$totalExpT + $content->amount*$content->count;
                }
            }
            
        }
        
        return $totalExpT;
        
    }
    
    
    
}