<?php

namespace app\models;

use Yii;

/**
 * This is the model class for table "billname".
 *
 * @property int $id
 * @property int $billid
 * @property int $no
 * @property string $nm
 * @property int $comp
 * @property string $date
 */
class Billname extends \yii\db\ActiveRecord
{
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return 'billname';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['billid', 'no', 'nm', 'comp','date'], 'required'],
            [['billid', 'no', 'comp'], 'integer'],
            [['nm'], 'string', 'max' => 10],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'billid' => 'Billid',
            'no' => 'No',
            'nm' => 'Nm',
            'comp' => 'Comp',
            'date' => 'Date',
        ];
    }
    
    
    public function setBillNo($billId,$c,$nm){
        
        $bycompany=Billname::find()->where(['comp'=>$c])->orderBy(['id'=>SORT_DESC])->all();
        
        if (date('Y')>='2021'){
        
        if ($bycompany==null){
            $set=new Billname();
            $set->billid=$billId;
            $set->no=1;
            $set->nm=$nm;
            $set->comp=$c;
            $set->date=date('Y-m-d');
            $set->save();
        }else{
           
            $oldNo=0;
            
            foreach ($bycompany as $by){
                if (date('Y',strtotime($by->date))==date('Y')){
                    if ($by->no > $oldNo){ $oldNo=$by->no; }
                }  
            }
                
                $checkBillId=Billname::find()->where(['billid'=>$billId])->one();
                
                    if ($checkBillId==null){
                        
                        $set=new Billname();
                        $set->billid=$billId;
                        $set->no=$oldNo+1;
                        $set->nm=$nm;
                        $set->comp=$c;
                        $set->date=date('Y-m-d');
                        $set->save();
                        
                        }
                     }
            }else{
                
                $checkBillId=Billname::find()->where(['billid'=>$billId])->one();
                
                if ($checkBillId==null){
                
                $set=new Billname();
                $set->billid=$billId;
                $set->no=$billId;
                $set->nm=$nm;
                $set->comp=$c;
                $set->date=date('Y-m-d');
                $set->save();
                
                } 
            }
        
        }
    
}
