<?php

namespace app\models;

use Yii;

/**
 * This is the model class for table "billcontent".
 *
 * @property int $id
 * @property int $billId
 * @property int $serviceId
 * @property int $count
 * @property int $accId
 * @property string $amount
 * @property string $carId 
 *
 * @property Bills $bill
 * @property Servicecost $service
 */
class Billcontent extends \yii\db\ActiveRecord
{
    /**
     * {@inheritdoc}
     */
    
    public $total,$amo;
    
    public static function tableName()
    {
        return 'billcontent';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['billId', 'serviceId', 'count', 'amount','accId'], 'required'],
            [['billId', 'serviceId', 'count','accId'], 'integer'],
            [['amount'], 'number'],
            [['carId'], 'string', 'max' => 7],
            [['billId'], 'exist', 'skipOnError' => true, 'targetClass' => Bills::className(), 'targetAttribute' => ['billId' => 'id']],
            [['serviceId'], 'exist', 'skipOnError' => true, 'targetClass' => Services::className(), 'targetAttribute' => ['serviceId' => 'id']],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'billId' => 'Bill ID',
            'serviceId' => 'Service/Product',
            'count' => 'Quantity',
            'amount' => 'Amount',
            'total'=>'Total',
            'carId'=>'Car',
            'accId'=>'Expense account',
        ];
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getBill()
    {
        return $this->hasOne(Bills::className(), ['id' => 'billId']);
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getService()
    {
        return $this->hasOne(Services::className(), ['id' => 'serviceId']);
    }
    
 public function getBillCostByAcc($id,$acc){
        $ret=0;
        
        $contents=Billcontent::find()->where(['billId'=>$id,'accId'=>$acc])->all();
        
        if ($contents!=null) {
            foreach ($contents as $content){
                $ret=$ret+($content->amount*$content->count);
            }
        }
        
        return $ret;
    }
    
    public function getBillCost($id){
        $ret=0;
        
        $contents=Billcontent::find()->where(['billId'=>$id])->all();
        
        if ($contents!=null) {
            foreach ($contents as $content){
                $ret=$ret+($content->amount*$content->count);
            }
        }
        
        return $ret;
    }
    
    public function checkServiceInBill($servid,$billId,$car){
        
        $ret=null;
        
        $contents=Billcontent::find()->where(['billId'=>$billId,'serviceId'=>$servid,'carId'=>$car])->all();
        
        if ($contents != null){
            foreach ($contents as $content){
                $ret=$content->id;
            }
        }
        return $ret;
    }
    
    
    public function checkServiceInBillByFile($servid,$billId,$file){
        
        $ret=null;
        
        $contents=Billcontent::find()->where(['serviceId'=>$servid])->all();
       
        if ($contents != null){
            foreach ($contents as $content){
                
                $fls= Cfbills::find()->where(['billId'=>$content->billId,'fileId'=>$file])->one();
                
                if ($fls != null){
                    if ($fls->fileId==$file) $ret=$content->id;
                
                 }
            }
        }
        return $ret;
    }
    
    
    public function checkServiceStatusInBillByCar($servid,$car){
        
        $ret=null;
        
        $contents=Billcontent::find()->where(['serviceId'=>$servid,'carId'=>$car])->all();
        
        if ($contents != null){
            foreach ($contents as $content){
                $ret='Supplied';
            }
        }
        return $ret;
    }
    
    public function checkServiceAmountInBill($servid,$billId){
        
        $ret=null;
        
        $contents=Billcontent::find()->where(['billId'=>$billId,'serviceId'=>$servid])->all();
        
        if ($contents != null){
            foreach ($contents as $content){
                $ret=$content->amount;
            }
        }
        return $ret;
    }
    
    
    public function getTruckNoByBillAndService($bId,$sId){
        $ret=null;
        
        $contents=Billcontent::find()->where(['billId'=>$bId,'serviceId'=>$sId])->all();
        
        if ($contents != null){
            foreach ($contents as $content){
                 $ret=$content->carId==null?'':$content->carId.'('.Cars::findOne($content->carId)->typeId.')';
            }
        }
        return $ret;
    }
    
    
    
    public function getLastbillServiceCost($bId,$sId){
        $ret=null;
        
        $truck= Billcontent::getTruckNoByBillAndService($bId,$sId);
        
        if ($truck != null){
            $cartype= Cars::find()->where(['plateno'=>$truck])->one()->typeId;
            
            $cars= Cars::find()->where(['typeId'=>$cartype])->all();
            
            if ($cars != null){
                foreach ($cars as $car){
                    
           $contents=Billcontent::find()->where(['serviceId'=>$sId, 'carId'=>$car->plateno])->orderBy(['id'=>SORT_DESC])->all();
            
            if ($contents != null){
                foreach ($contents as $content){
                    if ($content->billId < $bId){
                    $ret=$content;
                    break;
                            }
                        }
                    }else {
                        $contents2=Billcontent::find()->where(['serviceId'=>$sId])->orderBy(['id'=>SORT_DESC])->all();
                        
                        if ($contents2 != null){
                            foreach ($contents2 as $content){
                                if ($content->billId < $bId){
                                    $ret=$content;
                                    break;
                                }
                            }
                        }
                    }
                }
            }
        }else{
            
            $contents=Billcontent::find()->where(['serviceId'=>$sId])->orderBy(['id'=>SORT_DESC])->all();
            
            if ($contents != null){
                foreach ($contents as $content){
                    if ($content->billId < $bId){
                        $ret=$content;
                        break;
                    }
                }
            }
            
        }
        
        return $ret;
    }
    
    
    
    
    public function checkServiceRepeatativeinbill($tId,$sId){
        $ret='R';
        $cnt=0;
        $contents=Billcontent::find()->where(['serviceId'=>$sId,'carId'=>$tId])->orderBy(['id'=>SORT_DESC])->all();
        
        if ($contents != null){
            foreach ($contents as $content){
                  
                $cnt++;
            }
        }
        return $ret.''.$cnt;
    }
    
    
        
    public function checkServiceddate($tId){
        
        $name="Air cleaner";
        $return=null;
        $sId=null;
        $dt=null;
        
        $services1= Services::find()->where(['name'=>$name])->orderBy(['id'=>SORT_DESC])->all();
        
        if ($services1== null){
            
            $services= Services::find()->where(['like', 'name' , $name])->orderBy(['id'=>SORT_DESC])->all();
            
            if ($services != null){
                foreach ($services as $service){
                        $return=$service;
                }
            }
        }else{
            $return=$services1;
        }
        
        foreach ($return as $ret){
            $sId=$ret->id;
            break;
        }
        
       if ($sId != null) {
        
        $contents=Billcontent::find()->where(['serviceId'=>$sId,'carId'=>$tId])->orderBy(['id'=>SORT_DESC])->all();
        
        if ($contents != null){
            foreach ($contents as $content){
                
                $dt=$content->bill->date;
            }
        }
        
                }
                
                
        return $dt;
    }
 
    

    
}