<?php

namespace app\models;

use Yii;

/**
 * This is the model class for table "billbulkpayments".
 *
 * @property int $id
 * @property string $date
 * @property int $userId
 * @property int $clientId
 * @property int $accountId
 * @property string $amount
 * @property string $checkNo
 * @property int $company
 *
 * @property Accounts $account
 * @property Uzers $user
 */
class Billbulkpayments extends \yii\db\ActiveRecord
{
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return 'billbulkpayments';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['date', 'userId', 'accountId', 'amount','clientId'], 'required'],
            [['date'], 'safe'],
            [['userId', 'accountId', 'company'], 'integer'],
            [['amount'], 'number'],
            [['checkNo'], 'string', 'max' => 10],
            [['accountId'], 'exist', 'skipOnError' => true, 'targetClass' => Accounts::className(), 'targetAttribute' => ['accountId' => 'id']],
            [['userId'], 'exist', 'skipOnError' => true, 'targetClass' => Uzers::className(), 'targetAttribute' => ['userId' => 'id']],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'date' => 'Date',
            'userId' => 'User ID',
            'accountId' => 'Account ID',
            'amount' => 'Amount',
            'checkNo' => 'Check No',
            'company' => 'Company',
            'clientId' => 'Client',
        ];
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getAccount()
    {
        return $this->hasOne(Accounts::className(), ['id' => 'accountId']);
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getUser()
    {
        return $this->hasOne(Uzers::className(), ['id' => 'userId']);
    }
}
