<?php

namespace app\controllers;

use Yii;
use Behat\Gherkin\Exception\Exception;
use app\models\Cars;
use app\models\Cartype;
use app\models\Wstoredispatch;
use app\models\WstoredispatchSearch;
use yii\web\Controller;
use yii\web\NotFoundHttpException;
use yii\filters\VerbFilter;
use app\models\Dispatchcontents;
use app\models\Defectivetrucks;
use kartik\mpdf\Pdf;
use app\models\Wstore;
use app\models\Model;


/**
 * WstoredispatchController implements the CRUD actions for Wstoredispatch model.
 */
class WstoredispatchController extends Controller
{
    public function init() {
        
        if (\Yii::$app->session->get('layout') != null){
            $this->layout = \Yii::$app->session->get('layout');
        }else{
            $this->layout = 'workshop';
        }
       
    }
    /**
     * {@inheritdoc}
     */
    public function behaviors()
    {
        return [
            'verbs' => [
                'class' => VerbFilter::className(),
                'actions' => [
                    'delete' => ['POST'],
                ],
            ],
        ];
    }

    /**
     * Lists all Wstoredispatch models.
     * @return mixed
     */
    public function actionIndex()
    {
        $searchModel = new WstoredispatchSearch();
        $dataProvider = $searchModel->search(Yii::$app->request->queryParams);

        return $this->render('index', [
            'searchModel' => $searchModel,
            'dataProvider' => $dataProvider,
        ]);
    }

    /**
     * Displays a single Wstoredispatch model.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionView($id)
    {
        
        
        $model=new Dispatchcontents();
        
        return $this->render('view', [
            'model' => $this->findModel($id),
        ]);
    }

    /**
     * Creates a new Wstoredispatch model.
     * If creation is successful, the browser will be redirected to the 'view' page.
     * @return mixed
     */
    public function actionCreateOld()
    {
        $model = new Wstoredispatch();
        
        if ($model->load(Yii::$app->request->post())) {
            $model->date=date('Y-m-d');
            $dublicate=Wstoredispatch::checkDublicate($model->truckId);
            if($dublicate==null){
                    if($model->save()){
                        Defectivetrucks::changeTruckDispatchStatus($model->truckId);
                        \Yii::$app->session->setFlash('success','Successfull saved new request');
                    return $this->redirect(['dispatchcontents/create','id'=>$model->id]);
                    
                    }
            }else{
                foreach ($dublicate as $dub){
                    return $this->redirect(['dispatchcontents/create','id'=>$dub->id]);
                }
            }
        }
        
        if (\Yii::$app->request->isAjax){
            return $this->renderAjax('create', [
                'model' => $model,
            ]);
        }else{
            return $this->render('create', [
                'model' => $model,
            ]);
        }
    }
    
    
    public function actionCreate()
    {
        $modelbill = new Wstoredispatch();
        $modelbillcontent = [new Dispatchcontents()];
        
        if ($modelbill->load(Yii::$app->request->post())) {
            
            $modelbill->date=date('Y-m-d');
            $dublicate=Wstoredispatch::checkDublicate($modelbill->truckId);
            
            $modelbillcontent= Model::createMultiple(Dispatchcontents::classname());
            Model::loadMultiple($modelbillcontent, Yii::$app->request->post());
            
            
            
            // validate all models
            $valid = $modelbill->validate();
            
            if ($valid && $dublicate==null) {
                $transaction = \Yii::$app->db->beginTransaction();
                try {
                    if ($flag = $modelbill->save(false)) {
                        
                        foreach ($modelbillcontent as $billcont) {
                            
                            
                            $billcont->dispatchId = $modelbill->id;
                            $balance=Dispatchcontents::getStoreBalance($billcont->storeId);
                            $valid=$billcont->validate();
                            if ($valid && $balance>=$billcont->quantity){
                                
                                if (! ($flag = $billcont->save(false))) {
                                    $transaction->rollBack();
                                    break;
                                }
                                
                            }else{
                                \Yii::$app->session->setFlash('error','Validation error or Store balance can not handle the assignment');
                                $transaction->rollBack();
                                return $this->redirect(['create']);
                                break;
                            }
                        }
                    }
                    if ($flag) {
                        \Yii::$app->session->setFlash('success','Successfull dispatched from store');
                        $transaction->commit();
                        return $this->redirect(['index']);
                    }
                } catch (Exception $e) {
                    $transaction->rollBack();
                }
            }else{
                \Yii::$app->session->setFlash('error','Error on the validation or dublicate dispatch for the truck');
            }
        }
        
            return $this->render('create', [
                'modelbill' => $modelbill,
                'modelbillcontent' => (empty($modelbillcontent)) ? [new Dispatchcontents()] : $modelbillcontent
            ]);
            
    }
    
   

    /**
     * Updates an existing Wstoredispatch model.
     * If update is successful, the browser will be redirected to the 'view' page.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionUpdate($id)
    {
        $model = $this->findModel($id);

        if ($model->load(Yii::$app->request->post()) && $model->save()) {
            return $this->redirect(['view', 'id' => $model->id]);
        }

        return $this->render('update', [
            'model' => $model,
        ]);
    }

    /**
     * Deletes an existing Wstoredispatch model.
     * If deletion is successful, the browser will be redirected to the 'index' page.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionDelete($id)
    {
        $this->findModel($id)->delete();

        return $this->redirect(['index']);
    }

    /**
     * Finds the Wstoredispatch model based on its primary key value.
     * If the model is not found, a 404 HTTP exception will be thrown.
     * @param integer $id
     * @return Wstoredispatch the loaded model
     * @throws NotFoundHttpException if the model cannot be found
     */
    protected function findModel($id)
    {
        if (($model = Wstoredispatch::findOne($id)) !== null) {
            return $model;
        }

        throw new NotFoundHttpException('The requested page does not exist.');
    }
    
    public function actionReport()
    { 
        $this->layout='main';
        $model = new Wstoredispatch();
        
        if (isset($_POST['Wstoredispatch'])) {
            
            if($_POST['Wstoredispatch']['to'] >= $_POST['Wstoredispatch']['from']){
                
                $data = $this->renderPartial('_reportview',['from'=>$_POST['Wstoredispatch']['from'],'to'=>$_POST['Wstoredispatch']['to']]);
                
                $pdf = new Pdf([
                    'mode' => Pdf::MODE_CORE,
                    'format' => Pdf::FORMAT_A4,
                    'orientation' => Pdf::ORIENT_PORTRAIT,
                    'destination' => Pdf::DEST_BROWSER,
                    'content' => $data,
                    'cssFile' => '@vendor/kartik-v/yii2-mpdf/src/assets/kv-mpdf-bootstrap.min.css',
                    'cssInline' => '.kv-heading-1{font-size:18px}',
                    'options' => ['title' => 'spare utilization report'],
                    'methods' => [
                        'SetFooter'=>['{PAGENO}'],
                    ]
                ]);
                
                return $pdf->render();
            }else{
                \Yii::$app->session->setFlash('error','From can not be greater than to');
            }
            }
            
            return $this->render('report', [
                'model' => $model,
            ]);
        }
        
        
        public function actionReportbycar()
        {
            $this->layout='main';
            $model = new Wstoredispatch();
            
            if (isset($_POST['Wstoredispatch'])) {
                
                if($_POST['Wstoredispatch']['to'] >= $_POST['Wstoredispatch']['from']){
        
                    $data = $this->renderPartial('_bycarreport',['from'=>$_POST['Wstoredispatch']['from'],'to'=>$_POST['Wstoredispatch']['to'],'carId'=>$_POST['Wstoredispatch']['truckId']]);
                    
                    $pdf = new Pdf([
                        'mode' => Pdf::MODE_CORE,
                        'format' => Pdf::FORMAT_A4,
                        'orientation' => Pdf::ORIENT_PORTRAIT,
                        'destination' => Pdf::DEST_BROWSER,
                        'content' => $data,
                        'cssFile' => '@vendor/kartik-v/yii2-mpdf/src/assets/kv-mpdf-bootstrap.min.css',
                        'cssInline' => '.kv-heading-1{font-size:18px}',
                        'options' => ['title' => 'spare utilization report'],
                        'methods' => [
                            'SetFooter'=>['{PAGENO}'],
                        ]
                    ]);
                    
                    return $pdf->render();
                }
            }
            
            return $this->render('reportbycar', [
                'model' => $model,
            ]);
         
        }
        
        
                public function actionReportbycardirect($id,$f,$t)
        {
            $this->layout='main';
           
                    
                    $data = $this->renderPartial('_bycarreport',['from'=>$f,'to'=>$t,'carId'=>$id]);
                    
                    $pdf = new Pdf([
                        'mode' => Pdf::MODE_CORE,
                        'format' => Pdf::FORMAT_A4,
                        'orientation' => Pdf::ORIENT_PORTRAIT,
                        'destination' => Pdf::DEST_BROWSER,
                        'content' => $data,
                        'cssFile' => '@vendor/kartik-v/yii2-mpdf/src/assets/kv-mpdf-bootstrap.min.css',
                        'cssInline' => '.kv-heading-1{font-size:18px}',
                        'options' => ['title' => 'spare utilization report'],
                        'methods' => [
                            'SetFooter'=>['{PAGENO}'],
                        ]
                    ]);
                    
                    return $pdf->render();
           
            
        }
        
        
}
