<?php

namespace app\controllers;

use Yii;
use app\models\Billcontent;
use app\models\Wshopbills;
use app\models\WshopbillsSearch;
use yii\web\Controller;
use yii\web\NotFoundHttpException;
use yii\filters\VerbFilter;
use app\models\Billpayments;
use app\models\Bills;

/**
 * WshopbillsController implements the CRUD actions for Wshopbills model.
 */
class WshopbillsController extends Controller
{
    
    public function init() {
        
        if (\Yii::$app->session->get('layout') != null){
            $this->layout = \Yii::$app->session->get('layout');
        }else{
            $this->layout ='workshop';
        }
    }
    /**
     * {@inheritdoc}
     */
    public function behaviors()
    {
        return [
            'verbs' => [
                'class' => VerbFilter::className(),
                'actions' => [
                    'delete' => ['POST'],
                ],
            ],
        ];
    }

    /**
     * Lists all Wshopbills models.
     * @return mixed
     */
    public function actionIndex()
    {
        $searchModel = new WshopbillsSearch();
        $dataProvider = $searchModel->search(Yii::$app->request->queryParams);

        return $this->render('index', [
            'searchModel' => $searchModel,
            'dataProvider' => $dataProvider,
        ]);
    }

    /**
     * Displays a single Wshopbills model.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionView($id)
    {
        return $this->render('view', [
            'model' => $this->findModel($id),
        ]);
    }

    /**
     * Creates a new Wshopbills model.
     * If creation is successful, the browser will be redirected to the 'view' page.
     * @return mixed
     */
    public function actionCreate($id)
    {
        $model2 = Wshopbills::findOne($id);
        $billpay=new Billpayments();
        $model=new Wshopbills();
        
        
            $model2->status=1;
            
            if ($model2->save()){
                if(isset($_POST['Wshopbills'])) {
                $billpay->accountId=$_POST['Wshopbills']['accountId'];
                $billpay->amount=$_POST['Wshopbills']['amount'];
                $billpay->checkNo=$_POST['Wshopbills']['checkNo'];
                $billpay->billId=$model2->billid;
                $billpay->date=date('Y-m-d');
                $billpay->userId=\Yii::$app->user->getId();
                $billpay->company=\Yii::$app->session->get('company');
                if ($billpay->save()){
                    $bill=Bills::findOne($model2->billid);
                    $bill->paid=1;
                    if ($bill->save()){
                        return $this->redirect(['index']);
                    }
                }else{
                    $model2->status=0;
                    $model2->save();
                    \Yii::$app->session->setFlash('error','Error on saving bill payments '.$billpay->accountId);
                    }
                }
            }

        return $this->render('create', [
            'model' => $model,'id'=>$model2->billid,
        ]);
    }
    
    public function actionCreatepayment($id)
    {
        $model = Wshopbills::findOne($id);
        $model->status=1;
        
        if ($model->save()){
            return $this->redirect(['index']);
        }
    }

    /**
     * Updates an existing Wshopbills model.
     * If update is successful, the browser will be redirected to the 'view' page.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionUpdate($id)
    {
        $model = $this->findModel($id);

        if ($model->load(Yii::$app->request->post()) && $model->save()) {
            return $this->redirect(['view', 'id' => $model->id]);
        }

        return $this->render('update', [
            'model' => $model,
        ]);
    }

    /**
     * Deletes an existing Wshopbills model.
     * If deletion is successful, the browser will be redirected to the 'index' page.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionDelete($id)
    {
        $billId= $this->findModel($id)->billid;
        if (Billcontent::getBillCost($billId)==0){
        if($this->findModel($id)->delete()){
            \Yii::$app->session->setFlash('success','Successfull deleted a request');
            $bill= Bills::findOne($billId);
            $bill->delete();
             }
        }else{
            \Yii::$app->session->setFlash('error','The request has content, can not be deleted');
        }
        return $this->redirect(['index']);
    }

    /**
     * Finds the Wshopbills model based on its primary key value.
     * If the model is not found, a 404 HTTP exception will be thrown.
     * @param integer $id
     * @return Wshopbills the loaded model
     * @throws NotFoundHttpException if the model cannot be found
     */
    protected function findModel($id)
    {
        if (($model = Wshopbills::findOne($id)) !== null) {
            return $model;
        }

        throw new NotFoundHttpException('The requested page does not exist.');
    }
}
