<?php

namespace app\controllers;

use Yii;
use app\models\Uzers;
use app\models\UzersSearch;
use yii\web\Controller;
use yii\web\NotFoundHttpException;
use yii\filters\VerbFilter;
use Faker\Provider\DateTime;
use yii\web\IdentityInterface;
use phpDocumentor\Reflection\Types\Null_;
use Codeception\Lib\Connector\Yii2;
use app\models\Ukers;
use app\models\Salaries;

/**
 * UzersController implements the CRUD actions for Uzers model.
 */
class UzersController extends Controller 
{
    
        public function init() {
        
        if (\Yii::$app->session->get('layout') != null){
            $this->layout = \Yii::$app->session->get('layout');
        }else{
            $this->layout ='main';
        }
        
    }
    
    /**
     * {@inheritdoc}
     */
    public function behaviors()
    {
        return [
            'verbs' => [
                'class' => VerbFilter::className(),
                'actions' => [
                    'delete' => ['POST'],
                ],
            ],
        ];
    }

    /**
     * Lists all Uzers models.
     * @return mixed
     */
    public function actionIndex()
    {
        $searchModel = new UzersSearch();
        $dataProvider = $searchModel->search(Yii::$app->request->queryParams);

        return $this->render('index', [
            'searchModel' => $searchModel,
            'dataProvider' => $dataProvider,
        ]);
    }
    
    
    public function actionDashboard()
    {
         $this->layout='main';
        \Yii::$app->session->set('fileId', null);
        \Yii::$app->session->set('layout', null);
        return $this->render('dashboard');
    }

    /**
     * Displays a single Uzers model.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionView($id)
    {
        return $this->render('view', [
            'model' => $this->findModel($id),
        ]);
    }

    /**
     * Creates a new Uzers model.
     * If creation is successful, the browser will be redirected to the 'view' page.
     * @return mixed
     */
    public function actionCreate()
    {
        $model = new Uzers();
        $salaries = new Salaries();

        if ($model->load(Yii::$app->request->post()) && $salaries->load(Yii::$app->request->post())){
         if ($model->password==$model->repeatpassword) {
             $model->employeddate=date('Y-m-d',strtotime($model->employeddate));
             $model->birthdate=date('Y-m-d',strtotime($model->birthdate));
             $model->firstname=ucfirst(strtolower($model->firstname));
             $model->secondname=ucfirst(strtolower($model->secondname));
             $model->lastname=ucfirst(strtolower($model->lastname));
             $model->password=Uzers::setPassword($model->password);
             $model->authKey=$model->generateAuthKey();
             $model->licence=$model->licence;
             
             if($model->validate()){
                $salaries->bankacc=$salaries->bankacc;
                $salaries->ssfacc=$salaries->ssfacc;
                $salaries->amount=$salaries->amount;
                $salaries->date=date('Y-m-d');
            
           
             $checkD= Uzers::checkDublicate($model->firstname,$model->lastname);
             
             if ($checkD==null){
                 if ($model->save()) {
                     
                     $salaries->userId=$model->id;
                     
                     if($salaries->save()){
                        return $this->redirect(['view', 'id' => $model->id]);
                      }
                 }
             }else{
                 \Yii::$app->session->setFlash('error', 'duplicate user');
                 return $this->redirect(['update','id'=>$checkD->id]);
             }   }
         }else{
             \Yii::$app->session->setFlash('error', 'Password dont match');
         }
            
           
        }

        return $this->render('create', [
            'model' => $model,'salaries'=>$salaries
        ]);
    }

    /**
     * Updates an existing Uzers model.
     * If update is successful, the browser will be redirected to the 'view' page.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionUpdate($id)
    {
        $model = $this->findModel($id);
        $oldpassword=$model->password;
        $model->employeddate=date('d-M-Y',strtotime($model->employeddate));
        $model->birthdate=date('d-M-Y',strtotime($model->birthdate));
        $model->password=null;
        $salaries= Salaries::find()->where(['userId'=>$id])->orderBy(['id'=>SORT_DESC])->one();
        
        if($salaries == null) $salaries = new Salaries();

        if ($model->load(Yii::$app->request->post()) && $salaries->load(Yii::$app->request->post())) {
            if ($model->password==null){
                $model->password=$oldpassword;
                $model->employeddate=date('Y-m-d',strtotime($model->employeddate));
                $model->birthdate=date('Y-m-d',strtotime($model->birthdate));
                $model->licence=$model->licence;
                
                if($model->save()){
                    
                    $salaries->bankacc=$salaries->bankacc;
                    $salaries->ssfacc=$salaries->ssfacc;
                    $salaries->amount=$salaries->amount;
                    $salaries->date=date('Y-m-d');
                    $salaries->userId=$model->id;
                     
                     if($salaries->save()){
                        \Yii::$app->session->setFlash('success', 'Successfull on updating user');
                        return $this->redirect(['update', 'id' => $model->id]);
                     }
                }
                
            }elseif ($model->password==$model->repeatpassword) {
                $model->password=Uzers::setPassword($model->password);
                $model->repeatpassword=Uzers::setPassword($model->repeatpassword);
                $model->employeddate=date('Y-m-d',strtotime($model->employeddate));
                $model->birthdate=date('Y-m-d',strtotime($model->birthdate));
                $model->licence=$model->licence;
                if($model->save()){
                    
                    $salaries->bankacc=$salaries->bankacc;
                    $salaries->ssfacc=$salaries->ssfacc;
                    $salaries->amount=$salaries->amount;
                    $salaries->date=date('Y-m-d');
                    $salaries->userId=$model->id;
                     
                     if($salaries->save()){
                        \Yii::$app->session->setFlash('success', 'Successfull on updating user');
                        return $this->redirect(['update', 'id' => $model->id]);
                     }
                }
            }else{
                \Yii::$app->session->setFlash('error', 'Password dont match'.$model->password);
                return $this->redirect(['update', 'id' => $model->id]);
            }
          
        }
        
        $model->password=null;
        $model->repeatpassword='';
        return $this->render('update', [
            'model' => $model,'salaries'=>$salaries,
        ]);
    }
    
    public function actionChangepassword($id)
    {
        $this->layout = 'password';
        
        $model = $this->findModel($id);
        $oldpassword=$model->password;
        
        if ($model->load(Yii::$app->request->post())) {
           
           
            if($model->oldpassword==null){
                \Yii::$app->session->setFlash('error', 'Incorrect old password');
                return $this->redirect(['changepassword', 'id' => $model->id]);
            }elseif($model->password==null){
                \Yii::$app->session->setFlash('error', 'You have not set a password');
                return $this->redirect(['changepassword', 'id' => $model->id]);
            }elseif((Yii::$app->security->validatePassword($model->oldpassword,$oldpassword))&&((Yii::$app->security->validatePassword($model->repeatpassword,Uzers::setPassword($model->password))))) {
                $model->password=Uzers::setPassword($model->password);
                
                if($model->save()){
                    \Yii::$app->session->setFlash('success', 'Successfull changed password');
                    Yii::$app->user->logout();
                    return $this->goHome();
                }
            }else{
                \Yii::$app->session->setFlash('error', 'Incorrect old password');
                return $this->redirect(['changepassword', 'id' => $model->id]);
            }
           
        }
        
        $model->password='';
        $model->repeatpassword='';
        return $this->render('changepassword', [
            'model' => $model,
        ]);
    }

    /**
     * Deletes an existing Uzers model.
     * If deletion is successful, the browser will be redirected to the 'index' page.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionDelete($id)
    {
        $this->findModel($id)->delete();

        return $this->redirect(['index']);
    }

    /**
     * Finds the Uzers model based on its primary key value.
     * If the model is not found, a 404 HTTP exception will be thrown.
     * @param integer $id
     * @return Uzers the loaded model
     * @throws NotFoundHttpException if the model cannot be found
     */
    protected function findModel($id)
    {
        if (($model = Uzers::findOne($id)) !== null) {
            return $model;
        }

        throw new NotFoundHttpException('The requested page does not exist.');
    }
    
    public function actionAddusers(){
        $users= Uzers::find()->all();
        
        if ($users != null){
            foreach ($users as $user){
                //$uker=Ukers::getUserCom($user->firstname,$user->lastname);
                /*$salary=new Salaries();
                if ($uker!=null){ 
                    $salary->userId=$user->id;
                    $salary->amount=$uker->salary;
                    $salary->bankacc=$uker->address;
                    $salary->ssfacc=strlen($uker->phoneNo2)!=10?$uker->phoneNo2:0;
                    $salary->date='2019-04-01';
                    $salary->save(); 
                } */
                $user->firstname=ucfirst(strtolower($user->firstname));
                $user->secondname=ucfirst(strtolower($user->secondname));
                $user->lastname=ucfirst(strtolower($user->lastname));
                $user->save();
            }
        }
    }
}
