<?php

namespace app\controllers;

use Yii;
use PHPUnit\Util\Json;
use app\models\Trafficoffences;
use app\models\TrafficoffencesSearch;
use app\models\Offencepayments;
use app\models\Movetype;
use yii\web\Controller;
use yii\web\NotFoundHttpException;
use yii\filters\VerbFilter;
use app\models\Cars;
use kartik\mpdf\Pdf;

/**
 * TrafficoffencesController implements the CRUD actions for Trafficoffences model.
 */
class TrafficoffencesController extends Controller
{
    public function init() {
        
        if (\Yii::$app->session->get('layout') != null){
            $this->layout = \Yii::$app->session->get('layout');
        }else{
            $this->layout = 'operations';
        }
        
    }
    /**
     * {@inheritdoc}
     */
    public function behaviors()
    {
        return [
            'verbs' => [
                'class' => VerbFilter::className(),
                'actions' => [
                    'delete' => ['POST'],
                ],
            ],
        ];
    }

    /**
     * Lists all Trafficoffences models.
     * @return mixed
     */
    public function actionIndex()
    {
        $searchModel = new TrafficoffencesSearch();
        $dataProvider = $searchModel->search(Yii::$app->request->queryParams);

        return $this->render('index', [
            'searchModel' => $searchModel,
            'dataProvider' => $dataProvider,
        ]);
    }
    
        public function actionIndexdepts()
    {
        $f=date('Y-m-d',strtotime('-30 days'));
        $c=\Yii::$app->session->get('company');
        $data = Trafficoffences::find()->where("paiddate>='$f' and type!=1 and company='$c'")->orderBy(['driverId'=>SORT_DESC])->all();

        return $this->render('indexdepts', [ 'data' => $data]);
    }

    /**
     * Displays a single Trafficoffences model.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionView($id)
    {
        $model=$this->findModel($id);
        if($model->paiddate=='0000-00-00') $model->paiddate=null;
        
        if ($model->load(Yii::$app->request->post())) {
            $model->paiddate=date('Y-m-d',strtotime($model->paiddate));
            
            //$daysdifference = Trafficoffences::getdatediffindays($model-paiddate);
            
            //if($daysdifference < 60){
	            if($model->save()){
	                \Yii::$app->session->setFlash('success','Successfull saved an offence');
	                return $this->redirect(['index']);
	            }else {
	                \Yii::$app->session->setFlash('error','Error on paid date');
	                $model=$this->findModel($id);
	            }
	   /* }else{
                \Yii::$app->session->setFlash('error','Error on paid date');
                $model=$this->findModel($id);
            } */
        }
        
        return $this->render('view', [
            'model' =>$model,
        ]);
    }

    /**
     * Creates a new Trafficoffences model.
     * If creation is successful, the browser will be redirected to the 'view' page.
     * @return mixed
     */
    public function actionCreate()
    {
        $model = new Trafficoffences();

        if ($model->load(Yii::$app->request->post())) {
            
            $model->offencedate=date('Y-m-d',strtotime($model->offencedate));
            $model->company=\Yii::$app->session->get('company');
            $model->type=1;
            $duplicate= Trafficoffences::checkDublicate($model->ref);
            
            if ($duplicate==null){
            if($model->save()){
                \Yii::$app->session->setFlash('success','Successfull saved an offence');
            return $this->redirect(['index']);
            }
            }else {
                \Yii::$app->session->setFlash('error','A dublicate offence');
                return $this->redirect(['update', 'id' => $duplicate]);
            }
        }

        if (\Yii::$app->request->isAjax){
            return $this->renderAjax('create', [
                'model' => $model,
            ]);
        }else{
            return $this->render('create', [
                'model' => $model,
            ]);
        }
    }
    
    
       public function actionCreatefuel()
    {
        $model = new Trafficoffences();

        if ($model->load(Yii::$app->request->post())) {
            
            $model->offencedate=date('Y-m-d',strtotime($model->offencedate));
            $model->span=$model->span;
            $model->paiddate=date('Y-m-d',strtotime($model->paiddate));
            $model->responsible=2;
            $model->ref='penalty';
            $model->location='itl';
            $model->officer='itlof';
            $model->reason=$model->offencedate.' - '. $model->reason;
            $model->company=\Yii::$app->session->get('company');
            
            
            if($model->save()){
                \Yii::$app->session->setFlash('success','Successfull saved driver penalty');
            return $this->redirect(['indexdepts']);
            }
           
        }

        if (\Yii::$app->request->isAjax){
            return $this->renderAjax('createfuel', [
                'model' => $model,
            ]);
        }else{
            return $this->render('createfuel', [
                'model' => $model,
            ]);
        }
    }
    
    
       public function actionCreateworkshop()
    {
        $model = new Trafficoffences();

        if ($model->load(Yii::$app->request->post())) {
            
            $model->offencedate=date('Y-m-d',strtotime($model->offencedate));
            $model->company=\Yii::$app->session->get('company');
            $model->paiddate=date('Y-m-d',strtotime($model->paiddate));
            $model->type=2;
            $model->reason=$model->offencedate.' - '. $model->reason;
            $duplicate= Trafficoffences::checkDublicate($model->ref);
            
            if ($duplicate==null){
            if($model->save()){
                \Yii::$app->session->setFlash('success','Successfull saved an offence');
            return $this->redirect(['indexdepts']);
            }
            }else {
                \Yii::$app->session->setFlash('error','A dublicate offence');
                return $this->redirect(['update', 'id' => $duplicate]);
            }
        }

        if (\Yii::$app->request->isAjax){
            return $this->renderAjax('createworkshop', [
                'model' => $model,
            ]);
        }else{
            return $this->render('createworkshop', [
                'model' => $model,
            ]);
        }
    }

    /**
     * Updates an existing Trafficoffences model.
     * If update is successful, the browser will be redirected to the 'view' page.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionUpdate($id)
    {
        $model = $this->findModel($id);
        
        $model->offencedate=date('d-m-Y',strtotime($model->offencedate));
        $model->paiddate=date('d-m-Y',strtotime($model->paiddate));

        if ($model->load(Yii::$app->request->post())) {
            $model->offencedate=date('Y-m-d',strtotime($model->offencedate));
            $model->paiddate=date('Y-m-d',strtotime($model->paiddate));
            
            if($model->save()){
            return $this->redirect(['indexdepts']);
            }
        }

        return $this->render('update', [
            'model' => $model,
        ]);
    }
    
    
        public function actionBringbackward($id)
    {
        $model = $this->findModel($id);
        
        $paids=Offencepayments::find()->where("offenceid='$id'")->all();
                 $totalpaid=0;
                 if($paids != null){
                     foreach($paids as $pds){
                         $totalpaid=$totalpaid + $pds->amount;
                     }
                 }
        if($totalpaid==$model->Amount){
             $model->paiddate=date('Y-m-d',strtotime('-1 month', strtotime($model->paiddate)));
             $model->save();
        }

        return $this->redirect(['indexdepts']);
    }

    /**
     * Deletes an existing Trafficoffences model.
     * If deletion is successful, the browser will be redirected to the 'index' page.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionDelete($id)
    {
        $this->findModel($id)->delete();

        return $this->redirect(['index']);
    }

    /**
     * Finds the Trafficoffences model based on its primary key value.
     * If the model is not found, a 404 HTTP exception will be thrown.
     * @param integer $id
     * @return Trafficoffences the loaded model
     * @throws NotFoundHttpException if the model cannot be found
     */
    protected function findModel($id)
    {
        if (($model = Trafficoffences::findOne($id)) !== null) {
            return $model;
        }

        throw new NotFoundHttpException('The requested page does not exist.');
    }
    
    
    public function actionSearchCar($selected)
    {   
        echo json_encode($selected);
    }
    
    public function actionPrintoffences(){
        
        $paid='0000-00-00';
        
        $offences= Trafficoffences::find()
        ->where("paiddate='$paid'")->all();
        
        $data = $this->renderPartial('_printoffence',['offences'=>$offences]);
        
        $pdf = new Pdf([
            'mode' => Pdf::MODE_CORE,
            'format' => Pdf::FORMAT_A4,
            'orientation' => Pdf::ORIENT_PORTRAIT,
            'destination' => Pdf::DEST_BROWSER,
            'content' => $data,
            'cssFile' => '@vendor/kartik-v/yii2-mpdf/src/assets/kv-mpdf-bootstrap.min.css',
            'cssInline' => '.kv-heading-1{font-size:18px}',
            'options' => ['title' => 'Unpaid traffic offences'],
            'methods' => [
                'SetFooter'=>['{PAGENO}'],
            ]
        ]);
        
        return $pdf->render();
    }
    
    
    public function actionReport(){
        
        $this->layout='main';
        
        $model = new Trafficoffences();
        
        if (isset($_POST['Trafficoffences'])) {
            
            if($_POST['Trafficoffences']['to'] >= $_POST['Trafficoffences']['from']){
                $f=date('Y-m-d',strtotime($_POST['Trafficoffences']['from']));
                $t=date('Y-m-d',strtotime($_POST['Trafficoffences']['to']));
                
            $offences= Trafficoffences::find()->where("offencedate >='$f' and offencedate<='$t'") ->orderBy(['location'=>SORT_DESC])->all();
        
            $data = $this->renderPartial('_reportview',['offences'=>$offences,'from'=>$_POST['Trafficoffences']['from'],'to'=>$_POST['Trafficoffences']['to']]);
        
        $pdf = new Pdf([
            'mode' => Pdf::MODE_CORE,
            'format' => Pdf::FORMAT_A4,
            'orientation' => Pdf::ORIENT_LANDSCAPE,
            'destination' => Pdf::DEST_BROWSER,
            'content' => $data,
            'cssFile' => '@vendor/kartik-v/yii2-mpdf/src/assets/kv-mpdf-bootstrap.min.css',
            'cssInline' => '.kv-heading-1{font-size:18px}',
            'options' => ['title' => 'Unpaid traffic offences'],
            'methods' => [
                'SetFooter'=>['{PAGENO}'],
            ]
        ]);
        
        return $pdf->render();
            }else{
                \Yii::$app->session->setFlash('error','From can not be greater than to');
            }
        }
        
        return $this->render('report', [
            'model' => $model,
        ]);
    }
    
    
    public function actionAnalyseoffences(){
        
        $dt=date('Y-m-d');  $f=date('Y-m').'-1';  $t=date('Y-m').'-31';
        $from=date('Y-m-d',strtotime('-1 month', strtotime($f)));
        $to=date('Y-m-d',strtotime('-1 month', strtotime($t)));
        $ince=0;
        $c=0;
        
        $offences= Trafficoffences::find()->where("responsible=2 and type!=1 and paiddate >= '$dt' and offencedate <= '$dt'")->all();
        
        if ($offences !=null){
            foreach ($offences as $offence){
                $wasrecorded=null;
               
                 //Check on the paidtable total amount of paid offences 
                 $paids=Offencepayments::find()->where("offenceid='$offence->id'")->all();
                 $totalpaid=0;
                 if($paids != null){
                     foreach($paids as $pds){
                         if(date('m-Y',strtotime($pds->date)) == date('m-Y')){
                             $wasrecorded=1;
                         }
                         $totalpaid=$totalpaid + $pds->amount;
                     }
                 }
                 
                 
                if($wasrecorded==null){
                       $ded= $offence->Amount/$offence->span;
                       $ince=Movetype::driverIncentiveByTime($offence->driverId,$from,$to);
                       
                if($ince['incentive']>=$ded and $ded<=200000 and $totalpaid<$offence->Amount){
                   $payrec=new Offencepayments();
                   $payrec->offenceid=$offence->id;
                   $payrec->date=date('Y-m-d');
                   $payrec->amount=round($ded);
                   if($payrec->save()){
                       $c++;
                   }else{
                       \Yii::$app->session->setFlash('error',$ded.' Saving error');
                       break;
                   }
                   $totalpaid=$totalpaid + round($ded);
                }else{
                   $updateoffence= Trafficoffences::findOne($offence->id);
                   $updateoffence->paiddate=date('Y-m-d',strtotime('+1 month',strtotime($offence->paiddate)));
                   $updateoffence->save(); 
               }
                  }
            } 
             \Yii::$app->session->setFlash('success',$c.' Callibration completed');
        }
        
        return $this->redirect(['indexdepts']);
        
    }
    
}