<?php

namespace app\controllers;

use Yii;
use app\models\Tireallocation;
use app\models\TireallocationSearch;
use yii\web\Controller;
use yii\web\NotFoundHttpException;
use yii\filters\VerbFilter;
use app\models\Tirestore;
use yii\data\ActiveDataProvider;
use kartik\mpdf\Pdf;

/**
 * TireallocationController implements the CRUD actions for Tireallocation model.
 */
class TireallocationController extends Controller
{
    public function init() {
        
        if (\Yii::$app->session->get('layout') != null){
            $this->layout = \Yii::$app->session->get('layout');
        }else{
            $this->layout = 'workshop';
        }
    }
    
    /**
     * {@inheritdoc}
     */
    public function behaviors()
    {
        return [
            'verbs' => [
                'class' => VerbFilter::className(),
                'actions' => [
                    'delete' => ['POST'],
                ],
            ],
        ];
    }

    /**
     * Lists all Tireallocation models.
     * @return mixed
     */
    public function actionIndex()
    {
        $searchModel = new TireallocationSearch();
        $dataProvider = $searchModel->search(Yii::$app->request->queryParams);

        return $this->render('index', [
            'searchModel' => $searchModel,
            'dataProvider' => $dataProvider,
        ]);
    }

    /**
     * Displays a single Tireallocation model.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionView($id)
    {
        return $this->render('view', [
            'model' => $this->findModel($id),
        ]);
    }

    /**
     * Creates a new Tireallocation model.
     * If creation is successful, the browser will be redirected to the 'view' page.
     * @return mixed
     */
    public function actionCreate($id)
    {
        $model = new Tireallocation();
        
        $query = Tireallocation::find();
        $query->andFilterWhere([
            'carId' => $id,
            'status'=>1,
        ]);
        
        // add conditions that should always apply here
        
        $dataProvider = new ActiveDataProvider([
            'query' => $query,
        ]);

        if ($model->load(Yii::$app->request->post())) {
            
            $model->carId=$id;
            $model->date=date('Y-m-d',strtotime($model->date));
            
            if (Tirestore::findOne($model->storeId)->status==1){
            if ($model->save()){
                $store=Tirestore::findOne($model->storeId);
                $store->status=0;
                $store->save();
                return $this->redirect(['create', 'id' => $id]);
            }
           }else{
               \Yii::$app->session->setFlash('error','Less stock than allocated number of tires');
           }
        }

        return $this->render('create', [
            'model' => $model,'truckno'=>$id,'dataProvider'=>$dataProvider
        ]);
    }
    
    
    public function actionCreatefromstore($id)
    {
        $model = new Tireallocation();
    
        
        if ($model->load(Yii::$app->request->post())) {
            
            $model->storeId=$id;
            $model->date=date('Y-m-d',strtotime($model->date));
            
            if (Tirestore::findOne($id)->status!=0){
                if ($model->save()){
                    $store=Tirestore::findOne($id);
                    $store->status=0;
                    $store->save();
                    return $this->redirect(['tirestore/index']);
                }
            }else{
                $all=Tireallocation::find()->where(['storeId'=>$id])->one();
                if ($all != null){
                    return $this->redirect(['create','id'=>$all->carId]);
                }
                \Yii::$app->session->setFlash('error','This tire is allocated to other truck');
            }
        }
        
        return $this->render('createfromstore', [
            'model' => $model
        ]);
    }

    /**
     * Updates an existing Tireallocation model.
     * If update is successful, the browser will be redirected to the 'view' page.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionUpdate($id)
    {
        $model = $this->findModel($id);
        $tirestore = Tirestore::find()->where(['id'=>$model->storeId])->one();

        if ($model->load(Yii::$app->request->post()) && $tirestore->load(Yii::$app->request->post())) {
            
            if($model->save() && $tirestore->save()){
             return $this->redirect(['cars/view', 'id' => $model->carId]);
            }
        }

        return $this->render('update', [
            'model' => $model,'tirestore'=>$tirestore,
        ]);
    }
    
        public function actionReplace($id)
    {
        $model = $this->findModel($id);
        $model->status=0;
        $model->save();
        
        return $this->redirect(['create','id'=>$model->carId]);
        
    }

    /**
     * Deletes an existing Tireallocation model.
     * If deletion is successful, the browser will be redirected to the 'index' page.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionDelete($id)
    {
        $store= $this->findModel($id);
        
        if($this->findModel($id)->delete()){
            Tirestore::findOne($store->storeId)->delete();
        }

        return $this->redirect(['create','id'=>$store->carId]);
    }

    /**
     * Finds the Tireallocation model based on its primary key value.
     * If the model is not found, a 404 HTTP exception will be thrown.
     * @param integer $id
     * @return Tireallocation the loaded model
     * @throws NotFoundHttpException if the model cannot be found
     */
    protected function findModel($id)
    {
        if (($model = Tireallocation::findOne($id)) !== null) {
            return $model;
        }

        throw new NotFoundHttpException('The requested page does not exist.');
    }
    
        public function actionTrucktires($truckId)
    {
        
        $data = $this->renderPartial('_reportview',['truckId'=>$truckId]);
        
        $pdf = new Pdf([
            'mode' => Pdf::MODE_CORE,
            'format' => Pdf::FORMAT_A4,
            'orientation' => Pdf::ORIENT_PORTRAIT,
            'destination' => Pdf::DEST_BROWSER,
            'content' => $data,
            'cssFile' => '@vendor/kartik-v/yii2-mpdf/src/assets/kv-mpdf-bootstrap.min.css',
            'cssInline' => '.kv-heading-1{font-size:18px}',
            'options' => ['title' => 'Fuel report'],
            'methods' => [
                'SetFooter'=>['{PAGENO}'],
            ]
        ]);
        
        return $pdf->render();
        
    }
    
    
        public function actionPrinttruckstatus()
    {
        
        $data = $this->renderPartial('_statusview');
        
        $pdf = new Pdf([
            'mode' => Pdf::MODE_CORE,
            'format' => Pdf::FORMAT_A4,
            'orientation' => Pdf::ORIENT_PORTRAIT,
            'destination' => Pdf::DEST_BROWSER,
            'content' => $data,
            'cssFile' => '@vendor/kartik-v/yii2-mpdf/src/assets/kv-mpdf-bootstrap.min.css',
            'cssInline' => '.kv-heading-1{font-size:18px}',
            'options' => ['title' => 'Fuel report'],
            'methods' => [
                'SetFooter'=>['{PAGENO}'],
            ]
        ]);
        
        return $pdf->render();
        
    }
    
    
    public function actionStatusoftrucks(){
        
        return $this->render('statusoftrucks');
        
    }
    
    
}
