<?php

namespace app\controllers;

use Yii;
use app\models\Techassign;
use app\models\TechassignSearch;
use yii\web\Controller;
use yii\web\NotFoundHttpException;
use yii\filters\VerbFilter;

/**
 * TechassignController implements the CRUD actions for Techassign model.
 */
class TechassignController extends Controller
{
    
    public function init() {
        
        if (\Yii::$app->session->get('layout') != null){
            $this->layout = \Yii::$app->session->get('layout');
        }else{
            $this->layout = 'workshop';
        }
       
    }
    
    
    /**
     * {@inheritdoc}
     */
    public function behaviors()
    {
        return [
            'verbs' => [
                'class' => VerbFilter::className(),
                'actions' => [
                    'delete' => ['POST'],
                ],
            ],
        ];
    }

    /**
     * Lists all Techassign models.
     * @return mixed
     */
    public function actionIndex()
    {
        $searchModel = new TechassignSearch();
        $dataProvider = $searchModel->search(Yii::$app->request->queryParams);

        return $this->render('index', [
            'searchModel' => $searchModel,
            'dataProvider' => $dataProvider,
        ]);
    }

    /**
     * Displays a single Techassign model.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionView($id)
    {
        return $this->render('view', [
            'model' => $this->findModel($id),
        ]);
    }

    /**
     * Creates a new Techassign model.
     * If creation is successful, the browser will be redirected to the 'view' page.
     * @return mixed
     */
    public function actionCreate($dId)
    {
        $model = new Techassign();

        if ($model->load(Yii::$app->request->post())) {
            $model->date=date('Y-m-d');
            $model->defectiveId=$dId;
            if($model->save()){
            return $this->redirect(['defectivetrucks/view', 'id' => $dId]);
            }
        }

        if (\Yii::$app->request->isAjax){
            return $this->renderAjax('create', [
            'model' => $model,'dId'=>$dId,
        ]);
        }else{
            return $this->render('create', [
                'model' => $model,'dId'=>$dId,
            ]);
        }
    }

    /**
     * Updates an existing Techassign model.
     * If update is successful, the browser will be redirected to the 'view' page.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionUpdate($id)
    {
        $model = $this->findModel($id);

        if ($model->load(Yii::$app->request->post()) && $model->save()) {
            return $this->redirect(['view', 'id' => $model->id]);
        }

        return $this->render('update', [
            'model' => $model,
        ]);
    }

    /**
     * Deletes an existing Techassign model.
     * If deletion is successful, the browser will be redirected to the 'index' page.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionDelete($id)
    {
        $dd=$this->findModel($id)->defectiveId;
        $this->findModel($id)->delete();

        return $this->redirect(['defectivetrucks/view','id'=>$dd]);
    }

    /**
     * Finds the Techassign model based on its primary key value.
     * If the model is not found, a 404 HTTP exception will be thrown.
     * @param integer $id
     * @return Techassign the loaded model
     * @throws NotFoundHttpException if the model cannot be found
     */
    protected function findModel($id)
    {
        if (($model = Techassign::findOne($id)) !== null) {
            return $model;
        }

        throw new NotFoundHttpException('The requested page does not exist.');
    }
}
