<?php

namespace app\controllers;

use Yii;
use yii2tech\spreadsheet\Spreadsheet;
use yii\data\ArrayDataProvider;
use kartik\mpdf\Pdf;
use app\models\Accounts;
use app\models\Billcontent;
use app\models\Bills;
use app\models\Services;
use app\models\ServicesSearch;
use yii\web\Controller;
use yii\web\NotFoundHttpException;
use yii\filters\VerbFilter;
use app\models\Servicecost;
use app\models\Wshopbills;

/**
 * ServicesController implements the CRUD actions for Services model.
 */
class ServicesController extends Controller
{
    public function init() {
        
        if (\Yii::$app->session->get('layout') != null){
            $this->layout = \Yii::$app->session->get('layout');
        }else{
            $this->layout = 'accounts';
        }
       
    }
    
    /**
     * {@inheritdoc}
     */
    public function behaviors()
    {
        return [
            'verbs' => [
                'class' => VerbFilter::className(),
                'actions' => [
                    'delete' => ['POST'],
                ],
            ],
        ];
    }

    /**
     * Lists all Services models.
     * @return mixed
     */
    public function actionIndex()
    {
        $searchModel = new ServicesSearch();
        $dataProvider = $searchModel->search(Yii::$app->request->queryParams);

        return $this->render('index', [
            'searchModel' => $searchModel,
            'dataProvider' => $dataProvider,
        ]);
    }

    /**
     * Displays a single Services model.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionView($id)
    {
        return $this->render('view', [
            'model' => $this->findModel($id),
        ]);
    }

    /**
     * Creates a new Services model.
     * If creation is successful, the browser will be redirected to the 'view' page.
     * @return mixed
     */
    public function actionCreate()
    {
        $model = new Services();
        $cost= new Servicecost();

        if ($model->load(Yii::$app->request->post()) && $cost->load(Yii::$app->request->post())) {
            
            $model->company=\Yii::$app->session->get('company');
            $model->date=date('Y-m-d');
            if($model->save()){
                $cost->serviceId=$model->id;
                $cost->onn=date('Y-m-d');
                $cost->byy=\Yii::$app->user->getId();
                if ($cost->save()){
                    \Yii::$app->session->setFlash('success','Successfull saved new service/product');
                    return $this->redirect(Yii::$app->request->referrer ?: Yii::$app->homeUrl);
                }else{
                    $this->findModel($model->id)->delete();
                }
            }
        }
        
        if (\Yii::$app->request->isAjax){
            return $this->renderAjax('create', [
                'model' => $model,'cost'=>$cost,
            ]);
        }else{
            return $this->render('create', [
                'model' => $model,'cost'=>$cost,
            ]);
        }
    }
    
    
    public function actionCreateworkshop()
    {
        $model = new Services();
        $cost= new Servicecost();
        
        if ($model->load(Yii::$app->request->post()) && $cost->load(Yii::$app->request->post())) {
            
            $model->company=\Yii::$app->session->get('company');
            $model->date=date('Y-m-d');
           
                if($model->save()){
                    $cost->serviceId=$model->id;
                    $cost->onn=date('Y-m-d');
                    $cost->byy=\Yii::$app->user->getId();
                    if ($cost->save()){
                        \Yii::$app->session->setFlash('success','Successfull saved new service/product');
                        return $this->redirect(['wshopbills/index',]);
                    }else{
                        $this->findModel($model->id)->delete();
                    }
                }
           
        }
        
        if (\Yii::$app->request->isAjax){
            return $this->renderAjax('createworkshop', [
                'model' => $model,'cost'=>$cost,
            ]);
        }else{
            return $this->render('createworkshop', [
                'model' => $model,'cost'=>$cost,
            ]);
        }
    }

    /**
     * Updates an existing Services model.
     * If update is successful, the browser will be redirected to the 'view' page.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionUpdate($id)
    {
        $model = $this->findModel($id);
        $cost= Servicecost::find()->where(['serviceId'=>$id,'status'=>1])->one();

        if ($model->load(Yii::$app->request->post()) && $cost->load(Yii::$app->request->post())) {
            if ($model->save()){
                if ($cost->save()){
                    \Yii::$app->session->setFlash('success','Successfull updated service/product');
            return $this->redirect(['index']);
                }
            }
        }

        return $this->render('update', [
            'model' => $model,'cost'=>$cost,
        ]);
    }

    /**
     * Deletes an existing Services model.
     * If deletion is successful, the browser will be redirected to the 'index' page.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionDelete($id)
    {
        $service= Services::findOne($id);
        
        $service->status=0;
        
        if ($service->save()){
        return $this->redirect(['index']);
        }
    }

    /**
     * Finds the Services model based on its primary key value.
     * If the model is not found, a 404 HTTP exception will be thrown.
     * @param integer $id
     * @return Services the loaded model
     * @throws NotFoundHttpException if the model cannot be found
     */
    protected function findModel($id)
    {
        if (($model = Services::findOne($id)) !== null) {
            return $model;
        }

        throw new NotFoundHttpException('The requested page does not exist.');
    }
    
    
    
    public function actionReport()
    {
        $this->layout='main';
        $model = new Services();
        
        if (isset($_POST['Services'])) {
            
            if(strtotime($_POST['Services']['to']) >= strtotime($_POST['Services']['from'])){
                
                
                $services=Services::find()-> all();
                
                $count=0;
                $avarage=array();
                $records=array();
                $rm=0;
                $f=date('Y-m-d',strtotime($_POST['Services']['from']));
                $t=date('Y-m-d',strtotime($_POST['Services']['to']));
                
                $moveaverage=array();
                $moverecords=array();
                $moveexpected=0;
                $cnt=0;
                
                if ($services != null){
                    
                    
                    foreach ($services as $service){
                        
                        $amountt=0;
                        $amountu=0;
                        $unicost=0;
                        //$bills= Bills::find()->where("date >= '$f' and date <= '$t' and company=:c",[':c'=>\Yii::$app->session->get('company')])-> all();
                        
                       // if ($bills != null){
                            //foreach ($bills as $bill){
                                
                             
                                
                                    $billcontents=Billcontent::find()->where(['serviceId' =>$service->id])->orderBy(['id'=>SORT_DESC])-> all();
                                
                                if ($billcontents != null){
                                    
                                     foreach ($billcontents as $content){
                                    
                                         $wshopbill=Wshopbills::find()->where(['billid'=>$content->billId])->all();
                                    
                                    if ($wshopbill != null){
                                    $unicost=$content->amount;
                                    }  
                                }
                                
                                }
                                
                          //  }
                       // }
                        if(($unicost) > 0){
                            $records[$count]['service']=$service->name;
                            $records[$count]['cost']=$unicost;
                            $avarage[$count]['av']=$unicost;
                            $count++;
                        }
                    }
                    if ($avarage !=null and $records != null) array_multisort($avarage,SORT_DESC,$records);
                }
                
                $exporter = new Spreadsheet([
                    'dataProvider' => new ArrayDataProvider([
                        'allModels' => $records
                    ]),
                    
                    'columns' => [
                        [
                            'attribute' => 'service',
                            'contentOptions' => [
                                'width' => [
                                    '35px'
                                ],
                            ],
                        ],
                        [
                            'attribute' => 'cost',
                        ],
                    ],
                ]);
                
                return $exporter->send('allspares.xls');
                
            }else{
                \Yii::$app->session->setFlash('error','From can not be greater than to');
            }
        }
        
        return $this->render('report', [
            'model' => $model,
        ]);
    }
     
    
}
