<?php

namespace app\controllers;

use Yii;
use app\models\Salaries;
use app\models\SalariesSearch;
use yii\web\Controller;
use yii\web\NotFoundHttpException;
use yii\filters\VerbFilter;
use app\models\Uzers;
use app\models\Overtime;
use yii2tech\spreadsheet\Spreadsheet;
use yii\data\ArrayDataProvider;
use kartik\mpdf\Pdf;

/**
 * SalariesController implements the CRUD actions for Salaries model.
 */
class SalariesController extends Controller
{
       public function init() {
        
        if (\Yii::$app->session->get('layout') != null){
            $this->layout = \Yii::$app->session->get('layout');
        }else{
            $this->layout = 'accounts';
        }
       
    }
    /**
     * {@inheritdoc}
     */
    public function behaviors()
    {
        return [
            'verbs' => [
                'class' => VerbFilter::className(),
                'actions' => [
                    'delete' => ['POST'],
                ],
            ],
        ];
    }

    /**
     * Lists all Salaries models.
     * @return mixed
     */
    public function actionIndex()
    {
        $users = Uzers::find()->where(['company'=>\Yii::$app->session->get('company'),'status'=>1])->orderBy(['firstname'=>SORT_ASC])->all();
        $reqdate=date('Y-m-d');
        $model = new Salaries();

        if ($model->load(Yii::$app->request->post())) {
            $reqdate=$model->reqdate;
        }
        
        return $this->render('index', [
            'users' => $users,'reqdate'=>$reqdate,
        ]);
    }
        
    public function actionIndexhr()
    {
        $this->layout='hr';
        \Yii::$app->session->set('layout','hr');
        $users = Uzers::find()->where(['company'=>\Yii::$app->session->get('company'),'status'=>1])->orderBy(['firstname'=>SORT_ASC])->all();
        $reqdate=date('Y-m-d');
        $model = new Salaries();
        
        if ($model->load(Yii::$app->request->post())) {
            $reqdate=$model->reqdate;
        }
        
        return $this->render('index', [
            'users' => $users,'reqdate'=>$reqdate,
        ]);
    }

    /**
     * Displays a single Salaries model.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionView($id)
    {
        return $this->render('view', [
            'model' => $this->findModel($id),
        ]);
    }

    /**
     * Creates a new Salaries model.
     * If creation is successful, the browser will be redirected to the 'view' page.
     * @return mixed
     */
    public function actionCreate()
    {
        $model = new Salaries();
        $users = Uzers::find()->where(['company'=>\Yii::$app->session->get('company'),'status'=>1])->orderBy(['firstname'=>SORT_ASC])->all();

        if (isset($_POST['Salaries'])) {
            $check=0;
            foreach ($users as $i=>$user){
                $oldsalary=Salaries::getUserSalary($user->id);
                if ($_POST['Salaries'][$i]['amount']!=null and $oldsalary==null){
                $model = new Salaries();
                $model->userId=$user->id;
                $model->bankacc=$_POST['Salaries'][$i]['bankacc'];
                $model->ssfacc=$_POST['Salaries'][$i]['ssfacc'];
                $model->amount=$_POST['Salaries'][$i]['amount'];
                $model->date=date('Y-m-d');
               
                    if ($model->save()){
                        $check++;   
                       }
                }elseif($_POST['Salaries'][$i]['amount']!=null and $oldsalary!=null){
                $modelup = Salaries::findOne($oldsalary->id);
                $modelup->userId=$user->id;
                $modelup->bankacc=$_POST['Salaries'][$i]['bankacc'];
                $modelup->ssfacc=$_POST['Salaries'][$i]['ssfacc'];
                $modelup->amount=$_POST['Salaries'][$i]['amount'];
                $modelup->date=date('Y-m-d');
               
                    if ($modelup->save()){
                        $check++;   
                       } 
                }
            }
            
           \Yii::$app->session->setFlash('success',$check. ' Users salary modified');
            return $this->redirect(['index']);
        }

            return $this->render('create', [
                'model' => $model,'users'=>$users,
            ]);
    }

    /**
     * Updates an existing Salaries model.
     * If update is successful, the browser will be redirected to the 'view' page.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionUpdate($id)
    {
        $model = $this->findModel($id);

        if ($model->load(Yii::$app->request->post()) && $model->save()) {
            return $this->redirect(['view', 'id' => $model->id]);
        }

        return $this->render('update', [
            'model' => $model,
        ]);
    }
    
    
    public function actionPrintouts()
    {
        $model = new Salaries();
        
        if (isset($_POST['Salaries'])) {
            $dt=$_POST['Salaries']['reqdate'];
            $type=$_POST['Salaries']['type'];
            
            if ($type==1){
            return $this->redirect(['printpayroll','date'=>$dt]);
            }elseif ($type==2){
            return $this->redirect(['printnssf', 'date' =>$dt]);
            }elseif ($type==3){
            return $this->redirect(['printsalaryslip', 'date' =>$dt]);
            }elseif ($type==4){
            return $this->redirect(['printwcf', 'date' =>$dt,'type'=>$type]);
            }elseif ($type==5){
            return $this->redirect(['printbank', 'date' =>$dt]);
            }
        }
        
        return $this->render('printout', [
            'model' => $model,
        ]);
    }
    
    
    public function actionPrintpayroll($date){
        $users = Uzers::find()->where(['company'=>\Yii::$app->session->get('company'),'status'=>1])->orderBy(['firstname'=>SORT_ASC])->all();
        $datas=null;
        $average=null;
        $cnt=0;
        
        foreach ($users as $i=>$user){ 
            
            $salary=Salaries::getUserSalary($user->id);
            $over=Overtime::getUserOvertimeAttime($user->id,$date);
            $over!=null?$ot=$over->amount:$ot=0;
            
            if ($salary != null){
                if ($salary->amount !=0){
            $datas[$cnt]['FULLNAME']=$user->fullName;
            $average[$cnt]['av']=$user->fullName;
            $datas[$cnt]['BASIC']=$salary->amount;
            $datas[$cnt]['OVERTIME']=$ot;
            $g=$ot+$salary->amount;
            $datas[$cnt]['GROSS']=$g;
            $ns=($ot+$salary->amount)*0.1;
            $datas[$cnt]['NSSF']=$ns;
            $gs=$g-$ns;
            $datas[$cnt]['GR-SF']=$gs;
            $pae=Salaries::payeCalculator($gs);
            $datas[$cnt]['P.A.Y.E']=$pae;
            $td=$pae+$ns;
            $datas[$cnt]['TOTAL DED']=$td;
            $datas[$cnt]['NET-PAY']=($g-$td);
            $cnt++;
                }
                
            } 
        }
        
        if ($datas != null and $average != null) array_multisort($average,SORT_ASC,$datas);
     
        $data = $this->renderPartial('_payrollview',['contents'=>$datas,'date'=>$date]);
        
        $pdf = new Pdf([
            'mode' => Pdf::MODE_CORE,
            'format' => Pdf::FORMAT_A4,
            'orientation' => Pdf::ORIENT_LANDSCAPE,
            'destination' => Pdf::DEST_BROWSER,
            'content' => $data,
            'cssFile' => '@vendor/kartik-v/yii2-mpdf/src/assets/kv-mpdf-bootstrap.min.css',
            'cssInline' => '.kv-heading-1{font-size:18px}',
            'options' => ['title' => 'Bills request'],
            'methods' => [
                'SetHeader'=>[''],
                'SetFooter'=>['{PAGENO}'],
            ]
        ]);
        
        return $pdf->render();

        
    }
    
    public function actionPrintnssf($date){
        
        $users = Uzers::find()->where(['company'=>\Yii::$app->session->get('company'),'status'=>1])->orderBy(['firstname'=>SORT_ASC])->all();
        $datas=null;
        $average=null;
        $cnt=0;
        
        foreach ($users as $i=>$user){
            
            $salary=Salaries::getUserSalary($user->id);
            $over=Overtime::getUserOvertimeAttime($user->id,$date);
            $over!=null?$ot=$over->amount:$ot=0;
            
            if ($salary != null){
                if ($salary->amount !=0){
                    $datas[$cnt]['FULLNAME']=$user->fullName;
                    $average[$cnt]['av']=$user->fullName;
                    $datas[$cnt]['BASIC']=$salary->amount;
                    $datas[$cnt]['OVERTIME']=$ot;
                    $g=$ot+$salary->amount;
                    $datas[$cnt]['GROSS']=$g;
                    $ns=($ot+$salary->amount)*0.1;
                    $datas[$cnt]['NSSF']=$ns;
                    $gs=$g-$ns;
                    $datas[$cnt]['GR-SF']=$gs;
                    $pae=Salaries::payeCalculator($gs);
                    $datas[$cnt]['P.A.Y.E']=$pae;
                    $td=$pae+$ns;
                    $datas[$cnt]['TOTAL DED']=$td;
                    $datas[$cnt]['NET-PAY']=$g-$td;
                    $datas[$cnt]['SSFNO']=$salary->ssfacc;
                    $cnt++;
                    
                }
            }
        }
        
        if ($datas != null and $average != null) array_multisort($average,SORT_ASC,$datas);
        
        $data = $this->renderPartial('_nssfview',['contents'=>$datas,'date'=>$date]);
        
        $pdf = new Pdf([
            'mode' => Pdf::MODE_CORE,
            'format' => Pdf::FORMAT_A4,
            'orientation' => Pdf::ORIENT_PORTRAIT,
            'destination' => Pdf::DEST_BROWSER,
            'content' => $data,
            'cssFile' => '@vendor/kartik-v/yii2-mpdf/src/assets/kv-mpdf-bootstrap.min.css',
            'cssInline' => '.kv-heading-1{font-size:18px}',
            'options' => ['title' => 'Bills request'],
            'methods' => [
                'SetHeader'=>[''],
                'SetFooter'=>['{PAGENO}'],
            ]
        ]);
        
        return $pdf->render();
        
        
        
    }
    
    public function actionPrintsalaryslip($date){
        
        $users = Uzers::find()->where(['company'=>\Yii::$app->session->get('company'),'status'=>1])->orderBy(['firstname'=>SORT_ASC])->all();
        $datas=null;
        $average=null;
        $cnt=0;
        
        foreach ($users as $i=>$user){
            
            $salary=Salaries::getUserSalary($user->id);
            $over=Overtime::getUserOvertimeAttime($user->id,$date);
            $over!=null?$ot=$over->amount:$ot=0;
            
            if ($salary != null){
                if ($salary->amount !=0){
                    $datas[$cnt]['FULLNAME']=$user->fullName;
                    $average[$cnt]['av']=$user->fullName;
                    $datas[$cnt]['BASIC']=$salary->amount;
                    $datas[$cnt]['OVERTIME']=$ot;
                    $g=$ot+$salary->amount;
                    $datas[$cnt]['GROSS']=$g;
                    $ns=($ot+$salary->amount)*0.1;
                    $datas[$cnt]['NSSF']=$ns;
                    $gs=$g-$ns;
                    $datas[$cnt]['GR-SF']=$gs;
                    $pae=Salaries::payeCalculator($gs);
                    $datas[$cnt]['P.A.Y.E']=$pae;
                    $td=$pae+$ns;
                    $datas[$cnt]['TOTAL DED']=$td;
                    $datas[$cnt]['NET-PAY']=$g-$td;
                    $datas[$cnt]['SSFNO']=$salary->ssfacc;
                    $cnt++;
                    
                }
            }
        }
        
        if ($datas != null and $average != null) array_multisort($average,SORT_ASC,$datas);
        
        $data = $this->renderPartial('_salaryslipview',['contents'=>$datas,'date'=>$date]);
        
        $pdf = new Pdf([
            'mode' => Pdf::MODE_CORE,
            'format' => Pdf::FORMAT_A4,
            'orientation' => Pdf::ORIENT_PORTRAIT,
            'destination' => Pdf::DEST_BROWSER,
            'content' => $data,
            'cssFile' => '@vendor/kartik-v/yii2-mpdf/src/assets/kv-mpdf-bootstrap.min.css',
            'cssInline' => '.kv-heading-1{font-size:18px}',
            'options' => ['title' => 'Bills request'],
            'methods' => [
                'SetHeader'=>[''],
                'SetFooter'=>['{PAGENO}'],
            ]
        ]);
        
        return $pdf->render();
        
        
        
        
    }
    
    public function actionPrintwcf($date,$type){
        
        
        $users = Uzers::find()->where(['company'=>\Yii::$app->session->get('company'),'status'=>1])->orderBy(['firstname'=>SORT_ASC])->all();
        $datas=null;
        $average=null;
        $cnt=0;
        
        foreach ($users as $i=>$user){
            
            $salary=Salaries::getUserSalary($user->id);
            $over=Overtime::getUserOvertimeAttime($user->id,$date);
            $over!=null?$ot=$over->amount:$ot=0;
            
            if ($salary != null){
                if ($salary->amount !=0){
                    $datas[$cnt]['FULLNAME']=$user->fullName;
                    $average[$cnt]['av']=$user->fullName;
                    $datas[$cnt]['BASIC']=$salary->amount;
                    $datas[$cnt]['OVERTIME']=$ot;
                    $g=$ot+$salary->amount;
                    $datas[$cnt]['GROSS']=$g;
                    $ns=($ot+$salary->amount)*0.1;
                    $datas[$cnt]['NSSF']=$ns;
                    $gs=$g-$ns;
                    $datas[$cnt]['GR-SF']=$gs;
                    $pae=Salaries::payeCalculator($gs);
                    $datas[$cnt]['P.A.Y.E']=$pae;
                    $td=$pae+$ns;
                    $datas[$cnt]['TOTAL DED']=$td;
                    $datas[$cnt]['NET-PAY']=$g-$td;
                    $datas[$cnt]['SSFNO']=$salary->ssfacc;
                    $cnt++;
                    
                }
            }
        }
        
        if ($datas != null and $average != null) array_multisort($average,SORT_ASC,$datas);
        
        $data = $this->renderPartial('_wcfview',['contents'=>$datas,'date'=>$date]);
        
        $pdf = new Pdf([
            'mode' => Pdf::MODE_CORE,
            'format' => Pdf::FORMAT_A4,
            'orientation' => Pdf::ORIENT_PORTRAIT,
            'destination' => Pdf::DEST_BROWSER,
            'content' => $data,
            'cssFile' => '@vendor/kartik-v/yii2-mpdf/src/assets/kv-mpdf-bootstrap.min.css',
            'cssInline' => '.kv-heading-1{font-size:18px}',
            'options' => ['title' => 'Bills request'],
            'methods' => [
                'SetHeader'=>[''],
                'SetFooter'=>['{PAGENO}'],
            ]
        ]);
        
        return $pdf->render();
        
        
        
    }
    
    public function actionPrintbank($date){
        
        if (\Yii::$app->session->get('company')==1) {$nm='Isumba co ltd salary'; }
        elseif (\Yii::$app->session->get('company')==2) {$nm='Isumba maritime services ltd salary'; }
        elseif (\Yii::$app->session->get('company')==3) {$nm='Not set'; }
        elseif (\Yii::$app->session->get('company')==4) {$nm='Not set'; }
        
        $users = Uzers::find()->where(['company'=>\Yii::$app->session->get('company'),'status'=>1])->orderBy(['firstname'=>SORT_ASC])->all();
        $datas=null;
        $average=null;
        $totalnet=0;
        
        foreach ($users as $i=>$user){
            
            $salary=Salaries::getUserSalary($user->id);
            $over=Overtime::getUserOvertimeAttime($user->id,$date);
            $over!=null?$ot=$over->amount:$ot=0;
            
            if ($salary != null){
                if ($salary->amount !=0){
                    $datas[$i]['FULLNAME']=$user->fullName;
                    $average[$i]['av']=$user->fullName;
                    $datas[$i]['BASIC']=$salary->amount;
                    $datas[$i]['OVERTIME']=$ot;
                    $g=$ot+$salary->amount;
                    $datas[$i]['GROSS']=$g;
                    $ns=($ot+$salary->amount)*0.1;
                    $datas[$i]['NSSF']=$ns;
                    $gs=$g-$ns;
                    $datas[$i]['GR-SF']=$gs;
                    $pae=Salaries::payeCalculator($gs);
                    $datas[$i]['P.A.Y.E']=$pae;
                    $td=$pae+$ns;
                    $datas[$i]['TOTAL DED']=$td;
                    $datas[$i]['NET-PAY']=number_format($g-$td);
                    $datas[$i]['BANK ACC']=$salary->bankacc;
                    
                    $totalnet=$totalnet+($g-$td);
                    
                }
            }
        }
        
        if ($datas != null and $average != null) array_multisort($average,SORT_ASC,$datas);
        
        $i=$i+1;
        $datas[$i]['NET-PAY']=number_format($totalnet);
        
        $exporter = new Spreadsheet([
            'dataProvider' => new ArrayDataProvider([
                'allModels' => $datas
            ]),
            
            'columns' => [
                [
                    'attribute' => 'FULLNAME',
                    'contentOptions' => [
                        'width' => [
                            '35px'
                        ],
                    ],
                ],
                [
                    'attribute' => 'NET-PAY',
                ],
                [
                    'attribute' => 'BANK ACC',
                ],
                
            ],
        ]);
        
        return $exporter->send($nm.'.xls');
        
        
        
    }

    /**
     * Deletes an existing Salaries model.
     * If deletion is successful, the browser will be redirected to the 'index' page.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionDelete($id)
    {
        $this->findModel($id)->delete();

        return $this->redirect(['index']);
    }

    /**
     * Finds the Salaries model based on its primary key value.
     * If the model is not found, a 404 HTTP exception will be thrown.
     * @param integer $id
     * @return Salaries the loaded model
     * @throws NotFoundHttpException if the model cannot be found
     */
    protected function findModel($id)
    {
        if (($model = Salaries::findOne($id)) !== null) {
            return $model;
        }

        throw new NotFoundHttpException('The requested page does not exist.');
    }
}
