<?php

namespace app\controllers;

use Yii;
use Behat\Gherkin\Exception\Exception;
use app\models\Rfq;
use app\models\Rfqcontent;
use app\models\RfqcontentSearch;
use app\models\Services;
use yii\web\Controller;
use yii\web\NotFoundHttpException;
use yii\filters\VerbFilter;
use yii\data\ActiveDataProvider;
use kartik\mpdf\Pdf;
use app\models\Model;

/**
 * RfqcontentController implements the CRUD actions for Rfqcontent model.
 */
class RfqcontentController extends Controller
{
    
    
    public function init() {
        
        if (\Yii::$app->session->get('layout') != null){
            $this->layout = \Yii::$app->session->get('layout');
        }else{
            $this->layout = 'workshop';
        }
        
    }
    
    /**
     * {@inheritdoc}
     */
    public function behaviors()
    {
        return [
            'verbs' => [
                'class' => VerbFilter::className(),
                'actions' => [
                    'delete' => ['POST'],
                ],
            ],
        ];
    }

    /**
     * Lists all Rfqcontent models.
     * @return mixed
     */
    public function actionIndex()
    {
        $searchModel = new RfqcontentSearch();
        $dataProvider = $searchModel->search(Yii::$app->request->queryParams);

        return $this->render('index', [
            'searchModel' => $searchModel,
            'dataProvider' => $dataProvider,
        ]);
    }

    /**
     * Displays a single Rfqcontent model.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
     public function actionView($id)
    {
        $contents=Rfqcontent::find()->where(['status'=>1,'carId'=>$id])->orderBy(['carId'=>SORT_ASC])->all();
        
        $data = $this->renderPartial('_requestforquoteview',['contents'=>$contents]);
        
        $pdf = new Pdf([
            'mode' => Pdf::MODE_CORE,
            'format' => Pdf::FORMAT_A4,
            'orientation' => Pdf::ORIENT_PORTRAIT,
            'destination' => Pdf::DEST_BROWSER,
            'content' => $data,
            'cssFile' => '@vendor/kartik-v/yii2-mpdf/src/assets/kv-mpdf-bootstrap.min.css',
            'cssInline' => '.kv-heading-1{font-size:18px}',
            'options' => ['title' => 'request for quote'],
            'methods' => [
                'SetHeader'=>[''],
                'SetFooter'=>['{PAGENO}'],
            ]
        ]);
        
        return $pdf->render();
    }

    /**
     * Creates a new Rfqcontent model.
     * If creation is successful, the browser will be redirected to the 'view' page.
     * @return mixed
     */
    public function actionCreate()
    {
        $model = new Rfqcontent();
        
        $query = Rfqcontent::find();
        $query->andFilterWhere([
            'status' => 1,
        ]);
        
        // add conditions that should always apply here
        
        $dataProvider = new ActiveDataProvider([
            'query' => $query,
            'sort'=> ['defaultOrder' => ['carId'=>SORT_DESC]],
             'pagination' => ['pageSize' => 50],
        ]);
        
        
        $models = [new Rfqcontent()];

        if (isset($_POST['Rfqcontent'])) {
            
            
            
            $models = Model::createMultiple(Rfqcontent::classname());
            Model::loadMultiple($models, Yii::$app->request->post());
            
            $valid = Model::validateMultiple($models);
            
            $transaction = \Yii::$app->db->beginTransaction();
            
            try {
                foreach ($models as $model) {
                    $model->date=date('Y-m-d');
                    $valid=$model->validate();
                    $contId=Rfqcontent::checkServiceInRfq($model->serviceId,$model->carId);
                    
                    if ($valid && $contId==null){
                        if (! ($flag = $model->save(false))) {
                            $transaction->rollBack();
                            break;
                        }
                    }else{
                        \Yii::$app->session->setFlash('error','Mis-matching currency,or dublicate service added');
                        $transaction->rollBack();
                        break;
                    }
                }
                
                if ($flag) {
                    $transaction->commit();
                    return $this->redirect(['create']);
                }
            } catch (Exception $e) {
                $transaction->rollBack();
            }
        }
        
        return $this->render('create', [
            'models' =>(empty($models)) ? [new Rfqcontent] : $models,'dataProvider'=>$dataProvider
        ]);
    }

    /**
     * Updates an existing Rfqcontent model.
     * If update is successful, the browser will be redirected to the 'view' page.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionUpdate($id)
    {
        $model = $this->findModel($id);
        
        $model->date=date('d-M-Y',strtotime($model->date));

        if ($model->load(Yii::$app->request->post())) {
            $model->date=date('Y-m-d',strtotime($model->date));
            
            if ($model->save()){
            return $this->redirect(['create']);
            }
            
        }

        return $this->render('update', [
            'model' => $model,
        ]);
    }
    
    
    public function actionSupplied($id)
    {
        $model = $this->findModel($id);
        
        $model->status=0;
        $model->save();
        
        return $this->redirect(['create']);
    }
    
        
    
    public function actionSuppliedstore($id)
    {
        $model = $this->findModel($id);
        
        $model->status=0;
        $model->save();
        
        return $this->redirect(['wstore/index']);
    }
        
    public function actionSuppliedview($id,$df)
    {
        $model = $this->findModel($id);
        
        $model->status=0;
        $model->save();
        
        return $this->redirect(['defectivetrucks/view','id'=>$df]);
    }


    /**
     * Deletes an existing Rfqcontent model.
     * If deletion is successful, the browser will be redirected to the 'index' page.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionDelete($id)
    {
        $this->findModel($id)->delete();

        return $this->redirect(['create']);
    }

    /**
     * Finds the Rfqcontent model based on its primary key value.
     * If the model is not found, a 404 HTTP exception will be thrown.
     * @param integer $id
     * @return Rfqcontent the loaded model
     * @throws NotFoundHttpException if the model cannot be found
     */
    protected function findModel($id)
    {
        if (($model = Rfqcontent::findOne($id)) !== null) {
            return $model;
        }

        throw new NotFoundHttpException('The requested page does not exist.');
    }
    
    
   public function actionPrintrequestforquote($sel) {
        
        if ($sel==1){
        $contents=Rfqcontent::find()->where(['status'=>1,'date'=>date('Y-m-d')])->all();
        }else{
            $contents=Rfqcontent::find()->where(['status'=>1])->orderBy(['carId'=>SORT_ASC])->all();
        }
        $data = $this->renderPartial('_requestforquoteview',['contents'=>$contents]);
        
        $pdf = new Pdf([
            'mode' => Pdf::MODE_CORE,
            'format' => Pdf::FORMAT_A4,
            'orientation' => Pdf::ORIENT_PORTRAIT,
            'destination' => Pdf::DEST_BROWSER,
            'content' => $data,
            'cssFile' => '@vendor/kartik-v/yii2-mpdf/src/assets/kv-mpdf-bootstrap.min.css',
            'cssInline' => '.kv-heading-1{font-size:18px}',
            'options' => ['title' => 'Bills request'],
            'methods' => [
                'SetHeader'=>[''],
                'SetFooter'=>['{PAGENO}'],
            ]
        ]);
        
        return $pdf->render();
    }
    
    
    public function actionPrintrequestforquotebycar($truckid) {
        
        
        $contents=Rfqcontent::find()->where(['status'=>1,'carId'=>$truckid])->orderBy(['carId'=>SORT_ASC])->all();
        
        $data = $this->renderPartial('_requestforquoteview',['contents'=>$contents]);
        
        $pdf = new Pdf([
            'mode' => Pdf::MODE_CORE,
            'format' => Pdf::FORMAT_A4,
            'orientation' => Pdf::ORIENT_PORTRAIT,
            'destination' => Pdf::DEST_BROWSER,
            'content' => $data,
            'cssFile' => '@vendor/kartik-v/yii2-mpdf/src/assets/kv-mpdf-bootstrap.min.css',
            'cssInline' => '.kv-heading-1{font-size:18px}',
            'options' => ['title' => 'Bills request'],
            'methods' => [
                'SetHeader'=>[''],
                'SetFooter'=>['{PAGENO}'],
            ]
        ]);
        
        return $pdf->render();
    }
    
}