<?php

namespace app\controllers;

use Yii;
use app\models\Rfq;
use app\models\RfqSearch;
use yii\web\Controller;
use yii\web\NotFoundHttpException;
use yii\filters\VerbFilter;

/**
 * RfqController implements the CRUD actions for Rfq model.
 */
class RfqController extends Controller
{
    
   public function init() {
        
        if (\Yii::$app->session->get('layout') != null){
            $this->layout = \Yii::$app->session->get('layout');
        }else{
            $this->layout = 'workshop';
        }
       
    }
    
    
    
    /**
     * {@inheritdoc}
     */
    public function behaviors()
    {
        return [
            'verbs' => [
                'class' => VerbFilter::className(),
                'actions' => [
                    'delete' => ['POST'],
                ],
            ],
        ];
    }

    /**
     * Lists all Rfq models.
     * @return mixed
     */
    public function actionIndex()
    {
        $searchModel = new RfqSearch();
        $dataProvider = $searchModel->search(Yii::$app->request->queryParams);

        return $this->render('index', [
            'searchModel' => $searchModel,
            'dataProvider' => $dataProvider,
        ]);
    }

    /**
     * Displays a single Rfq model.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionView($id)
    {
        return $this->render('view', [
            'model' => $this->findModel($id),
        ]);
    }

    /**
     * Creates a new Rfq model.
     * If creation is successful, the browser will be redirected to the 'view' page.
     * @return mixed
     */
    public function actionCreate()
    {
        $model = new Rfq();

        if ($model->load(Yii::$app->request->post())) {
            
            $model->date=date('Y-m-d',strtotime($model->date));
            $model->dueDate=date('Y-m-d',strtotime($model->dueDate));
            $model->company=\Yii::$app->session->get('company');
            $model->userId=\Yii::$app->user->getId();
            
            if ($model->save()){
                \Yii::$app->session->setFlash('success','Successfull saved new rfq');
            return $this->redirect(['rfqcontent/create','id'=>$model->id]);
            }
        }

        return $this->render('create', [
            'model' => $model,
        ]);
    }

    /**
     * Updates an existing Rfq model.
     * If update is successful, the browser will be redirected to the 'view' page.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionUpdate($id)
    {
        $model = $this->findModel($id);
        $model->date=date('d-M-Y',strtotime($model->date));
        $model->dueDate=date('d-M-Y',strtotime($model->dueDate));

        if ($model->load(Yii::$app->request->post())) {
            
            $model->date=date('Y-m-d',strtotime($model->date));
            $model->dueDate=date('Y-m-d',strtotime($model->dueDate));
            $model->company=\Yii::$app->session->get('company');
            $model->userId=\Yii::$app->user->getId();
            
            if ($model->save()){
                \Yii::$app->session->setFlash('success','Successfull update rfq');
            return $this->redirect(['index']);
            }
        }

        return $this->render('update', [
            'model' => $model,
        ]);
    }

    /**
     * Deletes an existing Rfq model.
     * If deletion is successful, the browser will be redirected to the 'index' page.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionDelete($id)
    {
        $this->findModel($id)->delete();

        return $this->redirect(['index']);
    }

    /**
     * Finds the Rfq model based on its primary key value.
     * If the model is not found, a 404 HTTP exception will be thrown.
     * @param integer $id
     * @return Rfq the loaded model
     * @throws NotFoundHttpException if the model cannot be found
     */
    protected function findModel($id)
    {
        if (($model = Rfq::findOne($id)) !== null) {
            return $model;
        }

        throw new NotFoundHttpException('The requested page does not exist.');
    }
}
