<?php

namespace app\controllers;

use Yii;
use app\models\Cfile;
use app\models\Packages;
use app\models\PackagesSearch;
use yii\web\Controller;
use yii\web\NotFoundHttpException;
use yii\filters\VerbFilter;
use yii\helpers\Html;
use kartik\mpdf\Pdf;

/**
 * PackagesController implements the CRUD actions for Packages model.
 */
class PackagesController extends Controller
{
    
    public function init() {
        
        if (\Yii::$app->session->get('layout') != null){
            $this->layout = \Yii::$app->session->get('layout');
        }else{
            $this->layout = 'cnf';
        }
      
    }
    /**
     * {@inheritdoc}
     */
    public function behaviors()
    {
        return [
            'verbs' => [
                'class' => VerbFilter::className(),
                'actions' => [
                    'delete' => ['POST'],
                ],
            ],
        ];
    }

    /**
     * Lists all Packages models.
     * @return mixed
     */
    public function actionIndex()
    {
        if (\Yii::$app->session->get('fileId')!=null){
            $searchModel = new PackagesSearch();
            $dataProvider = $searchModel->search(Yii::$app->request->queryParams);
    
            return $this->render('index', [
                'searchModel' => $searchModel,
                'dataProvider' => $dataProvider,
            ]);
        }else{
            return $this->redirect(['uzers/dashboard']);
        }
    }

    /**
     * Displays a single Packages model.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionView($id)
    {
        return $this->render('view', [
            'model' => $this->findModel($id),
        ]);
    }

    /**
     * Creates a new Packages model.
     * If creation is successful, the browser will be redirected to the 'view' page.
     * @return mixed
     */
    public function actionCreate()
    {
        $model = new Packages();

        if ($model->load(Yii::$app->request->post())) {
            $model->fileId=\Yii::$app->session->get('fileId');
            $model->onn=date('Y-m-d');
            $model->byy=\Yii::$app->user->getId();
            
            if(Cfile::findOne(\Yii::$app->session->get('fileId'))->bulk ==1) {
               $model->type=3;
               $model->containerno='bulkload';
            }
            
            if (Cfile::findOne(\Yii::$app->session->get('fileId'))->ftype==2){ 
             $model->barels=$model->barels;   
            }
            
            $checkDublicate= Packages::checkDublicate($model->containerno);
            if ($checkDublicate==null){
                if($model->save()){
                \Yii::$app->session->setFlash('success','Successfull saved new package');
                return $this->redirect(['index']);
                }
            }else{
                \Yii::$app->session->setFlash('error','Dublicate package registered,edit or save');
                return $this->redirect(['update','id'=>$checkDublicate->id]);
            }
        }

        if (\Yii::$app->request->isAjax){
            return $this->renderAjax('create', [
                'model' => $model,
            ]);
        }else{
            return $this->render('create', [
                'model' => $model,
            ]);
        }
    }

    /**
     * Updates an existing Packages model.
     * If update is successful, the browser will be redirected to the 'view' page.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionUpdate($id)
    {
        $model = $this->findModel($id);

        if ($model->load(Yii::$app->request->post())) {
            
            if ($model->save()){
            return $this->redirect(['index']);
            }
        }

        return $this->render('update', [
            'model' => $model,
        ]);
    }

    /**
     * Deletes an existing Packages model.
     * If deletion is successful, the browser will be redirected to the 'index' page.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionDelete($id)
    {
        $this->findModel($id)->delete();

        return $this->redirect(['index']);
    }

    /**
     * Finds the Packages model based on its primary key value.
     * If the model is not found, a 404 HTTP exception will be thrown.
     * @param integer $id
     * @return Packages the loaded model
     * @throws NotFoundHttpException if the model cannot be found
     */
    protected function findModel($id)
    {
        if (($model = Packages::findOne($id)) !== null) {
            return $model;
        }

        throw new NotFoundHttpException('The requested page does not exist.');
    }
    
        public function actionPrintpackages($id) {
        
        $contents=Packages::find()->where(['fileId'=>$id])->all();
        $data = $this->renderPartial('_packageview',['contents'=>$contents,'fileId'=>$id]);
        
        $pdf = new Pdf([
            'mode' => Pdf::MODE_CORE,
            'format' => Pdf::FORMAT_A4,
            'orientation' => Pdf::ORIENT_PORTRAIT,
            'destination' => Pdf::DEST_BROWSER,
            'content' => $data,
            'cssFile' => '@vendor/kartik-v/yii2-mpdf/src/assets/kv-mpdf-bootstrap.min.css',
            'cssInline' => '.kv-heading-1{font-size:18px}',
            'options' => ['title' => 'Packages'],
            'methods' => [
               'SetFooter'=>['{PAGENO}'],
            ]
        ]);
        
        return $pdf->render();
    }
}
