<?php

namespace app\controllers;

use Yii;
use app\models\Overtime;
use app\models\OvertimeSearch;
use app\models\Uzers;
use yii\web\Controller;
use yii\web\NotFoundHttpException;
use yii\filters\VerbFilter;
use app\models\Salaries;

/**
 * OvertimeController implements the CRUD actions for Overtime model.
 */
class OvertimeController extends Controller
{
    
    public function init() {
        
        if (\Yii::$app->session->get('layout') != null){
            $this->layout = \Yii::$app->session->get('layout');
        }else{
            $this->layout ='accounts';
        }
    }
    /**
     * {@inheritdoc}
     */
    public function behaviors()
    {
        return [
            'verbs' => [
                'class' => VerbFilter::className(),
                'actions' => [
                    'delete' => ['POST'],
                ],
            ],
        ];
    }

    /**
     * Lists all Overtime models.
     * @return mixed
     */
    public function actionIndex()
    {
        $this->layout='hr';
        $users = Uzers::find()->where(['company'=>\Yii::$app->session->get('company'),'status'=>1])->all();
        $reqdate=date('Y-m-d');

        return $this->render('index', [
            'users' => $users,
            'reqdate' => $reqdate,
        ]);
    }

    /**
     * Displays a single Overtime model.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionView($id)
    {
        return $this->render('view', [
            'model' => $this->findModel($id),
        ]);
    }

    /**
     * Creates a new Overtime model.
     * If creation is successful, the browser will be redirected to the 'view' page.
     * @return mixed
     */
    public function actionCreate()
    {
        $model = new Overtime();
        
        $users = Uzers::find()->where(['company'=>\Yii::$app->session->get('company'),'status'=>1])->all();

        if (isset($_POST['Overtime'])) {
            $check=0;
            foreach ($users as $i=>$user){
                if ($_POST['Overtime'][$i]['amount']!=null){
                $model = new Overtime();
                $model->userId=$user->id;
                $model->amount=$_POST['Overtime'][$i]['amount'];
                $model->reason=$_POST['Overtime'][$i]['reason'];
                $model->date=date('Y-m-d');
                
                    if ($model->save()){
                        $check++;
                    }else{
                        \Yii::$app->session->setFlash('error','Error in Salaries information of '. $user->fullName);
                        return $this->redirect(['create']);
                        }
                }
            }
            if ($check>0){
                \Yii::$app->session->setFlash('success',$check.' User salary modified');
                return $this->redirect(['index']);
            }
        }
            return $this->render('create', [
                'model' => $model,'users'=>$users,
            ]);
    }

    /**
     * Updates an existing Overtime model.
     * If update is successful, the browser will be redirected to the 'view' page.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionUpdate($id)
    {
        $model = $this->findModel($id);

        if ($model->load(Yii::$app->request->post()) && $model->save()) {
            return $this->redirect(['view', 'id' => $model->id]);
        }

        return $this->render('update', [
            'model' => $model,
        ]);
    }

    /**
     * Deletes an existing Overtime model.
     * If deletion is successful, the browser will be redirected to the 'index' page.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionDelete($id)
    {
        $this->findModel($id)->delete();

        return $this->redirect(['index']);
    }

    /**
     * Finds the Overtime model based on its primary key value.
     * If the model is not found, a 404 HTTP exception will be thrown.
     * @param integer $id
     * @return Overtime the loaded model
     * @throws NotFoundHttpException if the model cannot be found
     */
    protected function findModel($id)
    {
        if (($model = Overtime::findOne($id)) !== null) {
            return $model;
        }

        throw new NotFoundHttpException('The requested page does not exist.');
    }
}
