<?php

namespace app\controllers;

use Yii;
use app\models\Offuels;
use app\models\OffuelsSearch;
use app\models\Cars;
use yii\web\Controller;
use yii\web\NotFoundHttpException;
use yii\filters\VerbFilter;
use kartik\mpdf\Pdf;

/**
 * OffuelsController implements the CRUD actions for Offuels model.
 */
class OffuelsController extends Controller
{
    
    public function init() {
        
        if (\Yii::$app->session->get('layout') != null){
            $this->layout = \Yii::$app->session->get('layout');
        }else{
            $this->layout = 'operations';
        }
       
    }
    
    /**
     * {@inheritdoc}
     */
    public function behaviors()
    {
        return [
            'verbs' => [
                'class' => VerbFilter::className(),
                'actions' => [
                    'delete' => ['POST'],
                ],
            ],
        ];
    }

    /**
     * Lists all Offuels models.
     * @return mixed
     */
    public function actionIndex()
    {
        $searchModel = new OffuelsSearch();
        $dataProvider = $searchModel->search(Yii::$app->request->queryParams);

        return $this->render('index', [
            'searchModel' => $searchModel,
            'dataProvider' => $dataProvider,
        ]);
    }

    /**
     * Displays a single Offuels model.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionView($id)
    {
        return $this->render('view', [
            'model' => $this->findModel($id),
        ]);
    }

    /**
     * Creates a new Offuels model.
     * If creation is successful, the browser will be redirected to the 'view' page.
     * @return mixed
     */
    public function actionCreate($id,$remain,$tk)
    {
        $model = new Offuels();

        if ($model->load(Yii::$app->request->post())) {
            $model->date=date('Y-m-d');
            $model->fuelId=$id;
            $model->truckId=$tk;
            
            if($model->amount<=$remain and $model->amount <=20){
                if($model->save()){
                    \Yii::$app->session->setFlash('success','Successfull saved new fuel used off the operations');
                    return $this->redirect(['fuelrequest/create', 'id' => $tk]);
                }
            }elseif(Cars::findOne(['plateno'=>$tk])->type->carmodelId==6 and $model->amount<=$remain){
                if($model->save()){
                    \Yii::$app->session->setFlash('success','Successfull saved new fuel used off the operations');
                    return $this->redirect(['fuelrequest/create', 'id' => $tk]);
                }
            }else{
                     \Yii::$app->session->setFlash('error','Error: Off fuel is greater than allow trip fuel:'.Cars::findOne($tk)->type->carmodel);
            }
        }

        return $this->render('create', [
            'model' => $model,
        ]);
    }

    /**
     * Updates an existing Offuels model.
     * If update is successful, the browser will be redirected to the 'view' page.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionUpdate($id)
    {
        $model = $this->findModel($id);

        if ($model->load(Yii::$app->request->post()) && $model->save()) {
            return $this->redirect(['view', 'id' => $model->id]);
        }

        return $this->render('update', [
            'model' => $model,
        ]);
    }

    /**
     * Deletes an existing Offuels model.
     * If deletion is successful, the browser will be redirected to the 'index' page.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionDelete($id)
    {
        $this->findModel($id)->delete();

        return $this->redirect(['index']);
    }

    /**
     * Finds the Offuels model based on its primary key value.
     * If the model is not found, a 404 HTTP exception will be thrown.
     * @param integer $id
     * @return Offuels the loaded model
     * @throws NotFoundHttpException if the model cannot be found
     */
    protected function findModel($id)
    {
        if (($model = Offuels::findOne($id)) !== null) {
            return $model;
        }

        throw new NotFoundHttpException('The requested page does not exist.');
    }
    
    public function actionReport()
    {
        $this->layout='main';
        $model = new Offuels();
        
        if (isset($_POST['Offuels'])) {
            
            if($_POST['Offuels']['to'] > $_POST['Offuels']['from']){
                
                $data = $this->renderPartial('_reportview',['from'=>$_POST['Offuels']['from'],'to'=>$_POST['Offuels']['to']]);
                
                $pdf = new Pdf([
                    'mode' => Pdf::MODE_CORE,
                    'format' => Pdf::FORMAT_A4,
                    'orientation' => Pdf::ORIENT_PORTRAIT,
                    'destination' => Pdf::DEST_BROWSER,
                    'content' => $data,
                    'cssFile' => '@vendor/kartik-v/yii2-mpdf/src/assets/kv-mpdf-bootstrap.min.css',
                    'cssInline' => '.kv-heading-1{font-size:18px}',
                    'options' => ['title' => 'Out of Operation fuel report'],
                    'methods' => [
                        'SetFooter'=>['{PAGENO}'],
                    ]
                ]);
                
                return $pdf->render();
                
            }else{
                \Yii::$app->session->setFlash('error','From can not be greater than to');
            }
        }
        
        return $this->render('report', [
            'model' => $model,
        ]);
    }
}
