<?php

namespace app\controllers;

use Yii;
use yii2tech\spreadsheet\Spreadsheet;
use yii\data\ArrayDataProvider;
use app\models\Movefuelratio;
use app\models\Movements;
use app\models\MovementsSearch;
use yii\web\Controller;
use yii\web\NotFoundHttpException;
use yii\filters\VerbFilter;
use app\models\Fuelrequest;
use yii\data\ActiveDataProvider;
use app\models\Cardrivers;
use app\models\Cars;
use app\models\Cartype;
use app\models\Movetype;
use app\models\Trafficoffences;
use app\models\Clients;
use kartik\mpdf\Pdf;
use app\models\Wstoredispatch;
use app\models\Uzers;
use app\models\Bills;
use app\models\Fromclients;

/**
 * MovementsController implements the CRUD actions for Movements model.
 */
class MovementsController extends Controller
{
    public function init() {
        
        if (\Yii::$app->session->get('layout') != null){
        $this->layout = \Yii::$app->session->get('layout');
        }else{
            $this->layout='operations';
        }
    }
    /**
     * {@inheritdoc}
     */
    public function behaviors()
    {
        return [
            'verbs' => [
                'class' => VerbFilter::className(),
                'actions' => [
                    'delete' => ['POST'],
                ],
            ],
        ];
    }

    /**
     * Lists all Movements models.
     * @return mixed
     */
    public function actionIndex()
    {
        $searchModel = new MovementsSearch();
        $dataProvider = $searchModel->search(Yii::$app->request->queryParams);

        return $this->render('index', [
            'searchModel' => $searchModel,
            'dataProvider' => $dataProvider,
        ]);
    }
    
    public function actionClientmovementsbydate()
    {
  
       $model=new Movements();
       $from=null;
       $to=null;
        
        if (isset($_POST['Movements'])) {
            $from=$_POST['Movements']['from'];
            $to=$_POST['Movements']['to'];
        }
        
        return $this->render('clientmovementsbydate', [
            'model'=>$model,
            'from'=>$from,
            'to'=>$to,
        ]);
    }
    
        
    public function actionOfficerstrengthbydate()
    {
        
        $model=new Movements();
        $from=null;
        $to=null;
        
        if (isset($_POST['Movements'])) {
            $from=$_POST['Movements']['from'];
            $to=$_POST['Movements']['to'];
        }
        
        return $this->render('officerstrengthbydate', [
            'model'=>$model,
            'from'=>$from,
            'to'=>$to,
        ]);
    }
    


    /**
     * Displays a single Movements model.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionView($id)
    {
        return $this->render('view', [
            'model' => $this->findModel($id),
        ]);
    }

    /**
     * Creates a new Movements model.
     * If creation is successful, the browser will be redirected to the 'view' page.
     * @return mixed
     */
    public function actionCreate()
    {
        $model = new Movements();

        if ($model->load(Yii::$app->request->post())) {
            
            $moveconsumption=$model->movetypeId!=null?Movefuelratio::getConsumedFuel($model->movetype->id,$model->truck->typeId):0;
            $fId=Fuelrequest::getTruckActiveFuel($model->truckId,$moveconsumption);
            if ($fId !=null && $model->movetype->movefuelratios!=null){
                
                $model->interchangedate=date('Y-m-d',strtotime($model->interchangedate));
                $model->containerno=trim(strtoupper($model->containerno));
                $model->company=\Yii::$app->session->get('company');
                $model->registereddate=date('Y-m-d');
                $model->byy=\Yii::$app->user->getId();
                $model->fuelId=$fId;
                $dublicatecheck=Movements::checkDublicateMovement($model->movetypeId,strtolower($model->containerno),$model->interchangedate,$model->clientId);
                
                if ($dublicatecheck==null){
                    if($model->save()){
                        Fromclients::checkcontainerbycontainerno($model->containerno);
                        \Yii::$app->session->setFlash('success','Successfull saved new movement');
                        return $this->redirect(['create']);
                    }
                }else {
                    \Yii::$app->session->setFlash('error','Dublicate movement registered');
                    return $this->redirect(['update','id'=>$dublicatecheck->id]);
                }
            }else {
                \Yii::$app->session->setFlash('error','This truck has no fuel to complete this movement / Movement has not been assigned fuel ratio'.$moveconsumption);
                return $this->redirect(['fuelrequest/viewcar','truckId'=>$model->truckId,'move'=>$model->movetypeId,
                    'date'=>$model->interchangedate,'driver'=>$model->driverId,'cont'=>$model->containerno,
                    'line'=>$model->shippingline,'size'=>$model->size,'clie'=>$model->clientId,'stat'=>0]);
            }
        }
            return $this->render('create', [
                'model' => $model,
            ]);
    }
    
    
    public function actionBorrow($carId,$fuelId)
    {
        $model = new Movements();
        
        if ($model->load(Yii::$app->request->post())) {
            
            //$moveconsumption=$model->movetypeId!=null?Movefuelratio::getConsumedFuel($model->movetype->id,$model->truck->typeId):0;
           // $fId=Fuelrequest::getTruckActiveFuel($model->truckId,$moveconsumption);
           
            $fId=$fuelId;
            if ($fId !=null && $model->movetype->movefuelratios!=null){
                
                $model->interchangedate=date('Y-m-d',strtotime($model->interchangedate));
                $model->containerno=trim(strtoupper($model->containerno));
                $model->company=\Yii::$app->session->get('company');
                $model->registereddate=date('Y-m-d');
                $model->byy=\Yii::$app->user->getId();
                $model->truckId=$carId;
                $model->fuelId=$fId;
                $dublicatecheck=Movements::checkDublicateMovement($model->movetypeId,strtolower($model->containerno),$model->interchangedate,$model->clientId);
                
                if ($dublicatecheck==null){
                    if($model->save()){
                        \Yii::$app->session->setFlash('success','Successfull saved new movement');
                        return $this->redirect(['create']);
                    }
                }else {
                    \Yii::$app->session->setFlash('error','Dublicate movement registered');
                    return $this->redirect(['update','id'=>$dublicatecheck->id]);
                }
            }else {
                \Yii::$app->session->setFlash('error','This truck has no fuel to complete this movement / Movement has not been assigned fuel ratio'.$moveconsumption);
                return $this->redirect(['fuelrequest/create','id'=>$model->truckId]);
            }
        }
        return $this->render('borrow', [
            'model' => $model,
        ]);
    }

    /**
     * Updates an existing Movements model.
     * If update is successful, the browser will be redirected to the 'view' page.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionUpdate($id)
    {
        if(Yii::$app->user->can('Admin')){
            return $this->redirect(['updateadmin','id'=>$id]);
        }else{
        $model = $this->findModel($id);

        if ($model->load(Yii::$app->request->post())) {
            
            $model->interchangedate=date('Y-m-d',strtotime($model->interchangedate));
            $model->containerno=strtoupper($model->containerno);
            $model->registereddate=date('Y-m-d');
            $model->byy=\Yii::$app->user->getId();
            
            if ($model->save()){
            \Yii::$app->session->setFlash('success','Successfull saved new movement');
            return $this->redirect(['index']);
            }
        }

        $model->interchangedate=date('d-M-Y',strtotime($model->interchangedate));
        
        return $this->render('update', [
            'model' => $model,
        ]);
        }
    }
    
    
    public function actionMove($id)
    {
            $model = $this->findModel($id);
           
                $model->interchangedate=date('1999-09-09');
                $model->registereddate=date('1999-09-09');
                $model->byy=\Yii::$app->user->getId();
                
                if ($model->save()){
                    \Yii::$app->session->setFlash('success','MOVED TO STORE');
                    return $this->redirect(['index']);
                }
                
            return $this->render('update', [
                'model' => $model,
            ]);
    }
    
    
    public function actionUpdateadmin($id)
    {
        $model = $this->findModel($id);
        
        if ($model->load(Yii::$app->request->post())) {
            
            $model->interchangedate=date('Y-m-d',strtotime($model->interchangedate));
            $model->containerno=strtoupper($model->containerno);
            $model->registereddate=date('Y-m-d');
            $model->byy=\Yii::$app->user->getId();
            
            if ($model->save()){
                \Yii::$app->session->setFlash('success','Successfull saved new movement');
                return $this->redirect(['index']);
            }
        }
        
        $model->interchangedate=date('d-M-Y',strtotime($model->interchangedate));
        
        return $this->render('updateadmin', [
            'model' => $model,
        ]);
    }
    
    
    public function actionDriversincentive($id)
    {
        if ($id==2) { $this->layout= 'accounts'; }
        
       
        $movement=new Movements;
        
        $allDrivers=null;
        $average=null;
        $cnt=0;
        $cc=0;
        $div=1;
        $from=date('1970-01-01');
        $to=date('1970-01-01');
        $data=null;
        $dtProvider=null;
        $madereva=null;
        $kwa=0;
        $mid=0;
        $b=0;
        
        if (isset($_POST['Movements'])){
            $from=date('Y-m-d',strtotime($_POST['Movements']['from']));
            $to=date('Y-m-d',strtotime($_POST['Movements']['to']));
            $b=$_POST['Movements']['batch'];
            
            $users= Uzers::find()->where(['status'=>1])->all();
            
            if ($users != null  and $to>=$from){ 
                
                foreach($users as $user){
                    $chk=0;
                     $checkdrivers= Cardrivers::find()->where(['userId'=>$user->id])->all();
                    
                        if($checkdrivers != null){
                         $madereva[]=$user->id;
                        }
                }
                
                 if($b==2){
                        $kwa=0;
                        $mid=count($madereva)/2;
                    }elseif($b==3){
                       $kwa=count($madereva)/2;
                       $mid=count($madereva);
                    }elseif($b==1){
                       $kwa=0;
                       $mid=count($madereva); 
                    }
                    
                    for($k=$kwa; $k<$mid; $k++){  
                    $ft=0; $tw=0; $ot=0; $mv=0; $in=0; $too=0; $oof=0;
                    
                    $uuId=$madereva[$k];
                    $drivers= Cardrivers::find()->where(['userId'=>$uuId])->all();
                    
                  /*  $mid=count($users)/2;
                    
                    if($b==2){
                        $condit= $div <= $mid;
                    }elseif($b==3){
                       $condit= $div > $mid; 
                    }elseif($b==1){
                       $condit=$div>0; 
                    } */
                    
                    // if($condit){
           
        if($drivers!=null){
            foreach ($drivers as $driver){
                
                $checkOps= Movements::find()->where(['driverId'=>$driver->id,'company'=>\Yii::$app->session->get('company')])->all();
                    if($checkOps != null){
               
                //$allc=Movements::driverAmountOfLoadByTimeArray($driver->id,$from,$to);
                //$ft=$ft + $allc['forty'];
                //$tw=$tw + $allc['twenty'];
                //$ot=$ot + $allc['other'];
                //$ft=$ft + Movements::driverAmountOfLoadBySizeTime($driver->id,$from,$to,4);
                //$tw=$tw + Movements::driverAmountOfLoadBySizeTime($driver->id,$from,$to,2);
                //$ot=$ot + Movements::driverAmountOfLoadBySizeTime($driver->id,$from,$to,0);
                $aar=Movetype::driverIncentiveByTime($driver->id,$from,$to);
                $mv=$mv + $aar['trips'];
                $in=$in + $aar['incentive'];
                $ft=$ft + $aar['fo'];
                $tw=$tw + $aar['tw'];
                $ot=$ot + $aar['ot'];
                //$in=$in +   Movetype::driverIncentiveByTimeConditioned($driver->id,$from,$to);
                
                $too=$too + Trafficoffences::calculateDriverCost($driver->id,$from,$to);
                $oof=$oof + Trafficoffences::calculateDriverOtherCost($driver->id,$aar['incentive'],$to);
                
            } } }
            
                   //  }  $div++;
            
            if ($in>0){
                
            $caryover=0;
            if(\Yii::$app->session->get('company')==1){
            if($driver->id==2476){$caryover=62000;}
            elseif($driver->id==2608){$caryover=50000;}
            elseif($driver->id==2985){$caryover=288000;}
            }
                
            $allDrivers[$cnt]['name']=$driver->user->firstname.' '.$driver->user->lastname;
            $allDrivers[$cnt]['foty']=$ft;
            $allDrivers[$cnt]['twenty']=$tw;
            $allDrivers[$cnt]['other']=$ot;
            $allDrivers[$cnt]['moves']=$mv;
            $allDrivers[$cnt]['incentive']=$in;
            $allDrivers[$cnt]['trafficoffence']=$too;
            $allDrivers[$cnt]['otheroffence']=$oof;
            $allDrivers[$cnt]['caryover']=$caryover;
            $allDrivers[$cnt]['netpay']=$allDrivers[$cnt]['incentive']-$allDrivers[$cnt]['trafficoffence']-$allDrivers[$cnt]['otheroffence']+$caryover;
            $allDrivers[$cnt]['userId']=$uuId;
            
            $average[$cnt]['val']=$mv;
            $cnt++;
            
            }
          
                       
            
        }  }else {
                    \Yii::$app->session->setFlash('error','From date must be less than to date');
                }
                
               if ($average != null and $allDrivers != null) array_multisort($average,SORT_DESC,$allDrivers);
          
        }
        
        
        
        return $this->render('driversincentive',['drivers'=>$allDrivers,'movement'=>$movement,'from'=>$from,'to'=>$to,'batch'=>$b,'madereva'=>$madereva]);
    }
    
    
        public function actionIncentivebydriver($id)
    {
        if ($id==2) { $this->layout= 'accounts'; }
        
       
        $movement=new Movements;
        
        $allDrivers=null;
        $average=null;
        $cnt=0;
        $cc=0;
        $div=1;
        $from=date('1970-01-01');
        $to=date('1970-01-01');
        $data=null;
        $dtProvider=null;
        $madereva=null;
        $kwa=0;
        $mid=0;
        $b=0;
        
        if (isset($_POST['Movements'])){
            $from=date('Y-m-d',strtotime($_POST['Movements']['from']));
            $to=date('Y-m-d',strtotime($_POST['Movements']['to']));
            $userId=$_POST['Movements']['driverId'];  //We fetched userid rather than driver id for purpose, so this driverId represent userid
          
            if ($to>=$from){ 
                
                    $drivers= Cardrivers::find()->where(['userId'=>$userId])->all();
           
        if($drivers!=null){
            foreach ($drivers as $driver){
                
                $checkOps= Movements::find()->where(['driverId'=>$driver->id,'company'=>\Yii::$app->session->get('company')])->all();
                    if($checkOps != null){
               
                //$allc=Movements::driverAmountOfLoadByTimeArray($driver->id,$from,$to);
                //$ft=$ft + $allc['forty'];
                //$tw=$tw + $allc['twenty'];
                //$ot=$ot + $allc['other'];
                //$ft=$ft + Movements::driverAmountOfLoadBySizeTime($driver->id,$from,$to,4);
                //$tw=$tw + Movements::driverAmountOfLoadBySizeTime($driver->id,$from,$to,2);
                //$ot=$ot + Movements::driverAmountOfLoadBySizeTime($driver->id,$from,$to,0);
                $aar=Movetype::driverIncentiveByTime($driver->id,$from,$to);
                $mv=$mv + $aar['trips'];
                $in=$in + $aar['incentive'];
                $ft=$ft + $aar['fo'];
                $tw=$tw + $aar['tw'];
                $ot=$ot + $aar['ot'];
                //$in=$in +   Movetype::driverIncentiveByTimeConditioned($driver->id,$from,$to);
                
                $too=$too + Trafficoffences::calculateDriverCost($driver->id,$from,$to);
                $oof=$oof + Trafficoffences::calculateDriverOtherCost($driver->id,$aar['incentive'],$to);
                
            } } }
            
                   //  }  $div++;
            
           if ($in>0){
              $caryover=0;
           if(\Yii::$app->session->get('company')==1){
            if($driver->id==2476){$caryover=62000;}
            elseif($driver->id==2608){$caryover=50000;}
            elseif($driver->id==2985){$caryover=288000;}
            }
            
            $allDrivers[$cnt]['name']=$driver->user->firstname.' '.$driver->user->lastname;
            $allDrivers[$cnt]['foty']=$ft;
            $allDrivers[$cnt]['twenty']=$tw;
            $allDrivers[$cnt]['other']=$ot;
            $allDrivers[$cnt]['moves']=$mv;
            $allDrivers[$cnt]['incentive']=$in;
            $allDrivers[$cnt]['trafficoffence']=$too;
            $allDrivers[$cnt]['otheroffence']=$oof;
            $allDrivers[$cnt]['caryover']=$caryover;
            $allDrivers[$cnt]['netpay']=$allDrivers[$cnt]['incentive']-$allDrivers[$cnt]['trafficoffence']-$allDrivers[$cnt]['otheroffence']+$caryover;
            $allDrivers[$cnt]['userId']=$userId;
            
            $average[$cnt]['val']=$mv;
            $cnt++;
            
            }  }else {
                    \Yii::$app->session->setFlash('error','From date must be less than to date');
                }
                
               if ($average != null and $allDrivers != null) array_multisort($average,SORT_DESC,$allDrivers);
          
        }
        
        
        
        return $this->render('incentivebydriver',['drivers'=>$allDrivers,'movement'=>$movement,'from'=>$from,'to'=>$to,'batch'=>$b,'madereva'=>$madereva]);
    }

    /**
     * Deletes an existing Movements model.
     * If deletion is successful, the browser will be redirected to the 'index' page.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionDelete($id)
    {
        $this->findModel($id)->delete();

        return $this->redirect(['index']);
    }

    /**
     * Finds the Movements model based on its primary key value.
     * If the model is not found, a 404 HTTP exception will be thrown.
     * @param integer $id
     * @return Movements the loaded model
     * @throws NotFoundHttpException if the model cannot be found
     */
    protected function findModel($id)
    {
        if (($model = Movements::findOne($id)) !== null) {
            return $model;
        }

        throw new NotFoundHttpException('The requested page does not exist.');
    }
    
    
         public function actionPrintincentives(){
       
       
      $allDrivers= \Yii::$app->session->get('sessioneddrivers');

        $exporter = new Spreadsheet([
            'dataProvider' => new ArrayDataProvider([
                'allModels' => $allDrivers
            ]),
            
            'columns' => [
                [
                    'attribute' => 'name',
                    'contentOptions' => [
                        'width' => [
                            '35px'
                        ],
                    ],
                ],
                [
                    'attribute' => 'foty',
                ],
                [
                    'attribute' => 'twenty',
                ],
                [
                    'attribute' => 'other',
                ],
                [
                    'attribute' => 'moves',
                ],
                [
                    'attribute' => 'incentive',
                ],
                [
                    'attribute' => 'trafficoffence',
                ],
                [
                    'attribute' => 'otheroffence',
                ],
                [
                    'attribute' => 'caryover',
                ],
                [
                    'attribute' => 'netpay',
                ],
            ],
        ]);
        
        return $exporter->send('incentives.xls'); 
    }
   
    
    
     public function actionPrintincentivesOld($from,$to,$batch){
       
        $movement=new Movements;
        
        $allDrivers=null;
        $average=null;
        $div=1;
        $cnt=0;
        $users= Uzers::find()->where(['status'=>1])->all();
        
      
        if ($users != null  and $to>=$from){
            
            foreach($users as $user){
                   
                     $checkdrivers= Cardrivers::find()->where(['userId'=>$user->id])->all();
                    
                        if($checkdrivers != null){
                         $madereva[]=$user->id;
                        }
                }
                
                    if($batch==2){
                        $kwa=0;
                        $mid=count($madereva)/2;
                    }elseif($batch==3){
                       $kwa=count($madereva)/2;
                       $mid=count($madereva);
                    }elseif($batch==1){
                       $kwa=0;
                       $mid=count($madereva); 
                    }
                    
                    
            for($k=$kwa; $k<$mid; $k++){  
             $ft=0; $tw=0; $ot=0; $mv=0; $in=0; $too=0;
                    
                    $uuId=$madereva[$k];
                    $drivers= Cardrivers::find()->where(['userId'=>$uuId])->all();
                    
                if($drivers!=null){
                    foreach ($drivers as $driver){
                        
                         $checkOps= Movements::find()->where(['driverId'=>$driver->id,'company'=>\Yii::$app->session->get('company')])->all();
                         if($checkOps != null){
                        
                        $allc=Movements::driverAmountOfLoadByTimeArray($driver->id,$from,$to);
                        $ft=$ft + $allc['forty'];
                        $tw=$tw + $allc['twenty'];
                        $ot=$ot + $allc['other'];
                        //$ft=$ft + Movements::driverAmountOfLoadBySizeTime($driver->id,$from,$to,4);
                        //$tw=$tw + Movements::driverAmountOfLoadBySizeTime($driver->id,$from,$to,2);
                        //$ot=$ot + Movements::driverAmountOfLoadBySizeTime($driver->id,$from,$to,0);
                        $dts= Movetype::driverIncentiveByTime($driver->id,$from,$to);
                        $mv=$mv + $dts['trips'];
                        $in=$in + $dts['incentive'];
                        $too=$too + Trafficoffences::calculateDriverCost($driver->id,$from,$to);
                       
                    } } } 
                    
                    if ($in>0){ 
                        
                    $allDrivers[$cnt]['name']=$driver->user->firstname.' '.$driver->user->lastname;
                    $allDrivers[$cnt]['foty']=$ft;
                    $allDrivers[$cnt]['twenty']=$tw;
                    $allDrivers[$cnt]['other']=$ot;
                    $allDrivers[$cnt]['moves']=$mv;
                    $allDrivers[$cnt]['incentive']=$in;
                    $allDrivers[$cnt]['deduction']=$too;
                    $allDrivers[$cnt]['netpay']=$in-$too;
                    
                    $average[$cnt]['val']=$allDrivers[$cnt]['name'];
                    $cnt++;
             } } }
        
            
            if ($allDrivers != null and $average!= null) array_multisort($average,SORT_DESC,$allDrivers);
        
        $exporter = new Spreadsheet([
            'dataProvider' => new ArrayDataProvider([
                'allModels' => $allDrivers
            ]),
            
            'columns' => [
                [
                    'attribute' => 'name',
                    'contentOptions' => [
                        'width' => [
                            '35px'
                        ],
                    ],
                ],
                [
                    'attribute' => 'foty',
                ],
                [
                    'attribute' => 'twenty',
                ],
                [
                    'attribute' => 'other',
                ],
                [
                    'attribute' => 'moves',
                ],
                [
                    'attribute' => 'incentive',
                ],
                [
                    'attribute' => 'deduction',
                ],
                [
                    'attribute' => 'netpay',
                ],
            ],
        ]);
        
        return $exporter->send('incentives.xls');
    }
    
    
    
    public function actionPrintdrivercontainerlist($from,$to,$userId){
        
        $cnt=0;
        $allDrivers=null;
        
        $drivers= Cardrivers::find()
        ->where(['userId'=>$userId])->all();
        
        if ($drivers != null){
            foreach ($drivers as $driv){
        
        $containers=Movements::find()
        ->where("interchangedate >= '$from' and interchangedate <= '$to' and driverId='$driv->id' and company=:c",[':c'=>\Yii::$app->session->get('company')])->orderBy(['interchangedate'=>SORT_DESC])->all();
        
        
        if($containers!=null){
            foreach ($containers as $container){
                
                    $tty=Movetype::findOne($container->movetypeId)->triptype;
                    $ince=Movetype::findOne($container->movetypeId)->incentive;
                    $ttyn='(Full)';
                    if ($tty==2){
                        $ttyn='(Empty)';
                        if($container->size==2){
                            $ince=Movetype::findOne($container->movetypeId)->incentive/2;
                        }
                    }elseif ($tty==3){
                        $ttyn='(Other)';
                    }
                    
                    $allDrivers[$cnt]['driver']=Uzers::findOne($userId)->firstname.' '.Uzers::findOne($userId)->lastname;
                    $allDrivers[$cnt]['container']=$container->containerno;
                    $allDrivers[$cnt]['truck']=$container->truckId;
                    $allDrivers[$cnt]['size']=Movetype::getContainerSize($container->size);
                    $allDrivers[$cnt]['type']=Movetype::findOne($container->movetypeId)->name.$ttyn;
                    $allDrivers[$cnt]['incentive']=$ince;
                    $allDrivers[$cnt]['date']=date('d-m-Y',strtotime($container->interchangedate));
                    $cnt++;
                    
                }  }
            } }
        
        $exporter = new Spreadsheet([
            'dataProvider' => new ArrayDataProvider([
                'allModels' => $allDrivers
            ]),
            
            'columns' => [
                
                [
                    'attribute' => 'container',
                ],
                
                [
                    'attribute' => 'truck',
                ],
                
                [
                    'attribute' => 'size',
                ],
                [
                    'attribute' => 'type',
                ],
                
                [
                    'attribute' => 'date',
                ],
            ],
        ]);
        
        return $exporter->send('drivercontainerlist.xls');
    }

    
    public function actionPrintclientcontainerlist($from,$to,$clientId,$shippingline){
        
        $allDrivers=null;
        $costrecords=null;
        
        if ($shippingline==0){
            
            $movetypes= Movetype::find()->all();
            
            $cnt=0;
            $cc=0;
            
            if ($movetypes != null){
                foreach ($movetypes as $movetype){
                    $movecost=$movetype->twentypay + $movetype->fortypay + $movetype->otherpay;
          
           
            
            $containers=Movements::find()
            ->where("interchangedate >= '$from' and interchangedate <= '$to' and clientId='$clientId' and movetypeId='$movetype->id' and company=:c",[':c'=>\Yii::$app->session->get('company')])->orderBy(['interchangedate'=>SORT_DESC])->all();
          
            $tttwenty=0;
            $ttforty=0;
            $ttothers=0;
            $ttcharges=0;
            $charge2=$movetype->twentypay;
            $charge0=$movetype->otherpay;
            $charge4=$movetype->fortypay;
            
            if($containers!=null){
                foreach ($containers as $container){
                    $allDrivers[$cnt]['container']=$container->containerno;
                    $allDrivers[$cnt]['size']=Movetype::getContainerSize($container->size);
                    $allDrivers[$cnt]['movement']=Movetype::findOne($container->movetypeId)->name;
                    $allDrivers[$cnt]['truck']=$container->truckId;
                    $allDrivers[$cnt]['driver']=$container->driver->user->fullName;
                    $allDrivers[$cnt]['date']=date('d-m-Y',strtotime($container->interchangedate));
                    $allDrivers[$cnt]['shippingline']=Clients::findOne($container->shippingline)->name;
                    $cnt++;
                    
                    if ($container->size==2){
                        $tttwenty++;
                        $ttcharges=$ttcharges+Movetype::findOne($container->movetypeId)->twentypay;
                    }elseif ($container->size==4){
                        $ttforty++;
                        $ttcharges=$ttcharges+Movetype::findOne($container->movetypeId)->fortypay;
                    }else{
                        $ttothers++;
                        $ttcharges=$ttcharges+Movetype::findOne($container->movetypeId)->otherpay;
                    }
                }
                
                $signal=0;
                
                if ($costrecords != null){
                for ($i=0; $i<count($costrecords); $i++){
                    if(($costrecords[$i]['20charge'] +  $costrecords[$i]['40charge'] + $costrecords[$i]['0charge'])==$movecost){
                        $costrecords[$i]['20ft']=$tttwenty+$costrecords[$i]['20ft'];
                        $costrecords[$i]['40ft']=$ttforty+$costrecords[$i]['40ft'];
                        $costrecords[$i]['others']=$ttothers+$costrecords[$i]['others'];
                        $costrecords[$i]['TotalCharges']=$ttcharges+$costrecords[$i]['TotalCharges'];
                        
                        $signal=1;
                        }
                    }
                }
              
                if ($signal==0){
                    $costrecords[$cc]['Client']=Clients::findOne($clientId)->name;
                    $costrecords[$cc]['20ft']=$tttwenty;
                    $costrecords[$cc]['20charge']=$charge2;
                    $costrecords[$cc]['40ft']=$ttforty;
                    $costrecords[$cc]['40charge']=$charge4;
                    $costrecords[$cc]['others']=$ttothers;
                    $costrecords[$cc]['0charge']=$charge0;
                    $costrecords[$cc]['TotalCharges']=$ttcharges;
                $cc++;
                }
            }
            
                }
            }
            
        }else{
            
            $movetypes= Movetype::find()->all();
            
            
            $cnt=0;
            $cc=0;
            
            if ($movetypes != null){
                foreach ($movetypes as $movetype){
                    $movecost=$movetype->twentypay + $movetype->fortypay + $movetype->otherpay;
                    
            
            $containers=Movements::find()
            ->where("interchangedate >= '$from' and interchangedate <= '$to' and clientId='$clientId' and movetypeId='$movetype->id' and shippingline='$shippingline' and company=:c",[':c'=>\Yii::$app->session->get('company')])->orderBy(['interchangedate'=>SORT_DESC])->all();
         
            $tttwenty=0;
            $ttforty=0;
            $ttothers=0;
            $ttcharges=0;
            $charge2=$movetype->twentypay;
            $charge0=$movetype->otherpay;
            $charge4=$movetype->fortypay;
            if($containers!=null){
                foreach ($containers as $container){
                    $allDrivers[$cnt]['container']=$container->containerno;
                    $allDrivers[$cnt]['size']=Movetype::getContainerSize($container->size);
                    $allDrivers[$cnt]['movement']=Movetype::findOne($container->movetypeId)->name;
                    $allDrivers[$cnt]['truck']=$container->truckId;
                    $allDrivers[$cnt]['driver']=$container->driver->user->fullName;
                    $allDrivers[$cnt]['date']=date('d-m-Y',strtotime($container->interchangedate));
                    $allDrivers[$cnt]['shippingline']=Clients::findOne($shippingline)->name;
                    $cnt++;
                    
                    if ($container->size==2){
                        $tttwenty++;
                        $ttcharges=$ttcharges+Movetype::findOne($container->movetypeId)->twentypay;
                    }elseif ($container->size==4){
                        $ttforty++;
                        $ttcharges=$ttcharges+Movetype::findOne($container->movetypeId)->fortypay;
                    }else{
                        $ttothers++;
                        $ttcharges=$ttcharges+Movetype::findOne($container->movetypeId)->otherpay;
                    }
                }
                
                $signal=0;
                if ($costrecords !=null){
                for ($i=0; $i<count($costrecords); $i++){
                    if(($costrecords[$i]['20charge']+$costrecords[$i]['40charge']+$costrecords[$i]['0charge'])==$movecost){
                        
                        $costrecords[$i]['20ft']=$tttwenty+$costrecords[$i]['20ft'];
                        $costrecords[$i]['40ft']=$ttforty+$costrecords[$i]['40ft'];
                        $costrecords[$i]['others']=$ttothers+$costrecords[$i]['others'];
                        $costrecords[$i]['TotalCharges']=$ttcharges+$costrecords[$i]['TotalCharges'];
                        
                        $signal=1;
                        }
                    }
                }
                
                if ($signal==0){
                $costrecords[$cc]['Client']=Clients::findOne($clientId)->name;
                $costrecords[$cc]['20ft']=$tttwenty;
                $costrecords[$cc]['20charge']=$charge2;
                $costrecords[$cc]['40ft']=$ttforty;
                $costrecords[$cc]['40charge']=$charge4;
                $costrecords[$cc]['others']=$ttothers;
                $costrecords[$cc]['0charge']=$charge0;
                $costrecords[$cc]['TotalCharges']=$ttcharges;
                $cc++;
                }
                
            }
                }
            }
        }
        
        $exporter = (new Spreadsheet([
            'title' => 'ContainerList',
            'dataProvider' => new ArrayDataProvider([
                'allModels' => $allDrivers
            ]),
            
            'columns' => [
                
                [
                    'attribute' => 'container',
                ],
                [
                    'attribute' => 'size',
                ],
                [
                    'attribute' => 'movement',
                ],
                [
                    'attribute' => 'truck',
                ],
                [
                    'attribute' => 'driver',
                ],
                [
                    'attribute' => 'date',
                ],
                [
                    'attribute' => 'shippingline',
                ],
            ],
        ]))->render();
                
        $exporter->configure([ // update spreadsheet configuration
            'title' => 'InvoicesDetails',
            'dataProvider' => new ArrayDataProvider([
                'allModels' =>$costrecords
            ]),
            
            'columns' => [
                
                [
                    'attribute' => 'Client',
                ],
                [
                    'attribute' => '20ft',
                ],
                
                [
                    'attribute' => '20charge',
                ],
                
                [
                    'attribute' => '40ft',
                ],
                
                [
                    'attribute' => '40charge',
                ],
                
                [
                    'attribute' => 'others',
                ],
                
                [
                    'attribute' => '0charge',
                ],
                
                [
                    'attribute' => 'TotalCharges',
                ],
            ],
            
        ])->render();
        
        return $exporter->send('clientcontainerlist.xls');
    }
    
    
    public function actionDrivercontainerlist($from,$to,$userId){
        return $this->render('drivercontainerlist',['userId'=>$userId,'from'=>$from,'to'=>$to]);
    }
    
    public function actionClientcontainerlist($from,$to,$clientId){
        
        $containers=Movements::find()
        ->where("interchangedate >= '$from' and interchangedate <= '$to' and clientId='$driverId' and company=:c",[':c'=>\Yii::$app->session->get('company')])->orderBy(['interchangedate'=>SORT_DESC])->all();
        
        return $this->render('drivercontainerlist',['containers'=>$containers,'driverId'=>$driverId,'from'=>$from,'to'=>$to]);
    }
    
    public function actionReport()
    {
        $this->layout='main';
        $model = new Movements();
        
        if (isset($_POST['Movements'])) {
            
            if($_POST['Movements']['to'] > $_POST['Movements']['from']){
                $f=date('Y-m-d',strtotime($_POST['Movements']['from']));
                $t=date('Y-m-d',strtotime($_POST['Movements']['to']));
                $trucks=Cars::find()->where(['typeId' =>Cartype::getHorsesId(),'status'=>1,'company'=>\Yii::$app->session->get('company')])-> all();
                $fuelaverage=array();
                $fuelrecords=array();
                $summary=array();
                $cnt=0;
                $totalfuel=0;
                $totalspare=0;
                $totalince=0;
                $totalincomet=0;
                $totalincomeu=0;
                $totaltrips=0;
                
                if ($trucks != null){
                    foreach ($trucks as $truck){
                        $fuelrecords[$cnt]['car']=$truck->plateno;
                        $fuelrecords[$cnt]['trips']=Movements::carMovementsByTime($truck->plateno,$f,$t);
                        $fuelrecords[$cnt]['volume']=Fuelrequest::getTruckFueledAmountByTime($truck->plateno,$f,$t);
                        $fuelrecords[$cnt]['fuelcost']=Fuelrequest::getTruckConsumedfuelByTimeCost($truck->plateno,$f,$t);
                        $fuelrecords[$cnt]['sparecost']=Cars::getCarCostByTime($truck->plateno,$f,$t);
                        $fuelrecords[$cnt]['incecost']=Movetype::carIncentiveByTime($truck->plateno,$f,$t);
                        $fuelrecords[$cnt]['incomet']=Movements::carAmountOfIncomeByTime($truck->plateno,$f,$t,1);
                        $fuelrecords[$cnt]['incomeu']=Movements::carAmountOfIncomeByTime($truck->plateno,$f,$t,2);
                        
                        $fuelaverage[$cnt]['av']=($fuelrecords[$cnt]['incomeu'])*2300 + $fuelrecords[$cnt]['incomet'];
                        
                        
                        $totalfuel=$totalfuel+$fuelrecords[$cnt]['fuelcost'];
                        $totalspare=$totalspare+$fuelrecords[$cnt]['sparecost'];
                        $totalince=$totalince+$fuelrecords[$cnt]['incecost'];
                        $totalincomet=$totalincomet+$fuelrecords[$cnt]['incomet'];
                        $totalincomeu=$totalincomeu+$fuelrecords[$cnt]['incomeu'];
                        $totaltrips=$totaltrips+$fuelrecords[$cnt]['trips'];
                        
                        $cnt++;
                        
                    }
                    
                    $totalspare=$totalspare+Bills::getNoCarCostByTime($f,$t);
                    
                    if ($fuelaverage !=null and $fuelrecords != null) array_multisort($fuelaverage,SORT_DESC,$fuelrecords);
                    $summary['trucks']=count($trucks); $summary['totalfuel']= $totalfuel; $summary['totalspare']=$totalspare; $summary['totalincentive']=$totalince; $summary['totalincomet']=$totalincomet; 
                    $summary['totalincomeu']=$totalincomeu; $summary['trips']=$totaltrips;
                }
                
                
            $exporter = (new Spreadsheet([
            'title' => 'Managementreport',
            'dataProvider' => new ArrayDataProvider([
                'allModels' => $fuelrecords
            ]),
            
            'columns' => [
                
                [
                    'attribute' => 'car',
                ],
                [
                    'attribute' => 'trips',
                ],
                
                [
                    'attribute' => 'volume',
                ],
                
                [
                    'attribute' => 'fuelcost',
                ],
                
                [
                    'attribute' => 'sparecost',
                ],
                
                [
                    'attribute' => 'incecost',
                ],
                
                [
                    'attribute' => 'incomet',
                ],
                
                [
                    'attribute' => 'incomeu',
                ],
            ],
            
         ]))->render();
        
        return $exporter->send('managementreport.xls');
                
                
                /*
                
                $data = $this->renderPartial('_reportview',['datas'=>$fuelrecords,'from'=>$_POST['Movements']['from'],'to'=>$_POST['Movements']['to'],'summary'=>$summary]);
                
                $pdf = new Pdf([
                    'mode' => Pdf::MODE_CORE,
                    'format' => Pdf::FORMAT_A4,
                    'orientation' => Pdf::ORIENT_LANDSCAPE,
                    'destination' => Pdf::DEST_BROWSER,
                    'content' => $data,
                    'cssFile' => '@vendor/kartik-v/yii2-mpdf/src/assets/kv-mpdf-bootstrap.min.css',
                    'cssInline' => '.kv-heading-1{font-size:18px}',
                    'options' => ['title' => 'Fuel report'],
                    'methods' => [
                        'SetFooter'=>['{PAGENO}'],
                    ]
                ]);
                
                return $pdf->render(); */
                
            }else{
                \Yii::$app->session->setFlash('error','From can not be greater than to');
            }
        }
        
        return $this->render('report', [
            'model' => $model,
        ]);
    }
}