<?php

namespace app\controllers;

use Yii;
use app\models\Movefuelratio;
use app\models\MovefuelratioSearch;
use yii\web\Controller;
use yii\web\NotFoundHttpException;
use yii\filters\VerbFilter;

/**
 * MovefuelratioController implements the CRUD actions for Movefuelratio model.
 */
class MovefuelratioController extends Controller
{
    
        public function init() {
        
        if (\Yii::$app->session->get('layout') != null){
            $this->layout = \Yii::$app->session->get('layout');
        }else{
            $this->layout ='main';
        }
        
    }
    
    /**
     * {@inheritdoc}
     */
    public function behaviors()
    {
        return [
            'verbs' => [
                'class' => VerbFilter::className(),
                'actions' => [
                    'delete' => ['POST'],
                ],
            ],
        ];
    }

    /**
     * Lists all Movefuelratio models.
     * @return mixed
     */
    public function actionIndex()
    {
        $searchModel = new MovefuelratioSearch();
        $dataProvider = $searchModel->search(Yii::$app->request->queryParams);

        return $this->render('index', [
            'searchModel' => $searchModel,
            'dataProvider' => $dataProvider,
        ]);
    }

    /**
     * Displays a single Movefuelratio model.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionView($id)
    {
        return $this->render('view', [
            'model' => $this->findModel($id),
        ]);
    }

    /**
     * Creates a new Movefuelratio model.
     * If creation is successful, the browser will be redirected to the 'view' page.
     * @return mixed
     */
    public function actionCreate()
    {
        $model = new Movefuelratio();

        if ($model->load(Yii::$app->request->post()) && $model->save()) {
            return $this->redirect(['view', 'id' => $model->id]);
        }

        return $this->render('create', [
            'model' => $model,
        ]);
    }

    /**
     * Updates an existing Movefuelratio model.
     * If update is successful, the browser will be redirected to the 'view' page.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionUpdate($id)
    {
        $allratio = Movefuelratio::find()
        ->where(['movetypeId'=>$id])
        ->all();
        

        if (isset($_POST['Movefuelratio'])) {
            foreach ($allratio as $i=>$ratio){
                $ratio->moveconsumption=$_POST['Movefuelratio'][$i]['moveconsumption'];
                $ratio->save();
            }
            \Yii::$app->session->setFlash('success','Successfull changed  movement fuel consumptions ratio');
            return $this->redirect(['movetype/view', 'id' => $id]);
        } 

        return $this->renderAjax('update', [
            'allratio'=>$allratio,'id'=>$id,
        ]);
    }

    /**
     * Deletes an existing Movefuelratio model.
     * If deletion is successful, the browser will be redirected to the 'index' page.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionDelete($id)
    {
        $this->findModel($id)->delete();

        return $this->redirect(['index']);
    }

    /**
     * Finds the Movefuelratio model based on its primary key value.
     * If the model is not found, a 404 HTTP exception will be thrown.
     * @param integer $id
     * @return Movefuelratio the loaded model
     * @throws NotFoundHttpException if the model cannot be found
     */
    protected function findModel($id)
    {
        if (($model = Movefuelratio::findOne($id)) !== null) {
            return $model;
        }

        throw new NotFoundHttpException('The requested page does not exist.');
    }
}
