<?php

namespace app\controllers;

use Yii;
use app\models\Invcontent;
use app\models\Invopayments;
use app\models\InvopaymentsSearch;
use yii\web\Controller;
use yii\web\NotFoundHttpException;
use yii\filters\VerbFilter;
use app\models\Invoices;
use app\models\Model;
use app\models\Invopaymentcontent;

/**
 * InvopaymentsController implements the CRUD actions for Invopayments model.
 */
class InvopaymentsController extends Controller
{
    
     public function init() {
        
        if (\Yii::$app->session->get('layout') != null){
            $this->layout = \Yii::$app->session->get('layout');
        }else{
            $this->layout ='accounts';
        }
        
    }
    
    /**
     * {@inheritdoc}
     */
    public function behaviors()
    {
        return [
            'verbs' => [
                'class' => VerbFilter::className(),
                'actions' => [
                    'delete' => ['POST'],
                ],
            ],
        ];
    }

    /**
     * Lists all Invopayments models.
     * @return mixed
     */
    public function actionIndex()
    {
        $searchModel = new InvopaymentsSearch();
        $dataProvider = $searchModel->search(Yii::$app->request->queryParams);

        return $this->render('index', [
            'searchModel' => $searchModel,
            'dataProvider' => $dataProvider,
        ]);
    }

    /**
     * Displays a single Invopayments model.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionView($id)
    {
        return $this->render('view', [
            'model' => $this->findModel($id),
        ]);
    }

    /**
     * Creates a new Invopayments model.
     * If creation is successful, the browser will be redirected to the 'view' page.
     * @return mixed
     */
    public function actionCreateOld($id)
    {
        $fileId= \Yii::$app->session->get('fileId');
        if ($fileId != 0) $this->layout='cnf';
        
        $model = new Invopayments();

        if ($model->load(Yii::$app->request->post())) {
            
            $model->invId=$id;
            $model->date=date('Y-m-d');
            $model->company=\Yii::$app->session->get('company');
            $model->userId=\Yii::$app->user->getId();
            
            if (number_format($model->amount,2)<=number_format((Invcontent::getInvoiceCost($id)-Invopayments::getInvoicePaidAmount($id)),2) && $model->amount>0){
                if($model->save()){
                    if((Invcontent::getInvoiceCost($id)-Invopayments::getInvoicePaidAmount($id))==0){
                    $invoice=Invoices::findOne($id);
                    $invoice->paid=1;
                    $invoice->save();
                    }
                    \Yii::$app->session->setFlash('success','Successfull saved invoice payments');
                     return $this->redirect(['invoices/index']);
                        }
              }else{
                    \Yii::$app->session->setFlash('error','Error on the amount paid,it exceed the invoice balance or you have entered a negative amount');
            }
        }

        return $this->render('create', [
            'model' => $model,'id'=>$id,
        ]);
    }
    
    
    
    public function actionCreate($id)
    {
        $modelpayemnt = new Invopayments();
        $modelpaycontent = [new Invopaymentcontent()];
        if ($modelpayemnt->load(Yii::$app->request->post())) {
            
            $modelpayemnt->date=date('Y-m-d');
            $modelpayemnt->company=\Yii::$app->session->get('company');
            $modelpayemnt->userId=\Yii::$app->user->getId();
            
            $modelpaycontent = Model::createMultiple(Invopaymentcontent::classname());
            Model::loadMultiple($modelpaycontent, Yii::$app->request->post());
            
            
            
            // validate all models
            $valid = $modelpayemnt->validate();
            $valid = Model::validateMultiple($modelpaycontent) && $valid;
            
            if ($valid) {
                $transaction = \Yii::$app->db->beginTransaction();
                try {
                    if ($flag = $modelpayemnt->save(false)) {
                        foreach ($modelpaycontent as $paycont) {
                            
                            if (number_format($paycont->amount,2)<=number_format((Invcontent::getInvoiceCost($paycont->invoid)-Invopayments::getInvoicePaidAmount($paycont->invoid)),2)
                                && $paycont->amount>0 && number_format($paycont->amount,2)<=number_format(($modelpayemnt->amount-Invopaymentcontent::getTotalAmountByPaymentId($modelpayemnt->id)),2)){
                             
                                $paycont->invopaymentid = $modelpayemnt->id;
                                if (! ($flag = $paycont->save(false))) {
                                    $transaction->rollBack();
                                    break;
                                }else{
                                    if((Invcontent::getInvoiceCost($paycont->invoid)-Invopayments::getInvoicePaidAmount($paycont->invoid))==0){
                                        $invoice=Invoices::findOne($paycont->invoid);
                                        $invoice->paid=1;
                                        $invoice->save();  
                                    }  
                                }
                            }else{
                                \Yii::$app->session->setFlash('error','Error on the amount paid: either it exceed the invoice balance or you have entered a negative amount');
                                return $this->redirect(['invopayments/create','id'=>$id]);
                            }
                        }
                    }
                    if ($flag) {
                        $transaction->commit();
                        return $this->redirect(['invoices/index']);
                    }
                } catch (Exception $e) {
                    $transaction->rollBack();
                }
            }else{
                \Yii::$app->session->setFlash('error','Error on the validation');
                
            }
        }
        
        return $this->render('create', [
            'id'=>$id,
            'modelpayemnt' => $modelpayemnt,
            'modelpaycontent' => (empty($modelpaycontent)) ? [new Invopaymentcontent()] : $modelpaycontent
        ]);
    }
    
    /**
     * Updates an existing Invopayments model.
     * If update is successful, the browser will be redirected to the 'view' page.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionUpdate($id)
    {
        $model = $this->findModel($id);

        if ($model->load(Yii::$app->request->post()) && $model->save()) {
            return $this->redirect(['view', 'id' => $model->id]);
        }

        return $this->render('update', [
            'model' => $model,
        ]);
    }

    /**
     * Deletes an existing Invopayments model.
     * If deletion is successful, the browser will be redirected to the 'index' page.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionDelete($id)
    {
        $this->findModel($id)->delete();

        return $this->redirect(['index']);
    }

    /**
     * Finds the Invopayments model based on its primary key value.
     * If the model is not found, a 404 HTTP exception will be thrown.
     * @param integer $id
     * @return Invopayments the loaded model
     * @throws NotFoundHttpException if the model cannot be found
     */
    protected function findModel($id)
    {
        if (($model = Invopayments::findOne($id)) !== null) {
            return $model;
        }

        throw new NotFoundHttpException('The requested page does not exist.');
    }
}