<?php

namespace app\controllers;

use Yii;
use yii2tech\spreadsheet\Spreadsheet;
use yii\data\ArrayDataProvider;
use Behat\Gherkin\Exception\Exception;
use app\models\Bills;
use app\models\Exrate;
use app\models\Invoices;
use app\models\InvoicesSearch;
use app\models\Invonames;
use app\models\Invopayments;
use app\models\Servicecost;
use yii\web\Controller;
use yii\web\NotFoundHttpException;
use yii\filters\VerbFilter;
use app\models\Accounts;
use app\models\Invcontent;
use yii\data\ActiveDataProvider;
use kartik\mpdf\Pdf;
use app\models\Model;
use yii\helpers\ArrayHelper;
use app\models\Invopaymentcontent;

/**
 * InvoicesController implements the CRUD actions for Invoices model.
 */
class InvoicesController extends Controller
{
    public function init() {
        
        if (\Yii::$app->session->get('layout') != null){
            $this->layout = \Yii::$app->session->get('layout');
        }else{
            $this->layout ='accounts';
        }
    }
    
    /**
     * {@inheritdoc}
     */
    public function behaviors()
    {
        return [
            'verbs' => [
                'class' => VerbFilter::className(),
                'actions' => [
                    'delete' => ['POST'],
                ],
            ],
        ];
    }

    /**
     * Lists all Invoices models.
     * @return mixed
     */
    public function actionIndex()
    {
        $fileId= \Yii::$app->session->get('fileId');
        if ($fileId != 0) $this->layout='cnf';
        
        $searchModel = new InvoicesSearch();
        $dataProvider = $searchModel->search(Yii::$app->request->queryParams);
    
        return $this->render('index', [
            'searchModel' => $searchModel,
            'dataProvider' => $dataProvider,
        ]);
    }

    /**
     * Displays a single Invoices model.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionView($id)
    {
        return $this->render('view', [
            'model' => $this->findModel($id),
        ]);
    }
    
    public function actionUnlock($id)
    {
        $invoice= Invoices::findOne($id);
        $invoice->lok=0;
        if ($invoice->save()){
            return $this->redirect(['invcontent/create', 'id' => $id]);
        }
    }

    /**
     * Creates a new Invoices model.
     * If creation is successful, the browser will be redirected to the 'view' page.
     * @return mixed
     */
       
    public function actionCreate()
    {
        $modelinvo = new Invoices();
        $modelinvocontent = [new Invcontent()];
        
        $fileId= \Yii::$app->session->get('fileId');
        if ($fileId==null){ $id=0; }else { $id=$fileId;  $this->layout='cnf'; }
        
        if ($modelinvo->load(Yii::$app->request->post())) {
            
            $modelinvo->date=date('Y-m-d');
            $modelinvo->company=\Yii::$app->session->get('company');
            $modelinvo->userId=\Yii::$app->user->getId();
            $modelinvo->description=$modelinvo->description;
            $modelinvo->fileId=$id;
            $modelinvo->accId=Invoices::getAccountId($modelinvo->clientId);
            $modelinvo->currency==2? $modelinvo->exrateId=Exrate::getRecentRateId():null;
            
            $modelinvocontent= Model::createMultiple(Invcontent::classname());
            Model::loadMultiple($modelinvocontent, Yii::$app->request->post());
            
            
            
            // validate all models
            $valid = $modelinvo->validate();
            
            if ($valid) {
                $transaction = \Yii::$app->db->beginTransaction();
                try {
                    if ($flag = $modelinvo->save(false)) {
                        
                        foreach ($modelinvocontent as $model) {
                            $model->invId=$modelinvo->id;
                            $model->date=date('Y-m-d',strtotime($model->date));
                            $valid=$model->validate();
                            $contId=Invcontent::checkServiceInInvoice($model->serviceId,$modelinvo->id,$model->amount);
                            
                            if ($valid && $contId==null){
                                if (! ($flag = $model->save(false))) {
                                    $transaction->rollBack();
                                    break;
                                }
                            }else{
                                \Yii::$app->session->setFlash('error','Mis-matching currency,or problems in the fields');
                                $transaction->rollBack();
                                break;
                            }
                        }
                        
                        if ($flag) {
                            
                            $lockinvoice= Invoices::findOne($modelinvo->id);
                            $lockinvoice->lok=1;
                            $lockinvoice->save();
                            
                            $transaction->commit();
                            return $this->redirect(['invcontent/printinvoice', 'id' => $modelinvo->id]);
                        }
                        
                    }
                    
                } catch (Exception $e) {
                    $transaction->rollBack();
                }
            }else{
                \Yii::$app->session->setFlash('error','Error on the validation');
            }
        
     
        }
        
        $invoices=count(Invoices::find()->where(['company'=>\Yii::$app->session->get('company')])->all());
        $paids=count(Invopayments::find()->where(['company'=>\Yii::$app->session->get('company')])->all());
        $balance=$invoices-$paids;
        $paidtoday= count(Invopayments::find()->where(['date'=>date('Y-m-d'),'company'=>\Yii::$app->session->get('company')])->all());
        
        
        if ($balance>200){
            
            if ($paidtoday<10){
                \Yii::$app->session->setFlash('error','YOU CAN NOT CREATE NEW INVOICE, TOO MUCH OVERDUE, PLEASE RECORD PAYMENT OF ATLEAST 10 INVOICE BEFORE CREATING NEW INVOICE');
                
                return $this->redirect(['index']);
            }
        }else{
            
            
            return $this->render('create', [
                'modelinvo' => $modelinvo,
                'modelinvocontent' => (empty($modelinvocontent)) ? [new Invcontent()] : $modelinvocontent
            ]);
            
        }
    
    }
  
    
    
    public function actionCreatesub($id)
    {
        $modelinvo = new Invoices();
        $modelinvocontent = [new Invcontent()];
        
        $fileId= \Yii::$app->session->get('fileId');
        if ($fileId==null){ $fid=0; }else { $fid=$fileId;  $this->layout='cnf'; }
        
        
        $bs=Invonames::find()->where(['invoid'=>$id])->orderBy(['id'=>SORT_DESC])->all();
        $nvalue=null;
        if ($bs!=null){
            foreach ($bs as $b){
                $nvalue=$b;
                break;
            }
            
            ////
            
            if ($modelinvo->load(Yii::$app->request->post())) {
                
                $modelinvo->date=date('Y-m-d');
                $modelinvo->company=\Yii::$app->session->get('company');
                $modelinvo->userId=\Yii::$app->user->getId();
                $modelinvo->description=$modelinvo->description;
                $modelinvo->fileId=$fid;
                $modelinvo->accId=Invoices::findOne($id)->accId;
                $modelinvo->clientId=Invoices::findOne($id)->clientId;
                $modelinvo->currency==2? $modelinvo->exrateId=Exrate::getRecentRateId():null;
                
                $modelinvocontent= Model::createMultiple(Invcontent::classname());
                Model::loadMultiple($modelinvocontent, Yii::$app->request->post());
                
                
                // validate all models
                $valid = $modelinvo->validate();
                
                if ($valid) {
                    $transaction = \Yii::$app->db->beginTransaction();
                    try {
                        if ($flag = $modelinvo->save(false)) {
                            
                            foreach ($modelinvocontent as $model) {
                                $model->invId=$modelinvo->id;
                                $model->date=date('Y-m-d',strtotime($model->date));
                                $valid=$model->validate();
                                $contId=Invcontent::checkServiceInInvoice($model->serviceId,$modelinvo->id,$model->amount);
                                
                                if ($valid && $contId==null){
                                    if (! ($flag = $model->save(false))) {
                                        $transaction->rollBack();
                                        break;
                                    }
                                }else{
                                    \Yii::$app->session->setFlash('error','Mis-matching currency,or problems in the fields');
                                    $transaction->rollBack();
                                    break;
                                }
                            }
                            
                            if ($flag) {
                                
                                $no=$nvalue->no;
                                $nnm=$nvalue->nm;
                                $nnm++;
                                
                                $set=new Invonames();
                                $set->invoid=$modelinvo->id;
                                $set->no=$no;
                                $set->fileId=$fid;
                                $set->nm=$nnm;
                                $set->date=date('Y-m-d');
                                $set->company=\Yii::$app->session->get('company');
                                $set->tax=$modelinvo->tax;
                                $set->save();
                                
                                $lockinvoice= Invoices::findOne($modelinvo->id);
                                $lockinvoice->lok=1;
                                $lockinvoice->save();
                                
                                $transaction->commit();
                                return $this->redirect(['invcontent/printinvoice', 'id' => $modelinvo->id]);
                            }
                            
                        }
                        
                    } catch (Exception $e) {
                        $transaction->rollBack();
                    }
                }else{
                    \Yii::$app->session->setFlash('error','Error on the validation');
                }
                
                
            }
            
        }
        
        
        return $this->render('createsub', [
            'modelinvo' => $modelinvo,
            'modelinvocontent' => (empty($modelinvocontent)) ? [new Invcontent()] : $modelinvocontent
        ]);
        
    }


    /**
     * Updates an existing Invoices model.
     * If update is successful, the browser will be redirected to the 'view' page.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionUpdate($id)
    {
        $modelinvo = $this->findModel($id);
        $modelinvocontent = $modelinvo->invcontents;
        
        if ($modelinvo->load(Yii::$app->request->post())) {
            
            $oldIDs = ArrayHelper::map($modelinvocontent, 'id', 'id');
            $modelinvocontent = Model::createMultiple(Invcontent::classname(), $modelinvocontent);
            Model::loadMultiple($modelinvocontent, Yii::$app->request->post());
            $deletedIDs = array_diff($oldIDs, array_filter(ArrayHelper::map($modelinvocontent, 'id', 'id')));
            
            
            // validate all models
            $modelinvo->currency==2? $modelinvo->exrateId=Exrate::getRecentRateId():null;
            $valid = $modelinvo->validate();
            
            if ($valid) {
                $transaction = \Yii::$app->db->beginTransaction();
                try {
                    if ($flag = $modelinvo->save(false)) {
                        if (! empty($deletedIDs)) {
                            Invcontent::deleteAll(['id' => $deletedIDs]);
                        }
                        foreach ($modelinvocontent as $model) {
                            $model->invId = $id;
                            $model->date=date('Y-m-d',strtotime($model->date));
                            
                            $valid=$model->validate();
                            
                            if ($valid){
                                if (! ($flag = $model->save(false))) {
                                    $transaction->rollBack();
                                    break;
                                }
                            }
                        }
                    }
                    if ($flag) {
                        $transaction->commit();
                        \Yii::$app->session->setFlash('success','Successfully edited invoice');
                         return $this->redirect(['invcontent/printinvoice', 'id' => $id]);
                    }
                } catch (Exception $e) {
                    $transaction->rollBack();
                }
            }
        }
        
        return $this->render('update', [
            'modelinvo' => $modelinvo,
            'modelinvocontent' => (empty($modelinvocontent)) ? [new Invcontent()] : $modelinvocontent
        ]);
    }

    /**
     * Deletes an existing Invoices model.
     * If deletion is successful, the browser will be redirected to the 'index' page.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
        public function actionDelete($id)
    {
        
        if (Invoices::getInvoiceContents($id)==null){
            
            $invnames=Invonames::find()->where(['invoid'=>$id])->all();
            
            if ($invnames != null){
                foreach ($invnames as $nm){
                    $nm->delete();
                }
            }
            
            $payments=Invopaymentcontent::find()->where(['invoid'=>$id])->all();
            
            if ($payments != null){
                foreach ($payments as $pay){
                    $pay->delete();
                }
            }
            
            
            $conts=Invcontent::find()->where(['invId'=>$id])->all();
            
            if ($conts != null){
                foreach ($conts as $cont){
                    $cont->delete();
                }
            }
            
            $this->findModel($id)->delete();
            
        }else{
            \Yii::$app->session->setFlash('error','This invoice can not be deleted it has contents');
            return $this->redirect(['index']);
        }
        
        
        
        return $this->redirect(['index']);
    }
    
    public function actionTax()
    {
       $names=Invonames::find()->all();
       
       foreach ($names as $name){
           $name->tax=Invoices::findOne($name->invoid)->tax;
           $name->save();
       }
        
        //return $this->redirect(['index']);
    }

    /**
     * Finds the Invoices model based on its primary key value.
     * If the model is not found, a 404 HTTP exception will be thrown.
     * @param integer $id
     * @return Invoices the loaded model
     * @throws NotFoundHttpException if the model cannot be found
     */
    protected function findModel($id)
    {
        if (($model = Invoices::findOne($id)) !== null) {
            return $model;
        }

        throw new NotFoundHttpException('The requested page does not exist.');
    }
    
    
    
        
    public function actionSalesreportpdf()
    {
        $model= new Invoices();
        $dataProvider=null;
        $from=null;
        $to=null;
        
        if (isset($_POST['Invoices'])) {
            $f=$_POST['Invoices']['from'];
            $t=$_POST['Invoices']['to'];
            $from=date('Y-m-d',strtotime($_POST['Invoices']['from']));
            $to=date('Y-m-d',strtotime($_POST['Invoices']['to']));
            $cmpn=\Yii::$app->session->get('company');
            $typ=1;
            $contents = Invoices::find()->where("date>='$from' and date <='$to' and company='$cmpn'")->orderBy(['date'=>SORT_DESC])->all();
            
            
            $data = $this->renderPartial('_salesview',['contents'=>$contents,'from'=>$f,'to'=>$t]);
            
            $from=$f;
            $to=$t;
            
            $pdf = new Pdf([
                'mode' => Pdf::MODE_CORE,
                'format' => Pdf::FORMAT_A4,
                'orientation' => Pdf::ORIENT_PORTRAIT,
                'destination' => Pdf::DEST_BROWSER,
                'content' => $data,
                'cssFile' => '@vendor/kartik-v/yii2-mpdf/src/assets/kv-mpdf-bootstrap.min.css',
                'cssInline' => '.kv-heading-1{font-size:18px}',
                'options' => ['title' => 'Invoice'],
                'methods' => [
                    'SetFooter'=>['{PAGENO}'],
                ]
            ]);
            
            return $pdf->render();
            
            
        }
        
        return $this->render('salesreport', [
            'model' => $model,
            'dataProvider' => $dataProvider,
            'from'=>$from,
            'to'=>$to,
        ]);
    }
    
    
        public function actionSalesreport()
    {
        $model= new Invoices();
        $dataProvider=null;
        $from=null;
        $to=null;
        $allsales=null;
        $cnt=0;
        
        if (isset($_POST['Invoices'])) {
            $f=$_POST['Invoices']['from'];
            $t=$_POST['Invoices']['to'];
            $from=date('Y-m-d',strtotime($_POST['Invoices']['from']));
            $to=date('Y-m-d',strtotime($_POST['Invoices']['to']));
            $cmpn=\Yii::$app->session->get('company');
            $typ=1;
            $contents = Invoices::find()->where("date>='$from' and date <='$to' and company='$cmpn'")->orderBy(['date'=>SORT_DESC])->all();
            
            if ($contents != null){
    		foreach ($contents as $content){
    			$allsales[$cnt]['invoNo']= Invoices::getInvoiceNo(Invoices::findOne($content->id)->company,$content->id);
    			$allsales[$cnt]['type']=Invoices::getInvoiceType(Invoices::findOne($content->id)->type).' '. Invoices::getInvoiceTax($content->tax);
    			$allsales[$cnt]['date']=date('d-m-Y',strtotime($content->date));
    			$allsales[$cnt]['sale']=Invcontent::getInvoiceCost($content->id)-Invcontent::getInvoiceVatCost($content->id);
    			$allsales[$cnt]['currency']=Accounts::getCurrency($content->currency);
    			$cnt++;
    		}}
    		
    		     $exporter = new Spreadsheet([
            'dataProvider' => new ArrayDataProvider([
                'allModels' => $allsales
            ]),
            
            'columns' => [
               
                [
                    'attribute' => 'invoNo',
                ],
                [
                    'attribute' => 'date',
                ],
                [
                    'attribute' => 'sale',
                ],
                [
                    'attribute' => 'currency',
                ],
               
            ],
        ]);
        
        return $exporter->send('incentives.xls');
             
        }
        
        return $this->render('salesreport', [
            'model' => $model,
            'dataProvider' => $dataProvider,
            'from'=>$from,
            'to'=>$to,
        ]);
    }
    
    
    
        public function actionSalesreportclient()
    {
        $model= new Invoices();
        $dataProvider=null;
        $from=null;
        $to=null;
        $clie=null;
        
        if (isset($_POST['Invoices'])) {
            $f=$_POST['Invoices']['from'];
            $t=$_POST['Invoices']['to'];
            $from=date('Y-m-d',strtotime($_POST['Invoices']['from']));
            $to=date('Y-m-d',strtotime($_POST['Invoices']['to']));
            $clie=$_POST['Invoices']['clientId'];
            $cmpn=\Yii::$app->session->get('company');
            $typ=1;
            $contents = Invoices::find()->where("date>='$from' and date <='$to' and clientId='$clie' and company='$cmpn'")->orderBy(['date'=>SORT_DESC])->all();
            
            
            $data = $this->renderPartial('_salesviewclient',['contents'=>$contents,'from'=>$f,'to'=>$t,'clie'=>$clie]);
            
            $from=$f;
            $to=$t;
            
            $pdf = new Pdf([
                'mode' => Pdf::MODE_CORE,
                'format' => Pdf::FORMAT_A4,
                'orientation' => Pdf::ORIENT_PORTRAIT,
                'destination' => Pdf::DEST_BROWSER,
                'content' => $data,
                'cssFile' => '@vendor/kartik-v/yii2-mpdf/src/assets/kv-mpdf-bootstrap.min.css',
                'cssInline' => '.kv-heading-1{font-size:18px}',
                'options' => ['title' => 'Invoice'],
                'methods' => [
                    'SetFooter'=>['{PAGENO}'],
                ]
            ]);
            
            return $pdf->render();
            
            
        }
        
        return $this->render('salesreportclient', [
            'model' => $model,
            'dataProvider' => $dataProvider,
            'from'=>$from,
            'to'=>$to,
        ]);
    }
    
    
    
    public function actionAccountsummary()
    {
        $model= new Invoices();
        $dataProvider=null;
        $from=null;
        $to=null;
        
        if (isset($_POST['Invoices'])) {
            $f=$_POST['Invoices']['from'];
            $t=$_POST['Invoices']['to'];
            $from=date('Y-m-d',strtotime($_POST['Invoices']['from']));
            $to=date('Y-m-d',strtotime($_POST['Invoices']['to']));
            $clie=$_POST['Invoices']['clientId'];
            $cmpn=\Yii::$app->session->get('company');
            $contents = Invoices::find()->where("date>='$from' and date <='$to' and clientId='$clie' and company='$cmpn'")->orderBy(['date'=>SORT_DESC])->all();
           
       
            $data = $this->renderPartial('_summaryview',['clie'=>$clie,'contents'=>$contents]);
            
            $from=$f;
            $to=$t;
            
            $pdf = new Pdf([
                'mode' => Pdf::MODE_CORE,
                'format' => Pdf::FORMAT_A4,
                'orientation' => Pdf::ORIENT_PORTRAIT,
                'destination' => Pdf::DEST_BROWSER,
                'content' => $data,
                'cssFile' => '@vendor/kartik-v/yii2-mpdf/src/assets/kv-mpdf-bootstrap.min.css',
                'cssInline' => '.kv-heading-1{font-size:18px}',
                'options' => ['title' => 'Invoice'],
                'methods' => [
                    'SetFooter'=>['{PAGENO}'],
                ]
            ]);
            
            return $pdf->render();
            
            
        }
        
        return $this->render('accountsummary', [
            'model' => $model,
            'dataProvider' => $dataProvider,
            'from'=>$from,
            'to'=>$to,
        ]);
    }
    
    
    
    
    public function actionMovementsummary()
    {
        $model= new Invoices();
        $from=null;
        $to=null;
        $clienttype=null;
        
        if (isset($_POST['Invoices'])) {
            $from=$_POST['Invoices']['from'];
            $to=$_POST['Invoices']['to'];
            $clienttype=$_POST['Invoices']['clienttype'];
        }
        
        return $this->render('movementsummary', [
            'model' => $model,
            'clienttype' => $clienttype,
            'from'=>$from,
            'to'=>$to,
        ]);
    }
    
    
        public function actionGetPrice($selected)
    {
        $service= Servicecost::find()->where(['serviceId'=>$selected,'status'=>1])->one();
        
        echo json_encode($service->saleamount);
    }
    
}