<?php

namespace app\controllers;

use Yii;
use app\models\Billcontent;
use app\models\Cfbills;
use app\models\Cfile;
use app\models\Invcontent;
use app\models\InvcontentSearch;
use app\models\Invoices;
use app\models\Packages;
use app\models\Servicecost;
use app\models\Services;
use yii\web\Controller;
use yii\web\NotFoundHttpException;
use yii\filters\VerbFilter;
use yii\helpers\Html;
use kartik\mpdf\Pdf;
use yii\data\ActiveDataProvider;
use app\models\Model;
use Behat\Gherkin\Exception\Exception;

/**
 * InvcontentController implements the CRUD actions for Invcontent model.
 */
class InvcontentController extends Controller
{
    
    public function init() {
        
        if (\Yii::$app->session->get('layout') != null){
            $this->layout = \Yii::$app->session->get('layout');
        }else{
            $this->layout ='accounts';
        }
    }
    
    /**
     * {@inheritdoc}
     */
    public function behaviors()
    {
        return [
            'verbs' => [
                'class' => VerbFilter::className(),
                'actions' => [
                    'delete' => ['POST'],
                ],
            ],
        ];
    }

    /**
     * Lists all Invcontent models.
     * @return mixed
     */
    public function actionIndex()
    {
        $searchModel = new InvcontentSearch();
        $dataProvider = $searchModel->search(Yii::$app->request->queryParams);

        return $this->render('index', [
            'searchModel' => $searchModel,
            'dataProvider' => $dataProvider,
        ]);
    }

    /**
     * Displays a single Invcontent model.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionView($id)
    {
        return $this->render('view', [
            'model' => $this->findModel($id),
        ]);
    }

    /**
     * Creates a new Invcontent model.
     * If creation is successful, the browser will be redirected to the 'view' page.
     * @return mixed
     */
    public function actionCreate($id)
    {
        $fileId= Invoices::findOne($id)->fileId;
        if ($fileId != 0) $this->layout='cnf';
        
        $query = Invcontent::find();
        $query->andFilterWhere([
            'invId' => $id,
        ]);
        
        // add conditions that should always apply here
        
        $dataProvider = new ActiveDataProvider([
            'query' => $query,
        ]);
        
        if ($fileId==0){
        
            $models = [new Invcontent()];
            
            if (isset($_POST['Invcontent'])) {
                
                
                $models = Model::createMultiple(Invcontent::classname());
                Model::loadMultiple($models, Yii::$app->request->post());
                
                $valid = Model::validateMultiple($models);
                
                $transaction = \Yii::$app->db->beginTransaction();
                
                try {
                    foreach ($models as $model) {
                        $model->invId=$id;
                        $model->date=date('Y-m-d',strtotime($model->date));
                        $valid=$model->validate();
                        $contId=Invcontent::checkServiceInInvoice($model->serviceId,$id,$model->amount);
                        
                        if ($valid && $contId==null){
                            if (! ($flag = $model->save(false))) {
                                $transaction->rollBack();
                                break;
                            }
                        }else{
                            \Yii::$app->session->setFlash('error','Mis-matching currency,or problems in the fields');
                            $transaction->rollBack();
                            break;
                        }
                    }
                    
                    if ($flag) {
                        
                        $lockinvoice= Invoices::findOne($id);
                        $lockinvoice->lok=1;
                        $lockinvoice->save();
                        
                        $transaction->commit();
                        return $this->redirect(['create', 'id' => $id]);
                    }
                } catch (Exception $e) {
                    $transaction->rollBack();
                }
            } 
            
        }else{
            
            $models = new Invcontent();
            
            if(isset($_POST['Invcontent'])){
            $bills= Cfbills::find()->where(['fileId'=>$fileId])->all();
            $cnt=0;
            if ($bills != null){
                foreach ($bills as $bill){
                    $billcontents=Billcontent::find()->where(['billId'=>$bill->billId])->all();
                    
                    if ($billcontents != null){
                        foreach ($billcontents as $i=>$content){
                            
                            if(!empty($_POST['Invcontent'][$cnt]['serviceId'])){
                                if(Invcontent::checkServiceInInvoice($_POST['Invcontent'][$cnt]['serviceId'],$id,$_POST['Invcontent'][$cnt]['amount'])==null){
                                    $savemodel=new Invcontent();
                                    $savemodel->invId=$id;
                                    $savemodel->date=date('Y-m-d',strtotime($_POST['Invcontent'][$cnt]['date']));
                                    $savemodel->count=$_POST['Invcontent'][$cnt]['count'];
                                    $savemodel->amount=$_POST['Invcontent'][$cnt]['amount'];
                                    $savemodel->serviceId=$_POST['Invcontent'][$cnt]['serviceId'];
                                    $savemodel->save();
                                    
                                }
                            }
                            $cnt++;
                        }
                    }
                }
            }
            
            $agencyfee=Services::getServiceByName('Agency fee',Invoices::findOne($id)->currency);
            $handling=Services::getServiceByName('Handling charges',Invoices::findOne($id)->currency);
            $dropoff20=Services::getServiceByName('Drop off cost 20ft',Invoices::findOne($id)->currency);
            $quantity20=Packages::getQuantityByType(2);
            $dropoff40=Services::getServiceByName('Drop off cost 40ft',Invoices::findOne($id)->currency);
            $quantity40=Packages::getQuantityByType(4);
            $transcost=Services::getServiceByName('Transportation cost',Invoices::findOne($id)->currency);
            $transfee=Services::getServiceByName('Transportation fee',Invoices::findOne($id)->currency);
            $exposervice=Services::getServiceByName('export service charges',Invoices::findOne($id)->currency);
            $chemicaladd=Services::getServiceByName('Chemicals fee(transportation)',Invoices::findOne($id)->currency);
            
             if(Cfile::findOne(\Yii::$app->session->get('fileId'))->bulk ==1) {
                $totalquantity=round(Packages::getWeightByFile());
            }else{
                $totalquantity=$quantity20+$quantity40;
            }
            
            if ($agencyfee != null){
                
                if(!empty($_POST['Invcontent'][$cnt]['serviceId'])){
                    if(Invcontent::checkServiceInInvoice($_POST['Invcontent'][$cnt]['serviceId'],$id,$_POST['Invcontent'][$cnt]['amount'])==null){
                        $savemodel=new Invcontent();
                        $savemodel->invId=$id;
                        $savemodel->date=date('Y-m-d');
                        $savemodel->count=$totalquantity;
                        $savemodel->amount=$_POST['Invcontent'][$cnt]['amount'];
                        $savemodel->serviceId=$_POST['Invcontent'][$cnt]['serviceId'];
                        if($savemodel->amount != null) $savemodel->save();
                        
                    } } }
                    $cnt++;
                    
               if ($handling != null){
                
                if(!empty($_POST['Invcontent'][$cnt]['serviceId'])){
                    if(Invcontent::checkServiceInInvoice($_POST['Invcontent'][$cnt]['serviceId'],$id,$_POST['Invcontent'][$cnt]['amount'])==null){
                        $savemodel=new Invcontent();
                        $savemodel->invId=$id;
                        $savemodel->date=date('Y-m-d');
                        $savemodel->count=$totalquantity;
                        $savemodel->amount=$_POST['Invcontent'][$cnt]['amount'];
                        $savemodel->serviceId=$_POST['Invcontent'][$cnt]['serviceId'];
                        if($savemodel->amount != null) $savemodel->save();
                        
                    } } }
                    $cnt++;
                    
                    if ($dropoff20 != null and $quantity20>0){
                        
                        if(!empty($_POST['Invcontent'][$cnt]['serviceId'])){
                            if(Invcontent::checkServiceInInvoice($_POST['Invcontent'][$cnt]['serviceId'],$id,$_POST['Invcontent'][$cnt]['amount'])==null){
                                $savemodel=new Invcontent();
                                $savemodel->invId=$id;
                                $savemodel->date=date('Y-m-d');
                                $savemodel->count=$quantity20;
                                $savemodel->amount=$_POST['Invcontent'][$cnt]['amount'];
                                $savemodel->serviceId=$_POST['Invcontent'][$cnt]['serviceId'];
                                if($savemodel->amount != null)$savemodel->save();
                                
                            } } }
                            $cnt++;
                            if ($dropoff40 != null and $quantity40>0){
                                
                                if(!empty($_POST['Invcontent'][$cnt]['serviceId'])){
                                    if(Invcontent::checkServiceInInvoice($_POST['Invcontent'][$cnt]['serviceId'],$id,$_POST['Invcontent'][$cnt]['amount'])==null){
                                        $savemodel=new Invcontent();
                                        $savemodel->invId=$id;
                                        $savemodel->date=date('Y-m-d');
                                        $savemodel->count=$quantity40;
                                        $savemodel->amount=$_POST['Invcontent'][$cnt]['amount'];
                                        $savemodel->serviceId=$_POST['Invcontent'][$cnt]['serviceId'];
                                        if($savemodel->amount != null) $savemodel->save();
                                        
                                    }  } }
                                    $cnt++;
                                    if ($transcost != null and $totalquantity>0){
                                        
                                        if(!empty($_POST['Invcontent'][$cnt]['serviceId'])){
                                            if(Invcontent::checkServiceInInvoice($_POST['Invcontent'][$cnt]['serviceId'],$id, $_POST['Invcontent'][$cnt]['amount'])==null){
                                                $savemodel=new Invcontent();
                                                $savemodel->invId=$id;
                                                $savemodel->date=date('Y-m-d');
                                                $savemodel->count=$totalquantity;
                                                $savemodel->amount=$_POST['Invcontent'][$cnt]['amount'];
                                                $savemodel->serviceId=$_POST['Invcontent'][$cnt]['serviceId'];
                                                if($savemodel->amount != null)$savemodel->save();
                                                
                                            }  }  }
                                            
                                            $cnt++;
                                            if ($chemicaladd != null and $totalquantity>0){
                                                
                                                if(!empty($_POST['Invcontent'][$cnt]['serviceId'])){
                                                    if(Invcontent::checkServiceInInvoice($_POST['Invcontent'][$cnt]['serviceId'],$id, $_POST['Invcontent'][$cnt]['amount'])==null){
                                                        $savemodel=new Invcontent();
                                                        $savemodel->invId=$id;
                                                        $savemodel->date=date('Y-m-d');
                                                        $savemodel->count=$totalquantity;
                                                        $savemodel->amount=$_POST['Invcontent'][$cnt]['amount'];
                                                        $savemodel->serviceId=$_POST['Invcontent'][$cnt]['serviceId'];
                                                        if($savemodel->amount != null)$savemodel->save();
                                                        
                                                    }  }  }
                                             
                                            $cnt++;
                                            if ($transfee != null and $totalquantity>0){
                                                
                                                if(!empty($_POST['Invcontent'][$cnt]['serviceId'])){
                                                    if(Invcontent::checkServiceInInvoice($_POST['Invcontent'][$cnt]['serviceId'],$id, $_POST['Invcontent'][$cnt]['amount'])==null){
                                                        $savemodel=new Invcontent();
                                                        $savemodel->invId=$id;
                                                        $savemodel->date=date('Y-m-d');
                                                        $savemodel->count=$totalquantity;
                                                        $savemodel->amount=$_POST['Invcontent'][$cnt]['amount'];
                                                        $savemodel->serviceId=$_POST['Invcontent'][$cnt]['serviceId'];
                                                        if($savemodel->amount != null)$savemodel->save();
                                                        
                                                    }  }  }
                                            
                                            $cnt++;
                                            // if (Cfile::findOne(\Yii::$app->session->get('fileId'))->ftype==2){
                                            //$packages= Packages::find()->where(['fileId'=>Invoices::findOne($id)->fileId])->all();
                                            //if ($packages != null){
                                            // foreach ($packages as $j=>$package){
                                            if(!empty($_POST['Invcontent'][$cnt]['serviceId'])){
                                                $savemodel=new Invcontent();
                                                $savemodel->invId=$id;
                                                $savemodel->date=date('Y-m-d');
                                                $savemodel->count=$totalquantity;
                                                $savemodel->amount=$_POST['Invcontent'][$cnt]['amount'];
                                                $savemodel->serviceId=$_POST['Invcontent'][$cnt]['serviceId'];
                                                $savemodel->save();
                                                
                                                //$uppackage= Packages::findOne($package->id);
                                                // $uppackage->contentId=$savemodel->id;
                                                // $uppackage->save();
                                            }
                                            $cnt++;
                                            //}
                                            //}
                                            //}
                                            
                                             $lockinvoice= Invoices::findOne($id);
                                            $lockinvoice->lok=1;
                                            $lockinvoice->save();
                                            
                                            \Yii::$app->session->setFlash('success','Invoice contents Successfull saved');
                                            return $this->redirect(['create', 'id' => $id]);
        }
    }
        
        return $this->render('create', [
            'models' => $models,'dataProvider'=>$dataProvider,'id'=>$id,
        ]);
    }
    

    /**
     * Updates an existing Invcontent model.
     * If update is successful, the browser will be redirected to the 'view' page.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionUpdate($id)
    {
        $model = $this->findModel($id);
        
        $query = Invcontent::find();
        $query->andFilterWhere([
            'invId' => $model->invId,
        ]);
        
        $query->andFilterWhere(['!=', 'id', $id,]);
        
        // add conditions that should always apply here
        
        $dataProvider = new ActiveDataProvider([
            'query' => $query,
        ]);
        
        if ($model->load(Yii::$app->request->post())) {
            
            if ($model->amount>=Servicecost::getServiceCost($model->serviceId)->saleamount){
                if ($model->save()){
                    return $this->redirect(['create', 'id' => $model->invId]);
                }
            }else{
                \Yii::$app->session->setFlash('error','Sales price is lower than margin price');
            }
        }
        
                if (Invoices::findOne($model->invId)->lok==0){
        
            return $this->render('update', [
                'model' => $model,'dataProvider'=>$dataProvider
            ]);
            
        }else{
            \Yii::$app->session->setFlash('error','Invoice is locked, you can not edit, contact administrator');
            return $this->redirect(['create', 'id' => $model->invId]);
        }
    }

    /**
     * Deletes an existing Invcontent model.
     * If deletion is successful, the browser will be redirected to the 'index' page.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionDelete($id)
    {
        
        $content=$this->findModel($id);
        $invId=$content->invId;
        if (Invoices::findOne($content->invId)->lok==0){
        $content->delete();
        
        if (Cfile::findOne(\Yii::$app->session->get('fileId'))->ftype==2){
            $packages= Packages::find()->where(['fileId'=>\Yii::$app->session->get('fileId'),'contentId'=>$id])->one();
            
            if ($packages != null){
                $packages->contentId=0;
                $packages->save();
            }
           
            }
        }else{
            \Yii::$app->session->setFlash('error','The invoice is locked you cannot delete, contact administrator');
        }

        return $this->redirect(['create','id'=>$invId]);
    }

    /**
     * Finds the Invcontent model based on its primary key value.
     * If the model is not found, a 404 HTTP exception will be thrown.
     * @param integer $id
     * @return Invcontent the loaded model
     * @throws NotFoundHttpException if the model cannot be found
     */
    protected function findModel($id)
    {
        if (($model = Invcontent::findOne($id)) !== null) {
            return $model;
        }

        throw new NotFoundHttpException('The requested page does not exist.');
    }
    
    public function actionPrintinvoice($id) {
        
        $model= Invoices::findOne($id);
        $model->lok=1;
        $model->save();
        $contents=Invcontent::find()->where(['invId'=>$id])->all();
        $data = $this->renderPartial('_invoiceview',['model'=>$model,'contents'=>$contents]);
        
        $pdf = new Pdf([
            'mode' => Pdf::MODE_CORE,
            'format' => Pdf::FORMAT_A4,
            'orientation' => Pdf::ORIENT_PORTRAIT,
            'destination' => Pdf::DEST_BROWSER,
            'content' => $data,
            'cssFile' => '@vendor/kartik-v/yii2-mpdf/src/assets/kv-mpdf-bootstrap.min.css',
            'cssInline' => '.kv-heading-1{font-size:18px}',
            'options' => ['title' => 'Invoice'],
            'methods' => [
               'SetFooter'=>['{PAGENO}'],
            ]
        ]);
        
        return $pdf->render();
    }
    
    
    public function actionCostcreate() {
        Yii::$app->response->format = \yii\web\Response::FORMAT_JSON;
        if (isset($_POST['depdrop_parents'])) {
            $parents = $_POST['depdrop_parents'];
            if ($parents != null) {
                $cat_id = $_POST['depdrop_parents'];
                $out =[['id'=>Servicecost::getServiceCost($cat_id)->saleamount, 'name'=>number_format(Servicecost::getServiceCost($cat_id)->saleamount)]];
                return ['output'=>$out, 'selected'=>''];
            }
        }
        return ['output'=>'', 'selected'=>''];
    }
    
    
    public function actionGetPrice($selected)
    {
        $service= Servicecost::find()->where(['serviceId'=>$selected,'status'=>1])->one();
        
        echo json_encode($service->saleamount);
    }
    
}