<?php

namespace app\controllers;

use Yii;
use app\models\Cars;
use app\models\Cartype;
use app\models\Fuelrequest;
use app\models\FuelrequestSearch;
use yii\web\Controller;
use yii\web\NotFoundHttpException;
use yii\filters\VerbFilter;
use kartik\mpdf\Pdf;
use app\models\Movements;
use app\models\Movetype;
use app\models\Movefuelratio;
use app\models\Offuels;

/**
 * FuelrequestController implements the CRUD actions for Fuelrequest model.
 */
class FuelrequestController extends Controller
{
  public function init() {
        
        if (\Yii::$app->session->get('layout') != null){
            $this->layout = \Yii::$app->session->get('layout');
        }else{
            $this->layout = 'operations';
        }
        
    }
    
    
    /**
     * {@inheritdoc}
     */
    public function behaviors()
    {
        return [
            'verbs' => [
                'class' => VerbFilter::className(),
                'actions' => [
                    'delete' => ['POST'],
                ],
            ],
        ];
    }

    /**
     * Lists all Fuelrequest models.
     * @return mixed
     */
    public function actionIndex()
    {
        
        $searchModel = new FuelrequestSearch();
        $dataProvider = $searchModel->search(Yii::$app->request->queryParams);

        return $this->render('index', [
            'searchModel' => $searchModel,
            'dataProvider' => $dataProvider,
        ]);
    }
    
    
    public function actionBorrowedlist()
    {
        return $this->render('borrowedlist');
    }
    
     public function actionShowborrowedlist($truckid)
    {
        return $this->render('showborrowedlist',['truckid'=> $truckid]);
    }
    
    public function actionReservelist()
    {
        return $this->render('reservelist');
    }
    

    /**
     * Displays a single Fuelrequest model.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionView($id)
    {
        return $this->render('view', [
            'model' => $this->findModel($id),
        ]);
    }
    
    
    public function actionViewcar($truckId,$move,$date,$driver,$cont,$line,$size,$clie,$stat)
    {
      
        $model=new Movements();
        
        $model->movetypeId=$move;
        $model->driverId=$driver;
        $model->clientId=$clie;
        $model->size=$size;
        $model->shippingline=$line;
        $model->truckId=$truckId;
        $model->interchangedate=date('Y-m-d',strtotime($date));
        $model->containerno=trim(strtoupper($cont));
        $model->company=\Yii::$app->session->get('company');
        $model->registereddate=date('Y-m-d');
        $model->byy=\Yii::$app->user->getId();
        $model->fuelId=285;
        
        
        if ($stat==1){
            
            $dublicatecheck=Movements::checkDublicateMovement($model->movetypeId,strtolower($model->containerno),$model->interchangedate,$model->clientId);
            
            if ($dublicatecheck==null){
                if($model->save()){
                    \Yii::$app->session->setFlash('success','Successfull saved new movement');
                    return $this->redirect(['movements/create']);
                }
            }else {
                \Yii::$app->session->setFlash('error','Dublicate movement registered');
                return $this->redirect(['movements/update','id'=>$dublicatecheck->id]);
            }
        }
        return $this->render('viewcar', ['truckId'=>$truckId,'model'=>$model]);
    }

    /**
     * Creates a new Fuelrequest model.
     * If creation is successful, the browser will be redirected to the 'view' page.
     * @return mixed
     */
    public function actionCreate($id)
    {
        $model = new Fuelrequest();

        if ($model->load(Yii::$app->request->post())) {
        
            $model->fueldate=date('Y-m-d',strtotime($model->fueldate));
            $model->recorddate=date('Y-m-d');
            $model->truckId=$id; 
            $model->lastdistance=0;
            $model->byy= \Yii::$app->user->getId();
            
            if (Fuelrequest::checkDublicate($model->truckId,$model->fueldate,$model->volume)){
                if (Fuelrequest::countTruckActiveFuel($model->truckId)<5){
            
            if ($model->save()){
                \Yii::$app->session->setFlash('success','Successfull saved new fuel request');
                Fuelrequest::returnBorrowedFuel($id,$model->id,$model->volume);
                return $this->redirect(['create', 'id' => $id]);
            }
            
                }else{
                    \Yii::$app->session->setFlash('error','Too many active fuels to request another one');
                    return $this->redirect(['create', 'id' => $id]);
                }
            
            }else {
                \Yii::$app->session->setFlash('error','Dublicate request');
                return $this->redirect(['create', 'id' => $id]);
            }
           
           
        }

        return $this->render('create', [
            'model' => $model,'truckId'=>$id,
        ]);
    }
    
    
    public function actionCarselect()
    {
        $model = new Fuelrequest();
        
        if ($model->load(Yii::$app->request->post())) {
            return $this->redirect(['create','id'=>$_POST['Fuelrequest']['truckId']]);
        }
        
        return $this->render('carselect', [
            'model' => $model,
        ]);
    }

    /**
     * Updates an existing Fuelrequest model.
     * If update is successful, the browser will be redirected to the 'view' page.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionUpdate($id)
    {
        
        if (Yii::$app->user->can('Admin')){
            return $this->redirect(['updateadmin', 'id' => $id]);
        }else{
            $model = $this->findModel($id);
    
            if ($model->load(Yii::$app->request->post())) {
                $model->recorddate=date('Y-m-d');
                //$model->fueldate=date('Y-m-d',strtotime($model->fueldate));
                $model->byy= \Yii::$app->user->getId();
                
                if ($model->save()){
                \Yii::$app->session->setFlash('success','Successfull saved new fuel request');
                return $this->redirect(['create', 'id' => $model->truckId]);
                }
            }
    
            $model->fueldate=date('d-M-Y',strtotime($model->fueldate));
            return $this->render('update', [
                'model' => $model,
            ]);
        }
    }
    
    
    
    public function actionUpdateadmin($id)
    {
        $model = $this->findModel($id);
        $oldcar=$model->truckId;
        
        if ($model->load(Yii::$app->request->post())) {
            $model->recorddate=date('Y-m-d');
            $model->byy= \Yii::$app->user->getId();
            $model->fueldate=date('Y-m-d',strtotime($model->fueldate));
            
            if ($model->save()){
                
                
                
                if ($model->truckId != $oldcar){
                    $moves= Movements::find()->where(['fuelId'=>$id])->all();
                    if ($moves != null){
                        foreach ($moves as $move){
                            $move->truckId=$model->truckId;
                            $move->save();
                        }
                        
                    }
                    
                }
                
                \Yii::$app->session->setFlash('success','Successfull saved new fuel request');
                return $this->redirect(['create', 'id' => $model->truckId]);
            }
        }
        
        $model->fueldate=date('d-M-Y',strtotime($model->fueldate));
        return $this->render('updateadmin', [
            'model' => $model,
        ]);
    }

    /**
     * Deletes an existing Fuelrequest model.
     * If deletion is successful, the browser will be redirected to the 'index' page.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionDelete($id)
    {
        $moves= Movements::find()->where(['fuelId'=>$id])->all();
        if ($moves != null){
            foreach ($moves as $move){
                $move->fuelId=285;
                $move->save();
            }
            
        }
        
        $this->findModel($id)->delete();

        return $this->redirect(['index']);
    }

    /**
     * Finds the Fuelrequest model based on its primary key value.
     * If the model is not found, a 404 HTTP exception will be thrown.
     * @param integer $id
     * @return Fuelrequest the loaded model
     * @throws NotFoundHttpException if the model cannot be found
     */
    protected function findModel($id)
    {
        if (($model = Fuelrequest::findOne($id)) !== null) {
            return $model;
        }

        throw new NotFoundHttpException('The requested page does not exist.');
    }
    
    public function actionDeactivatefuel($id){
        $fuel=Fuelrequest::find()->where(['id'=>$id])->one();
        $fuel->status=0;
        if($fuel->save()){
        return $this->redirect(['create', 'id' => $fuel->truckId]);
        }else{
            return $this->redirect(['carselect']);
        }
    }
    
    public function actionTruckmovesfuelbytime(){
        
         $cnt=0;
         $fuelrecords=array();
         $model = new Fuelrequest();
         $ck=null;
        
        if (isset($_POST['Fuelrequest'])) {
            
            if($_POST['Fuelrequest']['to'] >= $_POST['Fuelrequest']['from']){
                $from=date('Y-m-d',strtotime($_POST['Fuelrequest']['from']));
                $to=date('Y-m-d',strtotime($_POST['Fuelrequest']['to']));
                $tId=$_POST['Fuelrequest']['truckId'];
                $ck=$tId;
         
        $movetypes=Movetype::find()->all();
        
        if ($movetypes != null){
            foreach ($movetypes as $movetype){
                
                $movements= Movements::find()
                ->where("interchangedate >= '$from' and interchangedate <= '$to' and truckId='$tId' and movetypeId='$movetype->id' and company=:c",[':c'=>\Yii::$app->session->get('company')])
                ->orderBy(['interchangedate'=>SORT_DESC])->all();
                
                $prevdate=null;
                $store=null;
                $trp=0;
                
                if ($movements !=null){
                    foreach ($movements as $movement){
                        if (($prevdate==null) and ($movement->movetype->triptype==2) and ($movement->size==2)){
                            $c=0;
                            $dayMoves= Movements::find()
                            ->where(['truckId'=>$tId,'movetypeId'=>$movetype->id,'size'=>2,'interchangedate'=>$movement->interchangedate])
                            ->all();
                            
                            if ($dayMoves!=null){
                                foreach ($dayMoves as $move){
                                    if (($move->interchangedate>= $from) and ($move->interchangedate<=$to))  $c=$c+1;
                                }
                            }
                            
                            $typeidcar= Cars::findOne($tId)->typeId;
                            $fuelrecords[$cnt]['movement']=$movetype->name;
                            $fuelrecords[$cnt]['date']=date('d-M-Y',strtotime($movement->interchangedate));
                            $fuelrecords[$cnt]['trips']=round($c/2);
                            $fuelrecords[$cnt]['containertype']='20ft';
                            $fuelrecords[$cnt]['fuelconsumed']=round($c/2) * Movefuelratio::getConsumedFuel($movetype->id,$typeidcar);
                            $cnt++;
                            $prevdate=$movement->interchangedate;
                            
                        }elseif (($prevdate!=$movement->interchangedate) and ($movement->movetype->triptype==2) and ($movement->size==2)){
                            $c=0;
                            $dayMoves= Movements::find()
                            ->where(['truckId'=>$tId,'movetypeId'=>$movetype->id,'size'=>2,'interchangedate'=>$movement->interchangedate])
                            ->all();
                            
                            if ($dayMoves!=null){
                                foreach ($dayMoves as $move){
                                    if (($move->interchangedate>= $from) and ($move->interchangedate<=$to))  $c=$c+1;
                                }
                            }
                            
                            $typeidcar= Cars::findOne($tId)->typeId;
                            $fuelrecords[$cnt]['movement']=$movetype->name;
                            $fuelrecords[$cnt]['date']=date('d-M-Y',strtotime($movement->interchangedate));
                            $fuelrecords[$cnt]['trips']=round($c/2);
                            $fuelrecords[$cnt]['containertype']='20ft';
                            $fuelrecords[$cnt]['fuelconsumed']=round($c/2) * Movefuelratio::getConsumedFuel($movetype->id,$typeidcar);
                            $cnt++;
                            $prevdate=$movement->interchangedate;
                            
                        }elseif ($movement->movetype->triptype!=2){
                            $fuelrecords[$cnt]['movement']=$movetype->name;
                            $fuelrecords[$cnt]['date']=date('d-M-Y',strtotime($movement->interchangedate));
                            $fuelrecords[$cnt]['trips']=1;
                            $fuelrecords[$cnt]['containertype']='40ft';
                            $fuelrecords[$cnt]['fuelconsumed']=1*Movefuelratio::getConsumedFuel($movetype->id,Cars::findOne($tId)->typeId);
                            $cnt++;
                        }elseif ($movement->movetype->triptype==2 and $movement->size!=2){
                            $fuelrecords[$cnt]['movement']=$movetype->name;
                            $fuelrecords[$cnt]['date']=date('d-M-Y',strtotime($movement->interchangedate));
                            $fuelrecords[$cnt]['trips']=1;
                            $fuelrecords[$cnt]['containertype']='40ft';
                            $fuelrecords[$cnt]['fuelconsumed']=1*Movefuelratio::getConsumedFuel($movetype->id,Cars::findOne($tId)->typeId);
                            $cnt++;
                        }
                    }
                }
            }
        }
        
         $offfuels= Offuels::find()
        ->where("date >= '$from' and date <= '$to' and truckId='$tId'")
        ->all();
        
        if ($offfuels != null){
            foreach ($offfuels as $off){
                $fuelrecords[$cnt]['movement']='Non operation';
                $fuelrecords[$cnt]['date']=date('d-M-Y',strtotime($off->date));;
                $fuelrecords[$cnt]['trips']=1;
                $fuelrecords[$cnt]['containertype']=$off->reasons;
                $fuelrecords[$cnt]['fuelconsumed']=$off->amount;
                $cnt++;
            }
        }
        
            }
        }
        
       return $this->render('truckmovesfuelbytime', [
            'model' => $model,'fuelrecords'=>$fuelrecords,'truck'=>$ck,
        ]);
    }
    
    public function actionReport()
    {
        $this->layout='main';
        $model = new Fuelrequest();
        
        if (isset($_POST['Fuelrequest'])) {
            
            if($_POST['Fuelrequest']['to'] >= $_POST['Fuelrequest']['from']){
                $f=date('Y-m-d',strtotime($_POST['Fuelrequest']['from']));
                $t=date('Y-m-d',strtotime($_POST['Fuelrequest']['to']));
                $trucks=Cars::find()->where(['typeId' =>Cartype::getHorsesId(),'status'=>1,'company'=>\Yii::$app->session->get('company')])-> all();
                $fuelaverage=array();
                $fuelrecords=array();
                $summary=array();
                $cnt=0;
                $totalfilled=0;
                $totaltrips=0;
                $totalcost=0;
                $totalonhand=0;
                
                if ($trucks != null){
                    foreach ($trucks as $truck){
                        $fuelrecords[$cnt]['car']=$truck->plateno;
                        $fuelrecords[$cnt]['twenty']=Movements::carAmountOfLoadBySizeTime($truck->plateno,$f,$t,2);
                        $fuelrecords[$cnt]['forty']=Movements::carAmountOfLoadBySizeTime($truck->plateno,$f,$t,4);
                        $fuelrecords[$cnt]['other']=Movements::carAmountOfLoadBySizeTime($truck->plateno,$f,$t,0);
                        $fuelrecords[$cnt]['trips']=Movements::carMovementsByTime($truck->plateno,$f,$t);
                        $fuelrecords[$cnt]['volume']=Fuelrequest::getTruckFueledAmountByTime($truck->plateno,$f,$t);
                        $fuelrecords[$cnt]['spent']=Fuelrequest::getTruckConsumedfuelByTime($truck->plateno,$f,$t)['consumed'];
                        $fuelrecords[$cnt]['onhand']=$fuelrecords[$cnt]['volume'] - $fuelrecords[$cnt]['spent'];
                        $fuelrecords[$cnt]['ld']= Fuelrequest::getTruckLastFueledDateWithCondition($truck->plateno,$f,$t);
                        //$fuelrecords[$cnt]['cost']=Fuelrequest::getTruckConsumedfuelByTimeCost($truck->plateno,$f,$t);
                        
                        $fuelaverage[$cnt]['av']=Fuelrequest::getTruckConsumedfuelByTime($truck->plateno,$f,$t);
                       
                        
                        $totalfilled=$totalfilled+$fuelrecords[$cnt]['volume'];
                        $totaltrips=$totaltrips+ $fuelrecords[$cnt]['trips'];
                        //$totalcost=$totalcost+$fuelrecords[$cnt]['cost'];
                        $totalonhand=$totalonhand + $fuelrecords[$cnt]['onhand'];
                        
                        $cnt++;
                        
                    }
                    
                    if ($fuelaverage !=null and $fuelrecords != null) array_multisort($fuelaverage,SORT_DESC,$fuelrecords);
                    $summary['trucks']=count($trucks); $summary['totalfilled']=$totalfilled; $summary['totaltrips']=$totaltrips; 
                    $summary['onhand']=$totalonhand;
                    //$summary['totalcost']=$totalcost;
                }
                
                $data = $this->renderPartial('_reportview',['datas'=>$fuelrecords,'from'=>$_POST['Fuelrequest']['from'],'to'=>$_POST['Fuelrequest']['to'],'summary'=>$summary]);
                
                $pdf = new Pdf([
                    'mode' => Pdf::MODE_CORE,
                    'format' => Pdf::FORMAT_A4,
                    'orientation' => Pdf::ORIENT_PORTRAIT,
                    'destination' => Pdf::DEST_BROWSER,
                    'content' => $data,
                    'cssFile' => '@vendor/kartik-v/yii2-mpdf/src/assets/kv-mpdf-bootstrap.min.css',
                    'cssInline' => '.kv-heading-1{font-size:18px}',
                    'options' => ['title' => 'Fuel report'],
                    'methods' => [
                        'SetFooter'=>['{PAGENO}'],
                    ]
                ]);
                
                return $pdf->render();
                
            }else{
                \Yii::$app->session->setFlash('error','From can not be greater than to');
            }
        }
        
        return $this->render('report', [
            'model' => $model,
        ]);
    }
    
    
    public function actionReportbill()
    {
        $this->layout='main';
        $model = new Fuelrequest();
        
        if (isset($_POST['Fuelrequest'])) {
            
            if($_POST['Fuelrequest']['to'] >= $_POST['Fuelrequest']['from']){
                $f=date('Y-m-d',strtotime($_POST['Fuelrequest']['from']));
                $t=date('Y-m-d',strtotime($_POST['Fuelrequest']['to']));
                $trucks=Cars::find()->where(['typeId' =>Cartype::getHorsesId(),'status'=>1,'company'=>\Yii::$app->session->get('company')])-> all();
                $fuelaverage=array();
                $fuelrecords=array();
                $summary=array();
                $cnt=0;
                $totalfilled=0;
                $totaltrips=0;
                $totalcost=0;
                
                if ($trucks != null){
                    foreach ($trucks as $truck){
                        $fuelrecords[$cnt]['car']=$truck->plateno;
                        $fuelrecords[$cnt]['volumefilled']=Fuelrequest::getTruckFueledAmountByTime($truck->plateno,$f,$t);
                        $fuelrecords[$cnt]['cost']=Fuelrequest::getTruckFueledAmountByTimeCost($truck->plateno,$f,$t);
                        $fuelaverage[$cnt]['av']=$fuelrecords[$cnt]['cost'];
                        
                        
                        $totalfilled=$totalfilled+$fuelrecords[$cnt]['volumefilled'];
                        $totalcost=$totalcost+$fuelrecords[$cnt]['cost'];
                        
                        $cnt++;
                        
                    }
                    
                    if ($fuelaverage !=null and $fuelrecords != null) array_multisort($fuelaverage,SORT_DESC,$fuelrecords);
                    $summary['trucks']=count($trucks); $summary['totalfilled']=$totalfilled; $summary['totalcost']=$totalcost;
                }
                
                $data = $this->renderPartial('_reportbillview',['datas'=>$fuelrecords,'from'=>$_POST['Fuelrequest']['from'],'to'=>$_POST['Fuelrequest']['to'],'summary'=>$summary]);
                
                $pdf = new Pdf([
                    'mode' => Pdf::MODE_CORE,
                    'format' => Pdf::FORMAT_A4,
                    'orientation' => Pdf::ORIENT_PORTRAIT,
                    'destination' => Pdf::DEST_BROWSER,
                    'content' => $data,
                    'cssFile' => '@vendor/kartik-v/yii2-mpdf/src/assets/kv-mpdf-bootstrap.min.css',
                    'cssInline' => '.kv-heading-1{font-size:18px}',
                    'options' => ['title' => 'Fuel report'],
                    'methods' => [
                        'SetFooter'=>['{PAGENO}'],
                    ]
                ]);
                
                return $pdf->render();
                
            }else{
                \Yii::$app->session->setFlash('error','From can not be greater than to');
            }
        }
        
        return $this->render('reportbill', [
            'model' => $model,
        ]);
    }
}
