<?php

namespace app\controllers;

use Yii;
use app\models\Fromclients;
use app\models\FromclientsSearch;
use yii\web\Controller;
use yii\web\NotFoundHttpException;
use yii\filters\VerbFilter;
use yii\web\UploadedFile;

/**
 * FromclientsController implements the CRUD actions for Fromclients model.
 */
class FromclientsController extends Controller
{
    /**
     * {@inheritdoc}
     */
    public function behaviors()
    {
        return [
            'verbs' => [
                'class' => VerbFilter::className(),
                'actions' => [
                    'delete' => ['POST'],
                ],
            ],
        ];
    }

    /**
     * Lists all Fromclients models.
     * @return mixed
     */
    public function actionIndex()
    {
        $searchModel = new FromclientsSearch();
        $dataProvider = $searchModel->search(Yii::$app->request->queryParams);

        return $this->render('index', [
            'searchModel' => $searchModel,
            'dataProvider' => $dataProvider,
        ]);
    }

    /**
     * Displays a single Fromclients model.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionView($id)
    {
        return $this->render('view', [
            'model' => $this->findModel($id),
        ]);
    }

    /**
     * Creates a new Fromclients model.
     * If creation is successful, the browser will be redirected to the 'view' page.
     * @return mixed
     */
    public function actionCreate()
    {
        $model = new Fromclients();

        if ($model->load(Yii::$app->request->post())) {
            
            $filenm='fromclient';
            $model->upexl= UploadedFile::getInstance($model,'upexl');
            
            if($model->upexl->saveAs('uploads/'.$filenm.'.'.$model->upexl->extension)){
            
            $fileName= 'uploads/'.$filenm.'.'.$model->upexl->extension;
            
            $datas = \moonland\phpexcel\Excel::widget([
                'mode' => 'import',
                'fileName' => $fileName,
                'setFirstRecordAsKeys' => true, // if you want to set the keys of record column with first record, if it not set, the header with use the alphabet column on excel.
                'setIndexSheetByName' => true, // set this if your excel data with multiple worksheet, the index of array will be set with the sheet name. If this not set, the index will use numeric.
                'getOnlySheet' => 'sheet1', // you can set this property if you want to get the specified sheet from the excel data with multiple worksheet.
            ]);
            
            $cnt=0;
            
            for($i=0; $i<count($datas); $i++){
                
                    $modelsave = new Fromclients();
                    $modelsave->contno= $datas[$i]['container'];
                    $modelsave->truckno=substr($datas[$i]['truck'],0,7);
                    $modelsave->upexl='kaks';
                    $modelsave->date=date('Y-m-d');
                    
                    $check=Fromclients::find()->where(['contno'=>$modelsave->contno,'truckno'=>$modelsave->truckno])->all();
                    
                    if($check == null){ 
                        if($modelsave->save()){
                            $cnt++;
                       }    
                    }else{
                       $cnt++; 
                    }
                }
                \Yii::$app->session->setFlash('success','Successfull saved excell records '.$cnt.' of '.count($datas));
                return $this->redirect(['index']);
            }else{
                \Yii::$app->session->setFlash('error','Could not read excell file');
            }
        }

        return $this->render('create', [
            'model' => $model,
        ]);
    }

    /**
     * Updates an existing Fromclients model.
     * If update is successful, the browser will be redirected to the 'view' page.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionUpdate($id)
    {
        $model = $this->findModel($id);

        if ($model->load(Yii::$app->request->post()) && $model->save()) {
            return $this->redirect(['view', 'id' => $model->id]);
        }

        return $this->render('update', [
            'model' => $model,
        ]);
    }

    /**
     * Deletes an existing Fromclients model.
     * If deletion is successful, the browser will be redirected to the 'index' page.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionDelete($id)
    {
        $this->findModel($id)->delete();

        return $this->redirect(['index']);
    }

    /**
     * Finds the Fromclients model based on its primary key value.
     * If the model is not found, a 404 HTTP exception will be thrown.
     * @param integer $id
     * @return Fromclients the loaded model
     * @throws NotFoundHttpException if the model cannot be found
     */
    protected function findModel($id)
    {
        if (($model = Fromclients::findOne($id)) !== null) {
            return $model;
        }

        throw new NotFoundHttpException('The requested page does not exist.');
    }
}
