<?php

namespace app\controllers;

use Yii;
use app\models\Docsupload;
use app\models\DocsuploadSearch;
use yii\web\Controller;
use yii\web\NotFoundHttpException;
use yii\filters\VerbFilter;
use yii\web\UploadedFile;
/**
 * DocsuploadController implements the CRUD actions for Docsupload model.
 */
class DocsuploadController extends Controller
{
    public function init() {
        
        if (\Yii::$app->session->get('layout') != null){
            $this->layout = \Yii::$app->session->get('layout');
        }else{
            $this->layout = 'cnf';
        }
    }
    
    /**
     * {@inheritdoc}
     */
    public function behaviors()
    {
        return [
            'verbs' => [
                'class' => VerbFilter::className(),
                'actions' => [
                    'delete' => ['POST'],
                ],
            ],
        ];
    }

    /**
     * Lists all Docsupload models.
     * @return mixed
     */
    public function actionIndex($id)
    {
        
        \Yii::$app->session->set('fileId', $id);
        $searchModel = new DocsuploadSearch();
        $dataProvider = $searchModel->search(Yii::$app->request->queryParams);

        return $this->render('index', [
            'searchModel' => $searchModel,
            'dataProvider' => $dataProvider,
        ]);
    }

    /**
     * Displays a single Docsupload model.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionView($id)
    {
        return $this->render('view', [
            'model' => $this->findModel($id),
        ]);
    }

    /**
     * Creates a new Docsupload model.
     * If creation is successful, the browser will be redirected to the 'view' page.
     * @return mixed
     */
    public function actionCreate($id)
    {
        $model = new Docsupload();

        if ($model->load(Yii::$app->request->post())) {
           
            $model->file=UploadedFile::getInstance($model,'file');  
            $model->file->saveAs('uploads/' . $model->file->baseName . '.' . $model->file->extension);
            
            $model->name=$model->file->baseName.'.'.$model->file->extension;
            $model->docsId=$id;
            $model->fileId=\Yii::$app->session->get('fileId');
            $model->reqdate=date('Y-m-d',strtotime($model->reqdate));
            $model->recdate=date('Y-m-d',strtotime($model->recdate));
            $model->onn=date('Y-m-d');
            $model->byy=\Yii::$app->user->getId();
           
            if ($model->save()){
                return $this->redirect(['index', 'id' =>\Yii::$app->session->get('fileId')]);
            }
        }

        return $this->render('create', [
            'model' => $model,
        ]);
    }

    /**
     * Updates an existing Docsupload model.
     * If update is successful, the browser will be redirected to the 'view' page.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionUpdate($id)
    {
        $model = $this->findModel($id);

        if ($model->load(Yii::$app->request->post()) && $model->save()) {
            return $this->redirect(['view', 'id' => $model->id]);
        }

        return $this->render('update', [
            'model' => $model,
        ]);
    }

    /**
     * Deletes an existing Docsupload model.
     * If deletion is successful, the browser will be redirected to the 'index' page.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionDelete($id)
    {
        $this->findModel($id)->delete();

        return $this->redirect(['index']);
    }

    /**
     * Finds the Docsupload model based on its primary key value.
     * If the model is not found, a 404 HTTP exception will be thrown.
     * @param integer $id
     * @return Docsupload the loaded model
     * @throws NotFoundHttpException if the model cannot be found
     */
    protected function findModel($id)
    {
        if (($model = Docsupload::findOne($id)) !== null) {
            return $model;
        }

        throw new NotFoundHttpException('The requested page does not exist.');
    }
}
