<?php

namespace app\controllers;

use Yii;
use app\models\Cardrivers;
use app\models\Cars;
use app\models\Cartype;
use app\models\Defectivetrucks;
use app\models\DefectivetrucksSearch;
use app\models\Uzers;
use yii\web\Controller;
use yii\web\NotFoundHttpException;
use yii\filters\VerbFilter;
use kartik\mpdf\Pdf;
use yii2tech\spreadsheet\Spreadsheet;
use yii\data\ArrayDataProvider;

/**
 * DefectivetrucksController implements the CRUD actions for Defectivetrucks model.
 */
class DefectivetrucksController extends Controller
{
    public function init() {
        
        if (\Yii::$app->session->get('layout') != null){
            $this->layout = \Yii::$app->session->get('layout');
        }else{
            $this->layout = 'workshop';
        }
        
    }
    /**
     * {@inheritdoc}
     */
    public function behaviors()
    {
        return [
            'verbs' => [
                'class' => VerbFilter::className(),
                'actions' => [
                    'delete' => ['POST'],
                ],
            ],
        ];
    }

    /**
     * Lists all Defectivetrucks models.
     * @return mixed
     */
    public function actionIndex()
    {
        $searchModel = new DefectivetrucksSearch();
        $dataProvider = $searchModel->search(Yii::$app->request->queryParams);

        return $this->render('index', [
            'searchModel' => $searchModel,
            'dataProvider' => $dataProvider,
        ]);
    }

    /**
     * Displays a single Defectivetrucks model.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionView($id)
    {
        return $this->render('view', [
            'model' => $this->findModel($id),'id'=>$id,
        ]);
    }

    /**
     * Creates a new Defectivetrucks model.
     * If creation is successful, the browser will be redirected to the 'view' page.
     * @return mixed
     */
    public function actionCreate()
    {
        $model = new Defectivetrucks();
        $cardriver= new Cardrivers();
        $uzers= new Uzers();

        if ($model->load(Yii::$app->request->post()) && $uzers->load(Yii::$app->request->post()) && $cardriver->load(Yii::$app->request->post())) {
            $model->indate=date('Y-m-d',strtotime($model->indate));
            $model->outdate='0000-00-00';
            $model->expected=date('Y-m-d');
            $model->company=\Yii::$app->session->get('company');
            
            $cardriver->dateassigned=date('Y-m-d');
            $cardriver->status=1;
            $cardriver->carId=$model->carId;
            
            $valid=$model->validate();
            $valid=$valid && $cardriver->validate();
             
        if (Defectivetrucks::checkCarDublicate($model->carId)==null){
            if($valid){
                
                //Cardrivers::deactivateActiveDriver($model->carId,$cardriver->userId);
                //$cardriver->save();
                
                $model->save();
                
                \Yii::$app->session->setFlash('success','Successfull saved new defected car');
                
                $updateuzer = Uzers::findOne($cardriver->userId);
                $updateuzer->mobilephone=$uzers->mobilephone;
                
                if($updateuzer->save()){
                return $this->redirect(['index']);
                }
            }else{
                 \Yii::$app->session->setFlash('error','Failed validation of Car driver & Defective car'.$cardriver->userId);
            } 
                 }else {
                     \Yii::$app->session->setFlash('error','This car is still in the list of defective cars');
                     return $this->redirect(['index']);
                 }
            
        }
        
        if (\Yii::$app->request->isAjax){
            return $this->renderAjax('create', [
                'model' => $model,'cardriver'=>$cardriver, 'uzers'=>$uzers,
            ]);
        }else{
            return $this->render('create', [
                'model' => $model,'cardriver'=>$cardriver, 'uzers'=>$uzers,
            ]);
        }
    }
    
    public function actionRelease($id)
    {
        $model = Defectivetrucks::findOne($id);
        
        
        if ($model->load(Yii::$app->request->post())) {
            $model->outdate=date('Y-m-d',strtotime($model->outdate));
            
                if($model->save()){
                    \Yii::$app->session->setFlash('success','Successfull gatedout defected car');
                    return $this->redirect(['index']);
                }else{
                
                 \Yii::$app->session->setFlash('error','Was not saved - '.$model->indate);
                }
            
        }
        
        $model->outdate=null;
        
        if (\Yii::$app->request->isAjax){
            return $this->renderAjax('release', [
                'model' => $model,
            ]);
        }else{
            return $this->render('release', [
                'model' => $model,
            ]);
        }
    }
    
    
    
    public function actionCompleted($id)
    {
        $model = Defectivetrucks::findOne($id);
        
        $model->status=2;
            
            if($model->save()){
                return $this->redirect(['view','id'=>$id]);
            }
            
    }
    
    
        
    public function actionChangestatus($id,$status)
    {
        $model = Defectivetrucks::findOne($id);
        
        $model->status=$status;
        
        if($model->save()){
            return $this->redirect(['view','id'=>$id]);
        }
        
    }
    

    /**
     * Updates an existing Defectivetrucks model.
     * If update is successful, the browser will be redirected to the 'view' page.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionUpdate($id)
    {
        $model = $this->findModel($id);
        $model->indate=date('d-M-Y',strtotime($model->indate));
        if ($model->expected=='0000-00-00') { $model->expected=null; }else{
            $model->expected=date('d-M-Y',strtotime($model->expected));
        }

        if ($model->load(Yii::$app->request->post())) {
            $model->indate=date('Y-m-d',strtotime($model->indate));
            $model->expected=date('Y-m-d',strtotime($model->expected));
            
            if ($model->save()){
            return $this->redirect(['view','id'=>$id]);
            }
        }

        return $this->render('update', [
            'model' => $model,
        ]);
    }

    /**
     * Deletes an existing Defectivetrucks model.
     * If deletion is successful, the browser will be redirected to the 'index' page.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionDelete($id)
    {
        $this->findModel($id)->delete();

        return $this->redirect(['index']);
    }

    /**
     * Finds the Defectivetrucks model based on its primary key value.
     * If the model is not found, a 404 HTTP exception will be thrown.
     * @param integer $id
     * @return Defectivetrucks the loaded model
     * @throws NotFoundHttpException if the model cannot be found
     */
    protected function findModel($id)
    {
        if (($model = Defectivetrucks::findOne($id)) !== null) {
            return $model;
        }

        throw new NotFoundHttpException('The requested page does not exist.');
    }
    
    public function actionPrintrelease($id){
    
        $data = $this->renderPartial('_releaseview',['dif'=>$id]);
        
        $pdf = new Pdf([
            'mode' => Pdf::MODE_CORE,
            'format' => Pdf::FORMAT_A4,
            'orientation' => Pdf::ORIENT_PORTRAIT,
            'destination' => Pdf::DEST_BROWSER,
            'content' => $data,
            'cssFile' => '@vendor/kartik-v/yii2-mpdf/src/assets/kv-mpdf-bootstrap.min.css',
            'cssInline' => '.kv-heading-1{font-size:18px}',
            'options' => ['title' => 'Bills request'],
            'methods' => [
                'SetHeader'=>[''],
                'SetFooter'=>['{PAGENO}'],
            ]
        ]);
        
        return $pdf->render();
        
    }
    
    
    public function actionPrintjobcard($id){
        
        $data = $this->renderPartial('_jobcardview',['dif'=>$id]);
        
        $pdf = new Pdf([
            'mode' => Pdf::MODE_CORE,
            'format' => Pdf::FORMAT_A4,
            'orientation' => Pdf::ORIENT_PORTRAIT,
            'destination' => Pdf::DEST_BROWSER,
            'content' => $data,
            'cssFile' => '@vendor/kartik-v/yii2-mpdf/src/assets/kv-mpdf-bootstrap.min.css',
            'cssInline' => '.kv-heading-1{font-size:18px}',
            'options' => ['title' => 'Bills request'],
            'methods' => [
                'SetHeader'=>[''],
                'SetFooter'=>['{PAGENO}'],
            ]
        ]);
        
        return $pdf->render();
        
    }
    
    
    public function actionPrintreportwithrfq(){
        
        
        $data = $this->renderPartial('_reportwithrfqview');
        
        $pdf = new Pdf([
            'mode' => Pdf::MODE_CORE,
            'format' => Pdf::FORMAT_A4,
            'orientation' => Pdf::ORIENT_PORTRAIT,
            'destination' => Pdf::DEST_BROWSER,
            'content' => $data,
            'cssFile' => '@vendor/kartik-v/yii2-mpdf/src/assets/kv-mpdf-bootstrap.min.css',
            'cssInline' => '.kv-heading-1{font-size:18px}',
            'options' => ['title' => 'Bills request'],
            'methods' => [
                'SetHeader'=>[''],
                'SetFooter'=>['{PAGENO}'],
            ]
        ]);
        
        return $pdf->render();
        
    }
    
    public function actionStatusreport()
    {

                $trucks=Cars::find()->where(['typeId' =>Cartype::getHorsesId(),'status'=>1,'company'=>\Yii::$app->session->get('company')])->orderBy(['typeId'=>SORT_DESC])->all();
                $defectivetrucks=array();
                $goodtrucks=array();
                $reasons=array();
                $average=array();
                $cnt=0;
                $c=0;
                
                if ($trucks != null){
                    foreach ($trucks as $truck){
                        $check= Defectivetrucks::checkCarDublicate($truck->plateno);
                        $ddd=Cardrivers::getTruckmaindriver($truck->plateno);
                        $d=$ddd==null?$ddd:Uzers::findOne($ddd);
                        if ($check==null){
                           
                            $goodtrucks[$cnt]['truck']=$truck->plateno;
                            $goodtrucks[$cnt]['type']=$truck->type->name;
                            $goodtrucks[$cnt]['driver']=$d==null?'No driver': $d->id.' - '.$d->fullName.' ('.$d->mobilephone.')';
                            $goodtrucks[$cnt]['status']='Good';
                            $cnt++;
                        }else{
                            $defectivetrucks[$c]['truck']=$truck->plateno;
                            $defectivetrucks[$c]['type']=$truck->type->name;
                            $defectivetrucks[$c]['driver']=$d==null?'No driver': $d->fullName.' ('.$d->mobilephone.')';
                            foreach ($check as $ck){
                                $defectivetrucks[$c]['date']=date('Y-m-d',strtotime($ck->indate));
                                $defectivetrucks[$c]['reason']=$ck->reason;
                                $average[$c]['val']=$ck->status;
                                $defectivetrucks[$c]['status']=Defectivetrucks::getStatusValue($ck->status);
                            }
                            
                            $c++;
                        }
                        array_multisort($average,SORT_DESC,$defectivetrucks);
                    } 
                 }
                 
                 $allcars=array(); 
                 $cc=0;
                /* if (count($goodtrucks)>0){
                     for($i=0; $i<count($goodtrucks); $i++){
                         $allcars[$cc]['truck']=$goodtrucks[$i]['truck'];
                         $allcars[$cc]['type']=$goodtrucks[$i]['type'];
                         $allcars[$cc]['driver']=$goodtrucks[$i]['driver'];
                         $allcars[$cc]['status']=$goodtrucks[$i]['status'];
                         $allcars[$cc]['idle days']=0;
                         $cc++;
                     }
                 }  */
                 
                 if (count($defectivetrucks) >0){
                     for ($j=0; $j<count($defectivetrucks); $j++){
                         $allcars[$cc]['truck']=$defectivetrucks[$j]['truck'];
                         $allcars[$cc]['type']=$defectivetrucks[$j]['type'];
                         $allcars[$cc]['driver']=$defectivetrucks[$j]['driver'];
                         $allcars[$cc]['status']=$defectivetrucks[$j]['status'];
                         $allcars[$cc]['in date']=date('d-m-Y',strtotime($defectivetrucks[$j]['date']));
                         $allcars[$cc]['idle days']=Uzers::getIdleDays($defectivetrucks[$j]['date']);
                         $allcars[$cc]['workscope']=$defectivetrucks[$j]['reason'];
                         
                         
                         $cc++;
                     }
                     
                 }
                
                 
                 $exporter = new Spreadsheet([
                     'dataProvider' => new ArrayDataProvider([
                         'allModels' =>$allcars
                     ]),
                     
                     'columns' => [
                         [
                             'attribute' => 'truck',
                             'contentOptions' => [
                                 'width' => [
                                     '55px'
                                 ],
                             ],
                         ],
                         [
                             'attribute' => 'type',
                         ],
                         [
                             'attribute' => 'status',
                         ],
                         [
                             'attribute' => 'driver',
                         ],
                          [
                             'attribute' => 'in date',
                         ],
                         [
                             'attribute' => 'workscope',
                         ],
                     ],
                 ]);
                 
                 return $exporter->send('workshop status.xls');
                 
                 /*
                 $data = $this->renderPartial('_statusreportview',['defectivetrucks'=>$defectivetrucks,'goodtrucks'=>$goodtrucks]);
                 
                 $pdf = new Pdf([
                     'mode' => Pdf::MODE_CORE,
                     'format' => Pdf::FORMAT_A4,
                     'orientation' => Pdf::ORIENT_PORTRAIT,
                     'destination' => Pdf::DEST_BROWSER,
                     'content' => $data,
                     'cssFile' => '@vendor/kartik-v/yii2-mpdf/src/assets/kv-mpdf-bootstrap.min.css',
                     'cssInline' => '.kv-heading-1{font-size:18px}',
                     'options' => ['title' => 'Workshop status report'],
                     'methods' => [
                         'SetFooter'=>['{PAGENO}'],
                     ]
                 ]);
                 
                 return $pdf->render();
                 */
        
    }
    
    
    
        public function actionFrequency()
    {
        
        $model = new Defectivetrucks();
        
        if (isset($_POST['Defectivetrucks'])) {
            $from=date('Y-m-d',strtotime($_POST['Defectivetrucks']['from']));
            $to=date('Y-m-d',strtotime($_POST['Defectivetrucks']['to']));
           
       
                $trucks=Cars::find()->where(['typeId' =>Cartype::getHorsesId(),'status'=>1,'company'=>\Yii::$app->session->get('company')])->orderBy(['typeId'=>SORT_DESC])->all();
                $defectivetrucks=array();
                $average=array();
                $c=0;
                
                if ($trucks != null){
                    foreach ($trucks as $truck){
                        $check= Defectivetrucks::checkCarDublicate($truck->plateno);
                         $defectivetrucks[$c]['truck']=$truck->plateno;
                         $defectivetrucks[$c]['type']=$truck->type->name;
                         $defectivetrucks[$c]['freq']=count(Defectivetrucks::find()->where("indate >= '$from' and indate <= '$to' and carId='$truck->plateno'")->all());
                         $defectivetrucks[$c]['from']=$from;
                         $defectivetrucks[$c]['to']=$to;
                         $average[$c]['val']=$ck->status;
                         $c++;
                        array_multisort($average,SORT_DESC,$defectivetrucks);
                    } 
                 }
                
               
                 $exporter = new Spreadsheet([
                     'dataProvider' => new ArrayDataProvider([
                         'allModels' =>$defectivetrucks
                     ]),
                     
                     'columns' => [
                         [
                             'attribute' => 'truck',
                             'contentOptions' => [
                                 'width' => [
                                     '55px'
                                 ],
                             ],
                         ],
                         [
                             'attribute' => 'type',
                         ],
                         [
                             'attribute' => 'freq',
                         ],
                         [
                             'attribute' => 'from',
                         ],
                         [
                             'attribute' => 'to',
                         ],
                     ],
                 ]);
                 
                 return $exporter->send('workshop freq.xls');
        }         
                 
     return $this->render('frequency', ['model' => $model]);
        
    }
}