<?php

namespace app\controllers;

use Yii;
use app\models\Cfile;
use app\models\CfileSearch;
use yii\web\Controller;
use yii\web\NotFoundHttpException;
use yii\filters\VerbFilter;

/**
 * CfileController implements the CRUD actions for Cfile model.
 */
class CfileController extends Controller
{
    
    public function init() {
        
        if (\Yii::$app->session->get('layout') != null){
            $this->layout = \Yii::$app->session->get('layout');
        }else{
            $this->layout = 'cnf';
        }
       
    }
    
    /**
     * {@inheritdoc}
     */
    public function behaviors()
    {
        return [
            'verbs' => [
                'class' => VerbFilter::className(),
                'actions' => [
                    'delete' => ['POST'],
                ],
            ],
        ];
    }

    /**
     * Lists all Cfile models.
     * @return mixed
     */
    public function actionIndex()
    {
        \Yii::$app->session->set('fileId', null);
        $this->layout='main'; 
        
        $searchModel = new CfileSearch();
        $dataProvider = $searchModel->search(Yii::$app->request->queryParams);

        return $this->render('index', [
            'searchModel' => $searchModel,
            'dataProvider' => $dataProvider,
        ]);
    }

    /**
     * Displays a single Cfile model.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionView($id)
    {
        return $this->render('view', [
            'model' => $this->findModel($id),
        ]);
    }

    /**
     * Creates a new Cfile model.
     * If creation is successful, the browser will be redirected to the 'view' page.
     * @return mixed
     */
    
    public function actionPrecreate()
    {
        $this->layout='main';
        $model = new Cfile();
        
        if ($model->load(Yii::$app->request->post())) {
            $ftype=$model->ftype;
                    return $this->redirect(['create','ftype'=>$ftype]);
        }
        
        return $this->render('precreate', [
            'model' => $model,
        ]);
    }
    
    
    
    
    
    public function actionCreate($ftype)
    {
        $this->layout='main'; 
        $model = new Cfile();

        if ($model->load(Yii::$app->request->post())) {
            $model->byy=\Yii::$app->user->getId();
            $model->onn=date('Y-m-d');
            $model->eta=date('Y-m-d',strtotime($model->eta));
            $model->company=\Yii::$app->session->get('company');
            $model->ftype=$ftype;
            $dublicate=Cfile::checkDublicate($model->blnumber);
            if ($dublicate==null){
                if($model->save()){
                    \Yii::$app->session->setFlash('success','New file created successfull');
                return $this->redirect(['docsupload/index','id'=>$model->id]);
                }
            }else {
                \Yii::$app->session->setFlash('error','Tried to add dublicate file');
                return $this->redirect(['update', 'id' => $dublicate->id]);
            }
        }

                if (\Yii::$app->request->isAjax){
            return $this->renderAjax('create', [
                'model' => $model,'ftype'=>$ftype,
            ]);
        }else{
            return $this->render('create', [
                'model' => $model,'ftype'=>$ftype,
            ]);
        }
    }

    /**
     * Updates an existing Cfile model.
     * If update is successful, the browser will be redirected to the 'view' page.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionUpdate($id)
    {
        $model = $this->findModel($id);

        if ($model->load(Yii::$app->request->post())) {
            
            $model->eta=date('Y-m-d',strtotime($model->eta));
            
            if ($model->save()){
                \Yii::$app->session->setFlash('success','File successfull edited');
            return $this->redirect(['docsupload/index','id'=>$id]);
            }
        }

        return $this->render('update', [
            'model' => $model,
        ]);
    }

    /**
     * Deletes an existing Cfile model.
     * If deletion is successful, the browser will be redirected to the 'index' page.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionDelete($id)
    {
        $this->findModel($id)->delete();

        return $this->redirect(['index']);
    }

    /**
     * Finds the Cfile model based on its primary key value.
     * If the model is not found, a 404 HTTP exception will be thrown.
     * @param integer $id
     * @return Cfile the loaded model
     * @throws NotFoundHttpException if the model cannot be found
     */
    protected function findModel($id)
    {
        if (($model = Cfile::findOne($id)) !== null) {
            return $model;
        }

        throw new NotFoundHttpException('The requested page does not exist.');
    }
    
    
     public function actionUpdateatb($id)
    {
        $model = $this->findModel($id);
        
        if ($model->load(Yii::$app->request->post())) {
            
            $model->atb=date('Y-m-d',strtotime($model->atb));
            
            if ($model->save()){
                \Yii::$app->session->setFlash('success','File successfull edited');
            return $this->redirect(['docsupload/index','id'=>$id]);
            }
        }
        
        return $this->render('atb', [
            'model' => $model,
        ]);
    }

    
    
}
