<?php

namespace app\controllers;

use Yii;
use kartik\mpdf\Pdf;
use Behat\Gherkin\Exception\Exception;
use GuzzleHttp\Psr7\Response;
use app\models\Cars;
use app\models\CarsSearch;
use app\models\Trucks;
use yii\web\Controller;
use yii\web\NotFoundHttpException;
use yii\filters\VerbFilter;
use yii\helpers\ArrayHelper;
use app\models\Cartype;
use app\models\Model;
use yii\bootstrap\ActiveForm;
use yii2tech\spreadsheet\Spreadsheet;
use yii\data\ArrayDataProvider;
use app\models\Defectivetrucks;
use app\models\Bills;

/**
 * CarsController implements the CRUD actions for Cars model.
 */
class CarsController extends Controller
{
    
    public function init() {
        
        if (\Yii::$app->session->get('layout') != null){
            $this->layout = \Yii::$app->session->get('layout');
        }else{
            $this->layout ='main';
        }
        
    }
    
    /**
     * {@inheritdoc}
     */
    public function behaviors()
    {
        return [
            'verbs' => [
                'class' => VerbFilter::className(),
                'actions' => [
                    'delete' => ['POST'],
                ],
            ],
        ];
    }

    /**
     * Lists all Cars models.
     * @return mixed
     */
    public function actionIndex()
    {
        $searchModel = new CarsSearch();
        $dataProvider = $searchModel->search(Yii::$app->request->queryParams);
        //$dataProvider->query->andWhere('typeId='.$id);

        return $this->render('index', [
            'searchModel' => $searchModel,
            'dataProvider' => $dataProvider,
        ]);
    }

    /**
     * Displays a single Cars model.
     * @param string $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionView($id)
    {
        return $this->render('view', [
            'model' => $this->findModel($id),
        ]);
    }

    /**
     * Creates a new Cars model.
     * If creation is successful, the browser will be redirected to the 'view' page.
     * @return mixed
     */
    public function actionCreate()
    {
        $model = new Cars();

        if ($model->load(Yii::$app->request->post())) {
            
            $model->datepurchased=date('Y-m-d',strtotime($model->datepurchased));
            $model->plateno=trim($model->plateno);
            $model->company=\Yii::$app->session->get('company');
            
            if ($model->save()){
                \Yii::$app->session->setFlash('success','Successfull save new car');
                return $this->redirect(['view', 'id' => $model->plateno]);
            }
        }

        return $this->render('create', [
            'model' => $model,
        ]);
    }

    /**
     * Updates an existing Cars model.
     * If update is successful, the browser will be redirected to the 'view' page.
     * @param string $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionUpdate($id)
    {
        $model = $this->findModel($id);

        if ($model->load(Yii::$app->request->post())) {
            $model->datepurchased=date('Y-m-d',strtotime($model->datepurchased));
            
            if ($model->save()){
                \Yii::$app->session->setFlash('success','Successfull updated a car');
            return $this->redirect(['index']);
            }
        }

        return $this->render('update', [
            'model' => $model,
        ]);
    }

    /**
     * Deletes an existing Cars model.
     * If deletion is successful, the browser will be redirected to the 'index' page.
     * @param string $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionDelete($id)
    {
        $this->findModel($id)->delete();

        return $this->redirect(['index']);
    }

    /**
     * Finds the Cars model based on its primary key value.
     * If the model is not found, a 404 HTTP exception will be thrown.
     * @param string $id
     * @return Cars the loaded model
     * @throws NotFoundHttpException if the model cannot be found
     */
    protected function findModel($id)
    {
        if (($model = Cars::findOne($id)) !== null) {
            return $model;
        }

        throw new NotFoundHttpException('The requested page does not exist.');
    }
    
    public function actionAddcars(){
       $cars=Trucks::find()->all();
       
       if ($cars != null){
           foreach ($cars as $car){
               $model= new Cars();
               $model->typeId=Cartype::getCartypeId($car->modelNo);
               $model->plateno=trim($car->id);
               $model->datepurchased=$car->registeredDate;
               $model->status=$car->status;
               $model->company=$car->company;
               
               $model->save();
               
           }
       }
    }
    
    
        public function actionPrintcars(){
        
        $cars= Cars::find()->where(['company'=>\Yii::$app->session->get('company')])->orderBy(['typeId'=>SORT_DESC])->all();
        $allcars=null;
        $cnt=0;
        $f='2022-01-01';
        $t=date('Y-m-d');
     
        if ($cars != null){
            foreach ($cars as $car){
     
                    
                    if ($car->status==1){
                        
                        $allcars[$cnt]['plateno']=$car->plateno;
                        $allcars[$cnt]['type']=$car->type->model;
                        $allcars[$cnt]['brand']=$car->type->carmodel->name;
                        //$allcars[$cnt]['frequency']=count(Defectivetrucks::checkCarAvailability($car->plateno,$f,$t));
                       // $allcars[$cnt]['Costspent']=Bills::getCarCostByTime($f,$t,$car->plateno);
                        $cnt++;
                    }
                    
            } }
            
            $exporter = new Spreadsheet([
                'dataProvider' => new ArrayDataProvider([
                    'allModels' => $allcars
                ]),
                
                'columns' => [
                    [
                        'attribute' => 'plateno',
                        'contentOptions' => [
                            'width' => [
                                '35px'
                            ],
                        ],
                    ],
                    [
                        'attribute' => 'type',
                    ],
                    [
                        'attribute' => 'brand',
                    ],
                   /* [
                        'attribute' => 'frequency',
                    ],
                    [
                        'attribute' => 'Costspent',
                    ], */
                ],
            ]);
            
            return $exporter->send('carslist.xls');
    }
    
        public function actionPrintservicereport(){
        
        
        $data = $this->renderPartial('_servicereport');
        
        $pdf = new Pdf([
            'mode' => Pdf::MODE_CORE,
            'format' => Pdf::FORMAT_A4,
            'orientation' => Pdf::ORIENT_PORTRAIT,
            'destination' => Pdf::DEST_BROWSER,
            'content' => $data,
            'cssFile' => '@vendor/kartik-v/yii2-mpdf/src/assets/kv-mpdf-bootstrap.min.css',
            'cssInline' => '.kv-heading-1{font-size:18px}',
            'options' => ['title' => 'Bills request'],
            'methods' => [
                'SetHeader'=>[''],
                'SetFooter'=>['{PAGENO}'],
            ]
        ]);
        
        return $pdf->render();
        
    }
    
    
}
