<?php

namespace app\controllers;

use Yii;
use yii2tech\spreadsheet\Spreadsheet;
use yii\data\ArrayDataProvider;
use kartik\mpdf\Pdf;
use app\models\Cardrivers;
use app\models\CardriversSearch;
use yii\web\Controller;
use yii\web\NotFoundHttpException;
use yii\filters\VerbFilter;
use app\models\Cars;
use app\models\Trailers;
use app\models\Movements;
use app\models\Uzers;

/**
 * CardriversController implements the CRUD actions for Cardrivers model.
 */
class CardriversController extends Controller
{
    
    public function init() {
        
        if (\Yii::$app->session->get('layout') != null){
            $this->layout = \Yii::$app->session->get('layout');
        }else{
            $this->layout ='main';
        }
        
    }
    
    /**
     * {@inheritdoc}
     */
    public function behaviors()
    {
        return [
            'verbs' => [
                'class' => VerbFilter::className(),
                'actions' => [
                    'delete' => ['POST'],
                ],
            ],
        ];
    }

    /**
     * Lists all Cardrivers models.
     * @return mixed
     */
  public function actionIndex()
    {
    
        $drivers= Uzers::find()
        ->where(['status'=>1,'company'=>\Yii::$app->session->get('company')])->all();
        
        $allDrivers=null;
        $average=null;
        $cnt=0;
        
        if($drivers!=null){
            foreach ($drivers as $driver){
                
                $dr=Cardrivers::find()->where(['status'=>1,'userId'=>$driver->id])->all();
                
                if ($dr != null){
                
                $allDrivers[$cnt]['name']=$driver->firstname.' '.$driver->lastname;
                $allDrivers[$cnt]['phone']=$driver->mobilephone;
                $allDrivers[$cnt]['id']=$driver->id;
                $allDrivers[$cnt]['bday']=Uzers::getAgeByBdate($driver->birthdate);
                $allDrivers[$cnt]['licence']=$driver->licence;
                
                $average[$cnt]['val']=$allDrivers[$cnt]['name'];
                $cnt++;
                
                
                }
               
            }
        }
        
        array_multisort($average,SORT_ASC,$allDrivers);
        
        return $this->render('index',['drivers'=>$allDrivers]);
    }
    
        
    public function actionPrintdrivers()
    {
        
        $drivers= Uzers::find()
        ->where(['status'=>1,'company'=>\Yii::$app->session->get('company')])->all();
        
        $allDrivers=null;
        $average=null;
        $cnt=0;
        
        if($drivers!=null){
            foreach ($drivers as $driver){
                $dr=Cardrivers::find()->where(['status'=>1,'userId'=>$driver->id])->all();
                
                if ($dr != null){
                    
                    $allDrivers[$cnt]['name']=$driver->firstname.' '.$driver->lastname;
                    $allDrivers[$cnt]['phone']=$driver->mobilephone;
                    $allDrivers[$cnt]['id']=$driver->id;
                    $allDrivers[$cnt]['bday']=Uzers::getAgeByBdate($driver->birthdate);
                    $allDrivers[$cnt]['licence']=$driver->licence;
                    $allDrivers[$cnt]['trucks']=Cardrivers::getDriverCars($driver->id);
                    
                    $average[$cnt]['val']=$allDrivers[$cnt]['name'];
                    $cnt++;
                    
                }
                  
                
            }
        }
        
        array_multisort($average,SORT_ASC,$allDrivers);
        
             $exporter = new Spreadsheet([
            'dataProvider' => new ArrayDataProvider([
                'allModels' => $allDrivers
            ]),
            
            'columns' => [
                
                [
                    'attribute' => 'name',
                ],
                
                [
                    'attribute' => 'phone',
                ],
                [
                    'attribute' => 'trucks',
                ],
            ],
        ]);
        
        return $exporter->send('driverlist.xls');
        
        
        /*
        array_multisort($average,SORT_ASC,$allDrivers);
  
        $data = $this->renderPartial('_reportview',['datas'=>$allDrivers]);
        
        $pdf = new Pdf([
            'mode' => Pdf::MODE_CORE,
            'format' => Pdf::FORMAT_A4,
            'orientation' => Pdf::ORIENT_PORTRAIT,
            'destination' => Pdf::DEST_BROWSER,
            'content' => $data,
            'cssFile' => '@vendor/kartik-v/yii2-mpdf/src/assets/kv-mpdf-bootstrap.min.css',
            'cssInline' => '.kv-heading-1{font-size:18px}',
            'options' => ['title' => 'Driver list'],
            'methods' => [
                'SetFooter'=>['{PAGENO}'],
            ]
        ]);
        
        return $pdf->render();
        */
  
    }

    /**
     * Displays a single Cardrivers model.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionView($id)
    {
        return $this->render('view', [
            'model' => $this->findModel($id),
        ]);
    }
    
    
    
      public function actionSetdrivercars($id)
    {
        
        $model = new Cardrivers(); 
        
        if ($model->load(Yii::$app->request->post())){
            $model->userId=$id;
            $model->dateassigned=date('Y-m-d');
            
            if ($model->save()){
                return $this->redirect(['uzers/view', 'id' => $id]);
            }
            
        }
            return $this->render('setdrivercars', [
                'model' => $model,'id'=>$id
            ]);
        
    }
    
    
    public function actionUnsetdrivercars($id)
    {
        
        $activecars= Cardrivers::find()->where(['userId'=>$id,'status'=>1])->all();
        
        if ($activecars != null){
            foreach ($activecars as $act){
               $act->status=0;
               $act->save();
            }
           
        }
        
        return $this->redirect(['uzers/view', 'id' => $id]);
    }
    
    
       
    public function actionUnsetonedriver($id,$car)
    {
        
        $activecars= Cardrivers::find()->where(['userId'=>$id,'status'=>1,'carId'=>$car])->all();
        
        if ($activecars != null){
            foreach ($activecars as $act){
                $act->status=0;
                $act->save();
            }
            
        }
        
        return $this->redirect(['cars/view', 'id' => $car]);
    }
    
    
    public function actionDriveall($id)
    {
        
        $campcars=Cars::find()->where(['company'=>\Yii::$app->session->get('company'),'status'=>1])->all();
    
        if ($campcars != null){
            
            foreach ($campcars as $camp){
                
                $actd= Cardrivers::find()->where(['carId'=>$camp->plateno,'status'=>1, 'userId'=>$id])->all();
                
                if ($actd == null){
                        $model = new Cardrivers();
                        $model->userId=$id;
                        $model->carId=$camp->plateno;
                        $model->dateassigned=date('Y-m-d');
                        $model->save();
                }
            
            }
            
        }
        return $this->redirect(['uzers/view', 'id' => $id]);
        
    }
    
    

    /**
     * Creates a new Cardrivers model.
     * If creation is successful, the browser will be redirected to the 'view' page.
     * @return mixed
     */
    public function actionCreate($id)
    {
        $model = new Cardrivers(); 
        $trailer= new Trailers();

        if ($model->load(Yii::$app->request->post()) && $trailer->load(\Yii::$app->request->post())) {
         
            $model->carId=$id;
            $model->dateassigned=date('Y-m-d');
            
            $trailer->horseid=$id;
            $trailer->dateassigned=date('Y-m-d');
            
            $valid=$model->validate();
            $valid=$valid && $trailer->validate();
      
            if($valid){
                Cardrivers::deactivateActiveDriver($id,$model->userId);
                Trailers::deactivateActiveTrailer($id,$trailer->trailerid);
              $model->save();
              $trailer->save();
            \Yii::$app->session->setFlash('success','Successfull set a trailer and a driver');
            return $this->redirect(['cars/view', 'id' => $id]);
            
            }else {
                \Yii::$app->session->setFlash('error','Driver & Trailer setup failed');
            }
            
        }
        Cardrivers::find()->where(['carId'=>$id])->one()!=null?$model=Cardrivers::find()->where(['carId'=>$id])->one():'';
        Trailers::find()->where(['horseid'=>$id])->one()!=null?$trailer=Trailers::find()->where(['horseid'=>$id])->one():'';

        return $this->renderAjax('create', [
            'model' => $model,'trailer'=>$trailer,'id'=>$id,
        ]);
    }

    /**
     * Updates an existing Cardrivers model.
     * If update is successful, the browser will be redirected to the 'view' page.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionUpdate($id)
    {
        $model = $this->findModel($id);

        if ($model->load(Yii::$app->request->post()) && $model->save()) {
            return $this->redirect(['view', 'id' => $model->id]);
        }

        return $this->render('update', [
            'model' => $model,
        ]);
    }
    
    
    public function actionUpdatedriver($id)
    {
        $modelDriver = Cardrivers::findOne(['userId'=>$id,'status'=>1]);
        $uzer = Uzers::findOne($id);
        $model= new Cardrivers();
        $model->carId=$modelDriver->carId;
        
        if ($model->load(Yii::$app->request->post()) && $uzer->load(Yii::$app->request->post())) {
            
            $model->userId=$id;
            $model->dateassigned=date('Y-m-d');
            $model->status=1;
            
            $valid=$model->validate();
            $valid=$valid && $uzer->validate();
            
            if($valid){
                $activecars= Cardrivers::find()->where(['userId'=>$id,'status'=>1])->all();
                
                if ($activecars != null){
                    foreach ($activecars as $act){
                        $act->status=0;
                        $act->save();
                    }
                    
                }
                
                $model->save();
                $uzer->save();
                \Yii::$app->session->setFlash('success','Successfull updated a driver');
                return $this->redirect(['index']);
                
            }else {
                \Yii::$app->session->setFlash('error','Driver updates failed');
            }
        }
        
        return $this->render('updatedriver', [
            'model' => $model,'uzer'=>$uzer,
        ]);
    }

    /**
     * Deletes an existing Cardrivers model.
     * If deletion is successful, the browser will be redirected to the 'index' page.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionDelete($id)
    {
        $this->findModel($id)->delete();

        return $this->redirect(['index']);
    }

    /**
     * Finds the Cardrivers model based on its primary key value.
     * If the model is not found, a 404 HTTP exception will be thrown.
     * @param integer $id
     * @return Cardrivers the loaded model
     * @throws NotFoundHttpException if the model cannot be found
     */
    protected function findModel($id)
    {
        if (($model = Cardrivers::findOne($id)) !== null) {
            return $model;
        }

        throw new NotFoundHttpException('The requested page does not exist.');
    }
}
