<?php

namespace app\controllers;

use Yii;
use Behat\Gherkin\Exception\Exception;
use app\models\Bills;
use app\models\Uzers;
use app\models\BillsSearch;
use yii\web\Controller;
use yii\web\NotFoundHttpException;
use yii\filters\VerbFilter;
use app\models\Billcontent;
use app\models\Servicecost;
use app\models\Services;
use app\models\Wshopbills;
use app\models\Cfbills;
use kartik\mpdf\Pdf;
use app\models\Billpayments;
use app\models\Model;
use yii\helpers\ArrayHelper;
use app\models\Accounts;
use app\models\Billbulkpayments;

/**
 * BillsController implements the CRUD actions for Bills model.
 */
class BillsController extends Controller
{

    public function init() {
        
        if (\Yii::$app->session->get('layout') != null){
            $this->layout = \Yii::$app->session->get('layout');
        }else{
            $this->layout ='accounts';
        }
    }
    
    
    /**
     * {@inheritdoc}
     */
    public function behaviors()
    {
        return [
            'verbs' => [
                'class' => VerbFilter::className(),
                'actions' => [
                    'delete' => ['POST'],
                ],
            ],
        ];
    }

    /**
     * Lists all Bills models.
     * @return mixed
     */
    public function actionIndex()
    {
        $searchModel = new BillsSearch();
        $dataProvider = $searchModel->search(Yii::$app->request->queryParams);

        return $this->render('index', [
            'searchModel' => $searchModel,
            'dataProvider' => $dataProvider,
        ]);
    }
    
    public function actionRfq()
    {
        $this->layout='workshop';
        $datas = Bills::find()->where(['company'=>\Yii::$app->session->get('company')])->all();
        
        return $this->render('rfq', [
            'datas' => $datas,
        ]);
    }

    
    public function actionIndexpaid()
    {
        $searchModel = new BillsSearch();
        $dataProvider = $searchModel->searchpaid(Yii::$app->request->queryParams);
        
        return $this->render('indexpaid', [
            'searchModel' => $searchModel,
            'dataProvider' => $dataProvider,
        ]);
    }
    /**
     * Displays a single Bills model.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionView($id)
    {
        return $this->render('view', [
            'model' => $this->findModel($id),
        ]);
    }

    /**
     * Creates a new Bills model.
     * If creation is successful, the browser will be redirected to the 'view' page.
     * @return mixed
     */
    public function actionCreate()
    {
        $modelbill = new Bills();
        $modelbillcontent = [new Billcontent()];
        $checkdue= Bills::checkDueBills();
        
        if ($modelbill->load(Yii::$app->request->post())) {
            
            $modelbill->date=date('Y-m-d',strtotime($modelbill->date));
            $modelbill->dueDate=date('Y-m-d',strtotime('+7 days',strtotime($modelbill->date)));
            $modelbill->company=\Yii::$app->session->get('company');
            $modelbill->userId=\Yii::$app->user->getId();
            $modelbill->status=0;
            $modelbill->comment=$modelbill->comment;
            
            $modelbillcontent= Model::createMultiple(Billcontent::classname());
            Model::loadMultiple($modelbillcontent, Yii::$app->request->post());
            
            
            
            // validate all models
            $valid = $modelbill->validate();
            
            if ($valid) {
                $transaction = \Yii::$app->db->beginTransaction();
                try {
                    if ($flag = $modelbill->save(false)) {
                        
                        foreach ($modelbillcontent as $billcont) {
                             
                                $billcont->billId = $modelbill->id;
                                $contId=Billcontent::checkServiceInBill($billcont->serviceId,$modelbill->id,$billcont->carId);
                                $valid=$billcont->validate();
                                if ($valid && $contId==null && Bills::findOne($modelbill->id)->currency==Services::findOne($billcont->serviceId)->currency){
                                
                                    if (! ($flag = $billcont->save(false))) {
                                        $transaction->rollBack();
                                        break;
                                    }
                                }else{
                                    \Yii::$app->session->setFlash('error','Mis-matching currency,or problems in the fields');
                                    $transaction->rollBack();
                                    return $this->redirect(['bills/create']);
                                    break;
                                }
                        }
                    }
                    if ($flag) {
                        
                        $updatebill= Bills::findOne($modelbill->id);
                        $updatebill->status=1;
                        $updatebill->save();
                       
                        \Yii::$app->session->setFlash('success','Successfull saved new bill');
                        $transaction->commit();
                        return $this->redirect(['billpayments/create','id'=>$modelbill->id]);
                    }
                } catch (Exception $e) {
                    $transaction->rollBack();
                }
            }else{
                \Yii::$app->session->setFlash('error','Error on the validation');
            }
        }
        
        if ($checkdue==0){
        
            return $this->render('create', [
                'modelbill' => $modelbill,
                'modelbillcontent' => (empty($modelbillcontent)) ? [new Billcontent()] : $modelbillcontent
            ]);
            
        }else{
            \Yii::$app->session->setFlash('error','There is total of '.$checkdue.' due bills, record payments first');
            return $this->redirect(['bills/indexpaid']);
        }
    }
    
    
        public function actionCreditnote()
    {
        $modelbill = new Bills();
        $modelbillcontent = [new Billcontent()];
        $checkdue= Bills::checkDueBills();
        
        if ($modelbill->load(Yii::$app->request->post())) {
            
            $modelbill->date=date('Y-m-d',strtotime($modelbill->date));
            $modelbill->dueDate=date('Y-m-d',strtotime('+7 days',strtotime($modelbill->date)));
            $modelbill->company=\Yii::$app->session->get('company');
            $modelbill->userId=\Yii::$app->user->getId();
            $modelbill->status=0;
            $modelbill->paid=1;
            $modelbill->comment=$modelbill->comment;
            
            $modelbillcontent= Model::createMultiple(Billcontent::classname());
            Model::loadMultiple($modelbillcontent, Yii::$app->request->post());
            
            
            
            // validate all models
            $valid = $modelbill->validate();
            
            if ($valid) {
                $transaction = \Yii::$app->db->beginTransaction();
                try {
                    if ($flag = $modelbill->save(false)) {
                        
                        foreach ($modelbillcontent as $billcont) {
                             
                                $billcont->billId = $modelbill->id;
                                $billcont->amount=(-1*$billcont->amount);
                                $contId=Billcontent::checkServiceInBill($billcont->serviceId,$modelbill->id,$billcont->carId);
                                $valid=$billcont->validate();
                                if ($valid && $contId==null && Bills::findOne($modelbill->id)->currency==Services::findOne($billcont->serviceId)->currency){
                                
                                    if (! ($flag = $billcont->save(false))) {
                                        $transaction->rollBack();
                                        break;
                                    }
                                }else{
                                    \Yii::$app->session->setFlash('error','Mis-matching currency,or problems in the fields');
                                    $transaction->rollBack();
                                    return $this->redirect(['bills/create']);
                                    break;
                                }
                        }
                    }
                    if ($flag) {
                        \Yii::$app->session->setFlash('success','Successfull saved credit note');
                        $transaction->commit();
                        return $this->redirect(['bills/creditnote']);
                    }
                } catch (Exception $e) {
                    $transaction->rollBack();
                }
            }else{
                \Yii::$app->session->setFlash('error','Error on the validation');
            }
        }
            return $this->render('creditnote', [
                'modelbill' => $modelbill,
                'modelbillcontent' => (empty($modelbillcontent)) ? [new Billcontent()] : $modelbillcontent
            ]);
    }
   
    
    
    public function actionCreatepet($id)
    {
        $modelbill = new Bills();
        $modelbillcontent = [new Billcontent()];
        $checkdue= Bills::checkDueBills();
        
        if ($modelbill->load(Yii::$app->request->post())) {
            
            $modelbill->date=date('Y-m-d',strtotime($modelbill->date));
            $modelbill->dueDate=date('Y-m-d',strtotime('+7 days',strtotime($modelbill->date)));
            $modelbill->company=\Yii::$app->session->get('company');
            $modelbill->userId=\Yii::$app->user->getId();
            $modelbill->status=0;
            $modelbill->clientId=$id;
            
            $modelbillcontent= Model::createMultiple(Billcontent::classname());
            Model::loadMultiple($modelbillcontent, Yii::$app->request->post());
            
            
            
            // validate all models
            $valid = $modelbill->validate();
            
            if ($valid) {
                $transaction = \Yii::$app->db->beginTransaction();
                try {
                    if ($flag = $modelbill->save(false)) {
                        
                        foreach ($modelbillcontent as $billcont) {
                            
                            $billcont->billId = $modelbill->id;
                            $contId=Billcontent::checkServiceInBill($billcont->serviceId,$modelbill->id,$billcont->carId);
                            $valid=$billcont->validate();
                            if ($valid && $contId==null && Bills::findOne($modelbill->id)->currency==Services::findOne($billcont->serviceId)->currency){
                                
                                if (! ($flag = $billcont->save(false))) {
                                    $transaction->rollBack();
                                    break;
                                }
                            }else{
                                \Yii::$app->session->setFlash('error','Mis-matching currency,or problems in the fields');
                                $transaction->rollBack();
                                return $this->redirect(['bills/createpet','id'=>$id]);
                                break;
                            }
                        }
                    }
                    if ($flag) {
                        
                        $updatebill= Bills::findOne($modelbill->id);
                        $updatebill->status=1;
                        $updatebill->save();
                        
                        \Yii::$app->session->setFlash('success','Successfull saved new bill');
                        $transaction->commit();
                        return $this->redirect(['billpayments/create','id'=>$modelbill->id]);
                    }
                } catch (Exception $e) {
                    $transaction->rollBack();
                }
            }else{
                \Yii::$app->session->setFlash('error','Error on the validation');
            }
        }
        
        if ($checkdue==0){
            
            return $this->render('createpet', [
                'modelbill' => $modelbill,
                'modelbillcontent' => (empty($modelbillcontent)) ? [new Billcontent()] : $modelbillcontent
            ]);
            
        }else{
            \Yii::$app->session->setFlash('error','There is total of '.$checkdue.' due bills, record payments first');
            return $this->redirect(['bills/indexpaid']);
        }
    }
    
    
    public function actionCreateworkshop()
    {
        $this->layout='workshop';
        
        $modelbill = new Bills();
        $modelbillcontent = [new Billcontent()];
        $wbills = new Wshopbills();
        $checkdue= Bills::checkDueBills();
        
        if ($modelbill->load(Yii::$app->request->post())) {
            
            $modelbill->date=date('Y-m-d',strtotime($modelbill->date));
            $modelbill->dueDate=date('Y-m-d',strtotime('+7 days',strtotime($modelbill->date)));
            $modelbill->company=\Yii::$app->session->get('company');
            $modelbill->userId=\Yii::$app->user->getId();
            $modelbill->status=0;
            $modelbill->currency=1;
            $modelbill->comment=$modelbill->comment;
            
            $modelbillcontent= Model::createMultiple(Billcontent::classname());
            Model::loadMultiple($modelbillcontent, Yii::$app->request->post());
            
            
            
            // validate all models
            $valid = $modelbill->validate();
            
            if ($valid) {
                $transaction = \Yii::$app->db->beginTransaction();
                try {
                    if ($flag = $modelbill->save(false)) {
                        
                        $wbills->billid=$modelbill->id;
                        $wbills->company=\Yii::$app->session->get('company');
                        $wbills->save();
                        
                        foreach ($modelbillcontent as $billcont) {
                            
                            $billcont->billId = $modelbill->id;
                            $contId=Billcontent::checkServiceInBill($billcont->serviceId,$modelbill->id,$billcont->carId);
                            
                            $valid = $billcont->validate();
                            if ($valid && $contId==null && Bills::findOne($modelbill->id)->currency==Services::findOne($billcont->serviceId)->currency){
                                
                                if (! ($flag = $billcont->save(false))) {
                                    $transaction->rollBack();
                                    break;
                                }
                            }else{
                                \Yii::$app->session->setFlash('error','Mis-matching currency,or problems in the fields');
                                $transaction->rollBack();
                                return $this->redirect(['bills/createworkshop']);
                                break;
                            }
                        }
                    }
                    if ($flag) {
                        
                        $updatebill= Bills::findOne($modelbill->id);
                        $updatebill->status=1;
                        $updatebill->save();
                        
                        \Yii::$app->session->setFlash('success','Successfull saved new bill');
                        $transaction->commit();
                        return $this->redirect(['billpayments/create','id'=>$modelbill->id]);
                    }
                } catch (Exception $e) {
                    $transaction->rollBack();
                }
            }else{
                \Yii::$app->session->setFlash('error','Error on the validation');
            }
        }
        
       // if ($checkdue==0){
            
            return $this->render('createworkshop', [
                'modelbill' => $modelbill,
                'modelbillcontent' => (empty($modelbillcontent)) ? [new Billcontent()] : $modelbillcontent
            ]);
            
        //}else{
        //    \Yii::$app->session->setFlash('error','There is total of '.$checkdue.' due bills, record payments first');
        //    return $this->redirect(['bills/indexpaid']);
        //}
    }
  
    
    
    public function actionCreaterfq()
    {
        $this->layout='workshop';
        
        $model = new Bills();
        $wbills = new Wshopbills();
        
        if ($model->load(Yii::$app->request->post())) {
            
            $modelbill->date=date('Y-m-d');
            $modelbill->dueDate=date('Y-m-d',strtotime('+7 days'));
            $model->company=\Yii::$app->session->get('company');
            $model->userId=\Yii::$app->user->getId();
            $model->billby=Bills::getAccountId($model->clientId);
            $model->status=0;
            
            if($model->save()){
                $wbills->billid=$model->id;
                $wbills->company=\Yii::$app->session->get('company');
                $wbills->save();
                
                return $this->redirect(['billcontent/createworkshop', 'id' => $model->id]);
            }
        }
        
        if (\Yii::$app->request->isAjax){
            return $this->renderAjax('createrfq', [
                'model' => $model,
            ]);
        }else{
            return $this->render('createrfq', [
                'model' => $model,
            ]);
        }
    }
    
    
    public function actionCreateclearing()
    {
        $this->layout='cnf';
        
        $modelbill = new Bills();
        $modelbillcontent = [new Billcontent()];
        $cbills = new Cfbills();
        $modelbill->date=date('d-M-Y');
        $modelbill->dueDate=date('d-M-Y',strtotime('+7 days'));
        
        $checkdue= Bills::checkDueBills();
        
        if ($modelbill->load(Yii::$app->request->post())) {
            
            $modelbill->date=date('Y-m-d');
            $modelbill->dueDate=date('Y-m-d',strtotime('+7 days'));
            $modelbill->company=\Yii::$app->session->get('company');
            $modelbill->userId=\Yii::$app->user->getId();
            $modelbill->status=0;
            $modelbill->comment=$modelbill->comment;
            
            $modelbillcontent= Model::createMultiple(Billcontent::classname());
            Model::loadMultiple($modelbillcontent, Yii::$app->request->post());
            
            
            
            // validate all models
            $valid = $modelbill->validate();
            
            if ($valid) {
                $transaction = \Yii::$app->db->beginTransaction();
                try {
                    if ($flag = $modelbill->save(false)) {
                        
                        $cbills->billId=$modelbill->id;
                        $cbills->fileId=\Yii::$app->session->get('fileId');
                        $cbills->save();
                        
                        foreach ($modelbillcontent as $billcont) {
                            
                            $billcont->billId = $modelbill->id;
                            $contId=Billcontent::checkServiceInBillByFile($billcont->serviceId,$modelbill->id,\Yii::$app->session->get('fileId'));
                            
                            $valid = $billcont->validate();
                            if ($valid && Bills::findOne($modelbill->id)->currency==Services::findOne($billcont->serviceId)->currency){
                                
                                if ($contId==null){
                                
                                    if (! ($flag = $billcont->save(false))) {
                                        $transaction->rollBack();
                                        break;
                                    }
                                    
                                }else{
                                    $transaction->rollBack();
                                    \Yii::$app->session->setFlash('error','The services has been billed already');
                                    return $this->redirect(['billcontent/createclearing','id'=>Billcontent::findOne($contId)->billId]);
                                    break;
                                }
                                
                            }else{
                                $transaction->rollBack();
                                \Yii::$app->session->setFlash('error','Mis-matching currency or problems in the fields');
                                return $this->redirect(['bills/createclearing']);
                                break;
                            }
                        }
                    }
                    if ($flag) {
                        
                        $updatebill= Bills::findOne($modelbill->id);
                        $updatebill->status=1;
                        $updatebill->save();
                        
                        \Yii::$app->session->setFlash('success','Successfull saved new bill');
                        $transaction->commit();
                        return $this->redirect(['billpayments/create','id'=>$modelbill->id]);
                    }
                } catch (Exception $e) {
                    $transaction->rollBack();
                }
            }else{
                \Yii::$app->session->setFlash('error','Error on the validation');
            }
        }
        
        if ($checkdue==0){
            
            return $this->render('createclearing', [
                'modelbill' => $modelbill,
                'modelbillcontent' => (empty($modelbillcontent)) ? [new Billcontent()] : $modelbillcontent
            ]);
            
        }else{
            \Yii::$app->session->setFlash('error','There is total of '.$checkdue.' due bills, record payments first');
            return $this->redirect(['bills/indexpaid']);
        } 
    }
  
   

    /**
     * Updates an existing Bills model.
     * If update is successful, the browser will be redirected to the 'view' page.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionUpdate($id)
    {
        $modelbill = $this->findModel($id);
        $modelbillcontent = $modelbill->billcontents;
        
        if ($modelbill->load(Yii::$app->request->post())) {
            
            $modelbill->date=date('Y-m-d',strtotime($modelbill->date));
            $modelbill->dueDate=date('Y-m-d',strtotime($modelbill->dueDate));
            
            $oldIDs = ArrayHelper::map($modelbillcontent, 'id', 'id');
            $modelbillcontent = Model::createMultiple(Billcontent::classname(), $modelbillcontent);
            Model::loadMultiple($modelbillcontent, Yii::$app->request->post());
            $deletedIDs = array_diff($oldIDs, array_filter(ArrayHelper::map($modelbillcontent, 'id', 'id')));
            
            
            // validate all models
            $valid = $modelbill->validate();
            
            if ($valid) {
                $transaction = \Yii::$app->db->beginTransaction();
                try {
                    if ($flag = $modelbill->save(false)) {
                        if (! empty($deletedIDs)) {
                            Billcontent::deleteAll(['id' => $deletedIDs]);
                        }
                        foreach ($modelbillcontent as $model) {
                            $model->billId = $modelbill ->id;
                            $valid=$model->validate();
                            
                            if ($valid){
                                if (! ($flag = $model->save(false))) {
                                    $transaction->rollBack();
                                    break;
                                }
                            }
                        }
                    }
                    if ($flag) {
                        $updatebill= Bills::findOne($modelbill->id);
                        $updatebill->status=1;
                        $updatebill->save();
                        
                        \Yii::$app->session->setFlash('success','Successfull updated a bill');
                        $transaction->commit();
                        return $this->redirect(['billpayments/create','id'=>$modelbill->id]);
                    }
                } catch (Exception $e) {
                    $transaction->rollBack();
                }
            }
        }
        
       if ($modelbill->paid==1) {
            \Yii::$app->session->setFlash('error','This bill is paid, remove payment to proceed editing');
            return $this->redirect(['billpayments/create','id'=>$id]);
        }else{
            return $this->render('update', [
                'modelbill' => $modelbill,
                'modelbillcontent' => (empty($modelbillcontent)) ? [new Billcontent()] : $modelbillcontent
            ]);
        }
}   


    /**
     * Deletes an existing Bills model.
     * If deletion is successful, the browser will be redirected to the 'index' page.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionDelete($id)
    {
        if (Billcontent::getBillCost($id)==0){
            $wbill= Wshopbills::find()->where(['billid'=>$id])->all();
            if ($wbill != null){
                foreach ($wbill as $wb){
                    $wb->delete();
                }
            }
            
            $cbill= Cfbills::find()->where(['billId'=>$id])->all();
            
            if ($cbill != null){
                foreach ($cbill as $cb){
                    $cb->delete();
                }
            }
            
            
              $payments= Billpayments::find()->where(['billId'=>$id])->all();
            
            if ($payments != null){
                foreach ($payments as $payment){
                    $payment->delete();
                }
            }
            
            
             $contents= Billcontent::find()->where(['billId'=>$id])->all();
            
            if ($contents != null){
                foreach ($contents as $cont){
                    $cont->delete();
                }
            }
            
        $this->findModel($id)->delete();
        \Yii::$app->session->setFlash('success','Bill successfull deleted ');
        return $this->redirect(['index']);
        }else{
            \Yii::$app->session->setFlash('error','This bill can not be deleted it has contents');
            return $this->redirect(['billcontent/create','id'=>$id]);
        }
        
       
    }
    
    
    
        public function actionUnlock($id)
    {
        $model = Bills::findOne($id);
        $model->status=0;
        
        if ($model->save()){
            $loc=\Yii::$app->session->get('location');
            if ($loc=='clear'){
                return $this->redirect(['billcontent/createclearing','id'=>$id]);
            }elseif ($loc=='rfq'){
                return $this->redirect(['billcontent/createrfq','id'=>$id]);
            }elseif($loc=='workshop'){
                return $this->redirect(['billcontent/createworkshop', 'id' =>$id]);
            }else{
                return $this->redirect(['billcontent/create','id'=>$id]);
            }
        }
      
    }
    

    /**
     * Finds the Bills model based on its primary key value.
     * If the model is not found, a 404 HTTP exception will be thrown.
     * @param integer $id
     * @return Bills the loaded model
     * @throws NotFoundHttpException if the model cannot be found
     */
    protected function findModel($id)
    {
        if (($model = Bills::findOne($id)) !== null) {
            return $model;
        }

        throw new NotFoundHttpException('The requested page does not exist.');
    }
    
    
    
    
    public function actionCarreport()
    {
        $this->layout='main';
        $model = new Bills();
        
        if (isset($_POST['Bills'])) {
            
            if($_POST['Bills']['to'] >= $_POST['Bills']['from']){
                
                $data = $this->renderPartial('_carreport',['from'=>$_POST['Bills']['from'],'to'=>$_POST['Bills']['to']]);
                
                $pdf = new Pdf([
                    'mode' => Pdf::MODE_CORE,
                    'format' => Pdf::FORMAT_A4,
                    'orientation' => Pdf::ORIENT_PORTRAIT,
                    'destination' => Pdf::DEST_BROWSER,
                    'content' => $data,
                    'cssFile' => '@vendor/kartik-v/yii2-mpdf/src/assets/kv-mpdf-bootstrap.min.css',
                    'cssInline' => '.kv-heading-1{font-size:18px}',
                    'options' => ['title' => 'spare utilization report'],
                    'methods' => [
                        'SetFooter'=>['{PAGENO}'],
                    ]
                ]);
                
                return $pdf->render();
            }
        }
        
        return $this->render('carreport', [
            'model' => $model,
        ]);
        
    }
    
    
        
    public function actionGetPrice($selected)
    {
        $service= Servicecost::find()->where(['serviceId'=>$selected,'status'=>1])->one();
        
        echo json_encode($service->purchasecost);
    }
    
    
        
    public function actionSuppliersummary()
    {
        $model= new Bills();
        $dataProvider=null;
        $from=null;
        $to=null;
        $contents=null;
        $cnt=0;
        $costtotal=0;
        $paytotal=0;
        $balance=0;
        
        if (isset($_POST['Bills'])) {
            $f=$_POST['Bills']['from'];
            $t=$_POST['Bills']['to'];
            $from=date('Y-m-d',strtotime($_POST['Bills']['from']));
            $to=date('Y-m-d',strtotime($_POST['Bills']['to']));
            $clie=$_POST['Bills']['clientId'];
            $cmpn=\Yii::$app->session->get('company');
           // $contents = Bills::find()->where("date>='$from' and date <='$to' and clientId='$clie' and company='$cmpn'")->orderBy(['date'=>SORT_DESC])->all();
            
            $daysinterval=Uzers::getdaysdifference($f,$t);
            
            if($from < $to){
            
            for($k=0; $k<=$daysinterval; $k++){
                $bills=Bills::find()->where("date='$from' and clientId='$clie' and company='$cmpn'")->orderBy(['date'=>SORT_DESC])->all();
                
                if($bills != null){
                    foreach($bills as $bill){
                        $contents[$cnt]['date']=$from;
                        $contents[$cnt]['bill']=Bills::getBillNo(Bills::findOne($bill->id)->company,$bill->id);;
                        $contents[$cnt]['narration']=$bill->comment;
                        $cost=Billcontent::getBillCost($bill->id);
                        $costtotal=$costtotal+$cost;
                        $contents[$cnt]['cost']=number_format($cost,2).' '.Accounts::getCurrency($bill->currency);
                        $balance=$costtotal - $paytotal;
                        $contents[$cnt]['ballance']=number_format($balance,2);
                        $cnt++;
                    }
                }
            
            $bulkpayments=Billbulkpayments::find()->where("date='$from' and clientId='$clie' and company='$cmpn'")->orderBy(['date'=>SORT_DESC])->all();
            
            if($bulkpayments != null){
                foreach($bulkpayments as $bulkpay){
                    $contents[$cnt]['date']=$from;
                    $contents[$cnt]['narration']=$bulkpay->checkNo;
                    $contents[$cnt]['payment']=number_format($bulkpay->amount,2).' '.Accounts::getCurrency($bulkpay->account->cur);
                    $paytotal=$paytotal + $bulkpay->amount;
                    $balance =$costtotal - $paytotal;
                    $contents[$cnt]['ballance']=number_format($balance,2);
                    $cnt++;
                }
            }
            
            $from=date('Y-m-d',strtotime('+1 day',strtotime($from)));
                
                if($to==$from) break;
                
                }
                        
           
            
            $data = $this->renderPartial('_summaryview',['clie'=>$clie,'contents'=>$contents,'from'=>$f,'to'=>$t,'balance'=>$balance,'cost'=>$costtotal]);
            
            $pdf = new Pdf([
                'mode' => Pdf::MODE_CORE,
                'format' => Pdf::FORMAT_A4,
                'orientation' => Pdf::ORIENT_PORTRAIT,
                'destination' => Pdf::DEST_BROWSER,
                'content' => $data,
                'cssFile' => '@vendor/kartik-v/yii2-mpdf/src/assets/kv-mpdf-bootstrap.min.css',
                'cssInline' => '.kv-heading-1{font-size:18px}',
                'options' => ['title' => 'Invoice'],
                'methods' => [
                    'SetFooter'=>['{PAGENO}'],
                ]
            ]);
            
            return $pdf->render();
            
            }else{
                  \Yii::$app->session->setFlash('error','From can not be greater than to');
            }    
        }
        
        
        return $this->render('suppliersummary', [
            'model' => $model,
        ]);
    }
    
    
    
    
    
    
}