<?php

namespace app\controllers;

use Yii;
use app\models\Billpayments;
use app\models\BillpaymentsSearch;
use yii\web\Controller;
use yii\web\NotFoundHttpException;
use yii\filters\VerbFilter;
use app\models\Bills;
use app\models\Billcontent;
use app\models\Billbulkpayments;

/**
 * BillpaymentsController implements the CRUD actions for Billpayments model.
 */
class BillpaymentsController extends Controller
{
       public function init() {
        
        if (\Yii::$app->session->get('layout') != null){
            $this->layout = \Yii::$app->session->get('layout');
        }else{
            $this->layout ='accounts';
        }
    }
    
    /**
     * {@inheritdoc}
     */
    public function behaviors()
    {
        return [
            'verbs' => [
                'class' => VerbFilter::className(),
                'actions' => [
                    'delete' => ['POST'],
                ],
            ],
        ];
    }

    /**
     * Lists all Billpayments models.
     * @return mixed
     */
    public function actionIndex()
    {
        $searchModel = new BillpaymentsSearch();
        $dataProvider = $searchModel->search(Yii::$app->request->queryParams);

        return $this->render('index', [
            'searchModel' => $searchModel,
            'dataProvider' => $dataProvider,
        ]);
    }

    /**
     * Displays a single Billpayments model.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionView($id)
    {
        return $this->render('view', [
            'model' => $this->findModel($id),
        ]);
    }

    /**
     * Creates a new Billpayments model.
     * If creation is successful, the browser will be redirected to the 'view' page.
     * @return mixed
     */
    public function actionCreate($id)
    {
        
        $fileId= \Yii::$app->session->get('fileId');
       // if ($fileId != 0) $this->layout='cnf';
        
        $model = new Billpayments();

        if ($model->load(Yii::$app->request->post())) {
            
            $model->userId=\Yii::$app->user->getId();
            $model->company=\Yii::$app->session->get('company');
            $model->billId=$id;
            $model->date=date('Y-m-d');
            if ($model->amount<=Billcontent::getBillCost($id) && $model->amount>0 && Billpayments::getPaidByBill($id)==0){
            if($model->save()){
                
            //recording to bulk table so it can appear on statements
            $bulkmodel= new Billbulkpayments();
            $bulkmodel->userId=\Yii::$app->user->getId();
            $bulkmodel->company=\Yii::$app->session->get('company');
            $bulkmodel->date=date('Y-m-d');
            $bulkmodel->accountId=$model->accountId;
            $bulkmodel->amount=$model->amount;
            $bulkmodel->checkNo=$model->checkNo;
            $bulkmodel->clientId=Bills::findOne($id)->clientId;
            
            if($bulkmodel->save()){
                
            }else{
               \Yii::$app->session->setFlash('error','Couldnot save bulk model');
                return $this->redirect(['billpayments/createsuppliers']);  
            }
                
                $bill=Bills::findOne($id);
                $bill->paid=1;
                if ($bill->save()){
                    return $this->redirect(['billcontent/printrequest','id'=>$id]);
                }
            }
            }else{
                \Yii::$app->session->setFlash('error','Check the inserted payment amount, Or bill is paid');
            }
        }
        
       /* $from='2021-12-31';
        $to='2022-12-31';
        
        $bls= Bills::find()->where("date >= '$from' and date <= '$to' and paid=:c",[':c'=>0])->all();
        $hesabu=count($bls);
       
        if ($bls != null){
            foreach ($bls as $bl){
                $cst=Billcontent::getBillCost($bl->id);
                if ($cst>0){
                $bpy=new Billpayments();
                $bpy->accountId=32;
                $bpy->amount=$cst;
                $bpy->checkNo='0';
                $bpy->billId=$bl->id;
                $bpy->date=date('Y-m-d');
                $bpy->company=$bl->company;
                $bpy->userId=\Yii::$app->user->getId();
                
                if ($bpy->save()){
                    $bb= Bills::findOne($bl->id);
                    $bb->paid=1;
                    $bb->save();
                    \Yii::$app->session->setFlash('success','BILL UPDATED AND UNPAID PAID '.$hesabu);
                }else{
                    \Yii::$app->session->setFlash('error','COULDNT UPDATE BILL AND WAS NOT SAVED');
                }
                }else{
                    $bb= Bills::findOne($bl->id);
                    $bb->paid=1;
                    $bb->save();
                    \Yii::$app->session->setFlash('success','BILL UPDATED AND UNPAID PAID');
                }
            }
        }else{
            \Yii::$app->session->setFlash('error','NO UNPAID BILLS '. $hesabu);
        }  */
        
        return $this->render('create', [
            'model' => $model,'id'=>$id,
        ]);
    }
    
    
        public function actionCreatesuppliers()
    {
        
        $fileId= \Yii::$app->session->get('fileId');
       // if ($fileId != 0) $this->layout='cnf';
        
        $model = new Billpayments();
        $count=0;

        if ($model->load(Yii::$app->request->post())) {
            $clientId= $model->clientId;
            $cur = $model->cur;
            $initialamount= $model->amount;
            
            $clientunpaidbills= Bills::getUnpaidbillsbyclient($clientId,$cur);
            
            //Check the currency match
            
            if($model->account->cur == $cur){
            
            //recording the bulk first
            $bulkmodel= new Billbulkpayments();
            $bulkmodel->userId=\Yii::$app->user->getId();
            $bulkmodel->company=\Yii::$app->session->get('company');
            $bulkmodel->date=date('Y-m-d',strtotime($model->date));
            $bulkmodel->accountId=$model->accountId;
            $bulkmodel->amount=$model->amount;
            $bulkmodel->checkNo=$model->checkNo;
            $bulkmodel->clientId=$model->clientId;
            
            if($bulkmodel->save()){
                
            }else{
               \Yii::$app->session->setFlash('error','Couldnot save bulk model');
                return $this->redirect(['billpayments/createsuppliers']);  
            }
            
            for($j=0; $j<count($clientunpaidbills); $j++){
            
            $id=$clientunpaidbills[$j];
            $modelsave = new Billpayments();
            $modelsave->userId=\Yii::$app->user->getId();
            $modelsave->company=\Yii::$app->session->get('company');
            $modelsave->billId=$id;
            $modelsave->accountId=$model->accountId;
            $modelsave->date=date('Y-m-d',strtotime($model->date));
            $modelsave->checkNo=$model->checkNo;
            $unpaidamount=Billcontent::getBillCost($id)-Billpayments::getPaidByBill($id);
            if($unpaidamount==0){
               
                $bill=Bills::findOne($id);
                $bill->paid=1;
                $bill->save();
            }elseif ($unpaidamount>=$initialamount && $initialamount>0 && $unpaidamount>0){
                $modelsave->amount= $initialamount;
            if($modelsave->save()){
                $unpaid2=Billcontent::getBillCost($id)-Billpayments::getPaidByBill($id);
                if($unpaid2==0){
                $bill=Bills::findOne($id);
                $bill->paid=1;
                $bill->save();
                }
                $count++;
                $initialamount=$initialamount-$model->amount;
            }else{
                \Yii::$app->session->setFlash('error','Error on saving 2 '.$count.' bills'); 
            }
            
            
                
            }elseif($unpaidamount<$initialamount && $initialamount>0 && $unpaidamount>0){
            
             $modelsave->amount=$unpaidamount;  
             
            if($modelsave->save()){
           
                 $unpaid2=Billcontent::getBillCost($id)-Billpayments::getPaidByBill($id);
                if($unpaid2==0){
                $bill=Bills::findOne($id);
                $bill->paid=1;
                $bill->save();
                }
                $count++;
                $initialamount=$initialamount-$modelsave->amount;
            }else{
                 \Yii::$app->session->setFlash('error','Error on saving 2 '.$clientId.' bills');
            }
            
                }
            }
            
           \Yii::$app->session->setFlash('success','Successfull executed '.$count.' bills');
                return $this->redirect(['billpayments/createsuppliers']);
            
            }else{
                 \Yii::$app->session->setFlash('error','Currency mis-matching');
                return $this->redirect(['billpayments/createsuppliers']);
            }
        
        
        }
        
        
        /*
        $from='2018-01-01';
        $to='2021-11-15';
        
        $bls= Bills::find()->where("date >= '$from' and date <= '$to' and paid=:c",[':c'=>0])->all();
        $hesabu=count($bls);
       
        if ($bls != null){
            foreach ($bls as $bl){
                $cst=Billcontent::getBillCost($bl->id);
                if ($cst>0){
                $bpy=new Billpayments();
                $bpy->accountId=32;
                $bpy->amount=$cst;
                $bpy->checkNo='0';
                $bpy->billId=$bl->id;
                $bpy->date=date('Y-m-d');
                $bpy->company=$bl->company;
                $bpy->userId=\Yii::$app->user->getId();
                
                if ($bpy->save()){
                    $bb= Bills::findOne($bl->id);
                    $bb->paid=1;
                    $bb->save();
                    \Yii::$app->session->setFlash('success','BILL UPDATED AND UNPAID PAID');
                }else{
                    \Yii::$app->session->setFlash('error','COULDNT UPDATE BILL AND WAS NOT SAVED');
                }
                }
            }
        }else{
            \Yii::$app->session->setFlash('error','NO UNPAID BILLS');
        }    */
        

        return $this->render('createsuppliers', [
            'model' => $model,
        ]);
    }



    /**
     * Updates an existing Billpayments model.
     * If update is successful, the browser will be redirected to the 'view' page.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionUpdate($id)
    {
        $model = $this->findModel($id);

        if ($model->load(Yii::$app->request->post()) && $model->save()) {
            return $this->redirect(['create', 'id' => $model->billId]);
        }

        return $this->render('update', [
            'model' => $model,
        ]);
    }

    /**
     * Deletes an existing Billpayments model.
     * If deletion is successful, the browser will be redirected to the 'index' page.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionDelete($id)
    {
        $billId=Billpayments::findOne($id)->billId;
        
        if($this->findModel($id)->delete()){
            $bill= Bills::findOne($billId);
            $bill->paid=0;
            $bill->save();
        }
        
        return $this->redirect(['bills/update','id'=>$billId]);
    }
    /**
     * Finds the Billpayments model based on its primary key value.
     * If the model is not found, a 404 HTTP exception will be thrown.
     * @param integer $id
     * @return Billpayments the loaded model
     * @throws NotFoundHttpException if the model cannot be found
     */
    protected function findModel($id)
    {
        if (($model = Billpayments::findOne($id)) !== null) {
            return $model;
        }

        throw new NotFoundHttpException('The requested page does not exist.');
    }
}