<?php

namespace app\controllers;

use Yii;
use Behat\Gherkin\Exception\Exception;
use app\models\Billcontent;
use app\models\BillcontentSearch;
use yii\web\Controller;
use yii\web\NotFoundHttpException;
use yii\filters\VerbFilter;
use yii\data\ActiveDataProvider;
use app\models\Cfile;
use app\models\Packages;
use app\models\Servicecost;
use app\models\Bills;
use app\models\Services;
use app\models\Accounts;
use kartik\mpdf\Pdf;
use app\models\Wstore;
use app\models\Model;

/**
 * BillcontentController implements the CRUD actions for Billcontent model.
 */
class BillcontentController extends Controller
{
   
       public function init() {
        
        if (\Yii::$app->session->get('layout') != null){
            $this->layout = \Yii::$app->session->get('layout');
        }else{
            $this->layout ='accounts';
        }
    }
    /**
     * {@inheritdoc}
     */
    public function behaviors()
    {
        return [
            'verbs' => [
                'class' => VerbFilter::className(),
                'actions' => [
                    'delete' => ['POST'],
                ],
            ],
        ];
    }

    /**
     * Lists all Billcontent models.
     * @return mixed
     */
    public function actionIndex()
    {
        $searchModel = new BillcontentSearch();
        $dataProvider = $searchModel->search(Yii::$app->request->queryParams);

        return $this->render('index', [
            'searchModel' => $searchModel,
            'dataProvider' => $dataProvider,
        ]);
    }

    /**
     * Displays a single Billcontent model.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionView($id)
    {
        return $this->render('view', [
            'model' => $this->findModel($id),
        ]);
    }

    /**
     * Creates a new Billcontent model.
     * If creation is successful, the browser will be redirected to the 'view' page.
     * @return mixed
     */
        
        public function actionCreate($id)
    {
        $fileId= \Yii::$app->session->get('fileId');
        if ($fileId != 0) $this->layout='cnf';
        
        $query = Billcontent::find();
        $query->andFilterWhere([
            'billId' => $id,
        ]);
        
        // add conditions that should always apply here
        
        $dataProvider = new ActiveDataProvider([
            'query' => $query,
        ]);
        
        $models = [new Billcontent()];
        
        
        
        if (isset($_POST['Billcontent'])) {
            
            $models = Model::createMultiple(Billcontent::classname());
            Model::loadMultiple($models, Yii::$app->request->post());
            
            $valid = Model::validateMultiple($models);
           
                $transaction = \Yii::$app->db->beginTransaction();
                
                try {
                    foreach ($models as $model) {
                        $model->billId=$id;
                        $valid=$model->validate();
                        $contId=Billcontent::checkServiceInBill($model->serviceId,$id,$model->carId);
                        
                        if ($valid && $contId==null && Bills::findOne($id)->currency==Services::findOne($model->serviceId)->currency){
                            if (! ($flag = $model->save(false))) {
                                $transaction->rollBack();
                                break;
                            }
                        }else{
                            \Yii::$app->session->setFlash('error','Mis-matching currency,or problems in the fields');
                            $transaction->rollBack();
                            break;
                        }
                    }
                    
                    if ($flag) {
                        
                        $updatebill= Bills::findOne($id);
                        $updatebill->status=1;
                        $updatebill->save();
                        
                        $transaction->commit();
                        return $this->redirect(['create', 'id' => $id]);
                    }
                } catch (Exception $e) {
                    $transaction->rollBack();
                }
        } 

        return $this->render('create', [
            'models' =>(empty($models)) ? [new Billcontent] : $models,'dataProvider'=>$dataProvider,'id'=>$id,
        ]);
    }
        
        
    
    public function actionCreateworkshop($id)
    {
        $this->layout='workshop';
        \Yii::$app->session->set('location', 'workshop');
        
        $query = Billcontent::find();
        $query->andFilterWhere([
            'billId' => $id,
        ]);
        
        // add conditions that should always apply here
        
        $dataProvider = new ActiveDataProvider([
            'query' => $query,
        ]);
        
        $models = [new Billcontent()];
        
        if (isset($_POST['Billcontent'])) {
            
            $models = Model::createMultiple(Billcontent::classname());
            Model::loadMultiple($models, Yii::$app->request->post());
            
            $valid = Model::validateMultiple($models);
            
            $transaction = \Yii::$app->db->beginTransaction();
            
            try {
                foreach ($models as $model) {
                    $model->billId=$id;
                    $valid=$model->validate();
                    $contId=Billcontent::checkServiceInBill($model->serviceId,$id,$model->carId);
                    
                    if ($valid && $contId==null && Bills::findOne($id)->currency==Services::findOne($model->serviceId)->currency){
                        if (! ($flag = $model->save(false))) {
                            $transaction->rollBack();
                            break;
                        }else{
                           /* $wstore= new Wstore();
                            $wstore->billId=$id;
                            $wstore->serviceId=$model->serviceId;
                            $wstore->quantity=$model->count;
                            $wstore->date=date('Y-m-d');
                            $wstore->byy=\Yii::$app->user->getId();
                            $wstore->onn=date('Y-m-d');
                            $wstore->status=2;
                            
                            $wstore->save();  */
                        }
                    }else{
                        \Yii::$app->session->setFlash('error','Mis-matching currency,or dublicate service added');
                        $transaction->rollBack();
                        break;
                    }
                }
                
                if ($flag) {
                    
                    $updatebill= Bills::findOne($id);
                    $updatebill->status=1;
                    $updatebill->save();
                    
                    $transaction->commit();
                    return $this->redirect(['createworkshop', 'id' => $id]);
                }
            } catch (Exception $e) {
                $transaction->rollBack();
            }
            
       
        }
        
        return $this->render('createworkshop', [
            'models' =>(empty($models)) ? [new Billcontent] : $models,'dataProvider'=>$dataProvider,'id'=>$id,
        ]);
    }
    
    
    
    public function actionCreaterfq($id)
    {
        $this->layout='workshop';
        \Yii::$app->session->set('location', 'rfq');
        
        $query = Billcontent::find();
        $query->andFilterWhere([
            'billId' => $id,
        ]);
        
        // add conditions that should always apply here
        
        $dataProvider = new ActiveDataProvider([
            'query' => $query,
        ]);
        
        $models = [new Billcontent()];
        
        if (isset($_POST['Billcontent'])) {
            
            $models = Model::createMultiple(Billcontent::classname());
            Model::loadMultiple($models, Yii::$app->request->post());
            
            $valid = Model::validateMultiple($models);
            
            $transaction = \Yii::$app->db->beginTransaction();
            
            try {
                foreach ($models as $model) {
                    $model->billId=$id;
                    $model->amount=0;
                    $valid=$model->validate();
                    $contId=Billcontent::checkServiceInBill($model->serviceId,$id,$model->carId);
                    
                    if ($valid && $contId==null && Bills::findOne($id)->currency==Services::findOne($model->serviceId)->currency){
                        if (! ($flag = $model->save(false))) {
                            $transaction->rollBack();
                            break;
                        }
                    }else{
                        \Yii::$app->session->setFlash('error','Mis-matching currency,or dublicate service added');
                        $transaction->rollBack();
                        break;
                    }
                }
                
                if ($flag) {
                    $transaction->commit();
                    return $this->redirect(['createworkshop', 'id' => $id]);
                }
            } catch (Exception $e) {
                $transaction->rollBack();
            }
        }
        
        return $this->render('createrfq', [
            'models' =>(empty($models)) ? [new Billcontent] : $models,'dataProvider'=>$dataProvider,'id'=>$id,
        ]);
    }
    
    
      
    public function actionCreateclearing($id)
    {
        $this->layout='cnf';
        \Yii::$app->session->set('location', 'clear');
        
        $query = Billcontent::find();
        $query->andFilterWhere([
            'billId' => $id,
        ]);
        
        // add conditions that should always apply here
        
        $dataProvider = new ActiveDataProvider([
            'query' => $query,
        ]);
        
        $models = [new Billcontent()];
        
        
        if (isset($_POST['Billcontent'])) {
            
            $models = Model::createMultiple(Billcontent::classname());
            Model::loadMultiple($models, Yii::$app->request->post());
            
            $valid = Model::validateMultiple($models);
            
            $transaction = \Yii::$app->db->beginTransaction();
            
            try {
                foreach ($models as $model) {
                    $model->billId=$id;
                    $valid=$model->validate();
                    $contId=Billcontent::checkServiceInBill($model->serviceId,$id,$model->carId);
                    
                    if ($valid && Bills::findOne($id)->currency==Services::findOne($model->serviceId)->currency){
                        
                        if ($contId==null){
                        
                            if (! ($flag = $model->save(false))) {
                                $transaction->rollBack();
                                break;
                            }
                            
                        }else{
                            $transaction->rollBack();
                            \Yii::$app->session->setFlash('error','The services has been billed already');
                            return $this->redirect(['billcontent/createclearing','id'=>Billcontent::findOne($contId)->billId]);
                            break;
                        }
                        
                    }else{
                        \Yii::$app->session->setFlash('error','Mis-matching currency,or dublicate service added');
                        $transaction->rollBack();
                        break;
                    }
                }
                
                if ($flag) {
                    $updatebill= Bills::findOne($id);
                    $updatebill->status=1;
                    $updatebill->save();
                    
                    $transaction->commit();
                    return $this->redirect(['billpayments/create','id'=>$id]);
                }
            } catch (Exception $e) {
                $transaction->rollBack();
            }
        }
            
            return $this->render('createclearing', [
                'models' =>(empty($models)) ? [new Billcontent] : $models,'dataProvider'=>$dataProvider,'id'=>$id,
            ]);
    }
    
    public function actionCostcreate() {
        Yii::$app->response->format = \yii\web\Response::FORMAT_JSON;
        if (isset($_POST['depdrop_parents'])) {
            $parents = $_POST['depdrop_parents'];
            if ($parents != null) {
                $cat_id = $_POST['depdrop_parents'];
                $out =[['id'=>Servicecost::getServiceCost($cat_id)->purchasecost, 'name'=>number_format(Servicecost::getServiceCost($cat_id)->purchasecost)]];
                return ['output'=>$out, 'selected'=>''];
            }
        }
        return ['output'=>'', 'selected'=>''];
    }

    /**
     * Updates an existing Billcontent model.
     * If update is successful, the browser will be redirected to the 'view' page.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionUpdate($id)
    {  
        
        $model = $this->findModel($id);
        
        $query = Billcontent::find();
        $query->andFilterWhere([
            'billId' => $model->billId,
        ]);
        
        $query->andFilterWhere(['!=', 'id', $id,]);
        
        $dataProvider = new ActiveDataProvider([
            'query' => $query,
        ]);
        

        if ($model->load(Yii::$app->request->post())) {
            
            if($model->save()){
                $loc=\Yii::$app->session->get('location');
                if ($loc=='clear'){
                return $this->redirect(['createclearing', 'id' => $model->billId]);
                }elseif($loc=='workshop'){
                return $this->redirect(['createworkshop', 'id' => $model->billId]);
                }else{
                return $this->redirect(['create', 'id' => $model->billId]);
                }
            }
        }

                if (Bills::findOne($model->billId)->status==0){
        
            return $this->render('update', [
                'model' => $model,'dataProvider'=>$dataProvider,
            ]);
        }else{
            \Yii::$app->session->setFlash('error','Bill is locked, you can not edit, contact administrator');
            return $this->redirect(['create', 'id' => $model->billId]);
        }
    }
    
    
    public function actionUpdateworkshop($id)
    {
        
        $model = $this->findModel($id);
        
        $query = Billcontent::find();
        $query->andFilterWhere([
            'billId' => $model->billId,
        ]);
        
        $query->andFilterWhere(['!=', 'id', $id,]);
        
        $dataProvider = new ActiveDataProvider([
            'query' => $query,
        ]);
        
        
        if ($model->load(Yii::$app->request->post())) {
            
            if($model->save()){
                $loc=\Yii::$app->session->get('location');
                if ($loc=='clear'){
                    return $this->redirect(['createclearing', 'id' => $model->billId]);
                }elseif($loc=='workshop'){
                    return $this->redirect(['createworkshop', 'id' => $model->billId]);
                }else{
                    return $this->redirect(['create', 'id' => $model->billId]);
                }
            }
        }
        
        if (Bills::findOne($model->billId)->status==0){
            
            return $this->render('updateworkshop', [
                'model' => $model,'dataProvider'=>$dataProvider,
            ]);
        }else{
            \Yii::$app->session->setFlash('error','Bill is locked, you can not edit, contact administrator');
            return $this->redirect(['createworkshop', 'id' => $model->billId]);
        }
    }

    /**
     * Deletes an existing Billcontent model.
     * If deletion is successful, the browser will be redirected to the 'index' page.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionDelete($id)
    {
        $billId=Billcontent::findOne($id)->billId;
        
            if (Bills::findOne($billId)->status==0){
            $this->findModel($id)->delete();
        }else{
            \Yii::$app->session->setFlash('error','Bill is locked, you can not edit, contact administrator');
        }

        $loc=\Yii::$app->session->get('location');
        if ($loc=='clear'){
        return $this->redirect(['createclearing','id'=>$billId]);
        }elseif ($loc=='rfq'){
       	return $this->redirect(['createrfq','id'=>$billId]);
        }elseif($loc=='workshop'){
         return $this->redirect(['createworkshop', 'id' => $model->billId]);
        }else{
         return $this->redirect(['create','id'=>$billId]);
        }
    }

    /**
     * Finds the Billcontent model based on its primary key value.
     * If the model is not found, a 404 HTTP exception will be thrown.
     * @param integer $id
     * @return Billcontent the loaded model
     * @throws NotFoundHttpException if the model cannot be found
     */
    protected function findModel($id)
    {
        if (($model = Billcontent::findOne($id)) !== null) {
            return $model;
        }

        throw new NotFoundHttpException('The requested page does not exist.');
    }
    
 
    
    public function actionPrintrequest($id) {
        
        $model= Bills::findOne($id);
        $contents=Billcontent::find()->where(['billId'=>$id])->all();
        $data = $this->renderPartial('_requestview',['model'=>$model,'contents'=>$contents]);
        
        $pdf = new Pdf([
            'mode' => Pdf::MODE_CORE,
            'format' => Pdf::FORMAT_A4,
            'orientation' => Pdf::ORIENT_PORTRAIT,
            'destination' => Pdf::DEST_BROWSER,
            'content' => $data,
            'cssFile' => '@vendor/kartik-v/yii2-mpdf/src/assets/kv-mpdf-bootstrap.min.css',
            'cssInline' => '.kv-heading-1{font-size:18px}',
            'options' => ['title' => 'Bills request'],
            'methods' => [
                'SetHeader'=>[''],
                'SetFooter'=>['{PAGENO}'],
            ]
        ]);
        
        return $pdf->render();
    }
    
    public function actionPrintrequestforquote($id) {
        
        $model= Bills::findOne($id);
        $contents=Billcontent::find()->where(['billId'=>$id])->all();
        $data = $this->renderPartial('_requestforquoteview',['model'=>$model,'contents'=>$contents]);
        
        $pdf = new Pdf([
            'mode' => Pdf::MODE_CORE,
            'format' => Pdf::FORMAT_A4,
            'orientation' => Pdf::ORIENT_PORTRAIT,
            'destination' => Pdf::DEST_BROWSER,
            'content' => $data,
            'cssFile' => '@vendor/kartik-v/yii2-mpdf/src/assets/kv-mpdf-bootstrap.min.css',
            'cssInline' => '.kv-heading-1{font-size:18px}',
            'options' => ['title' => 'Bills request'],
            'methods' => [
                'SetHeader'=>[''],
                'SetFooter'=>['{PAGENO}'],
            ]
        ]);
        
        return $pdf->render();
    }
    
    
        public function actionPrintlpo($id) {
        
        $model= Bills::findOne($id);
        $contents=Billcontent::find()->where(['billId'=>$id])->all();
        $data = $this->renderPartial('_lpo',['model'=>$model,'contents'=>$contents]);
        
        $pdf = new Pdf([
            'mode' => Pdf::MODE_CORE,
            'format' => Pdf::FORMAT_A4,
            'orientation' => Pdf::ORIENT_PORTRAIT,
            'destination' => Pdf::DEST_BROWSER,
            'content' => $data,
            'cssFile' => '@vendor/kartik-v/yii2-mpdf/src/assets/kv-mpdf-bootstrap.min.css',
            'cssInline' => '.kv-heading-1{font-size:18px}',
            'options' => ['title' => 'Bills request'],
            'methods' => [
                'SetHeader'=>[''],
                'SetFooter'=>['{PAGENO}'],
            ]
        ]);
        
        return $pdf->render();
    }
    
    public function actionGetPrice($selected)
    {
        $service= Servicecost::find()->where(['serviceId'=>$selected,'status'=>1])->one();
        
        echo json_encode($service->purchasecost);
    }
}