<?php

namespace app\controllers;

use Yii;
use app\models\Accounts;
use app\models\AccountsSearch;
use app\models\Accountstype;
use app\models\Billcontent;
use app\models\Bills;
use app\models\Cars;
use yii\web\Controller;
use yii\web\NotFoundHttpException;
use yii\filters\VerbFilter;
use kartik\mpdf\Pdf;
use yii2tech\spreadsheet\Spreadsheet;
use yii\data\ArrayDataProvider;
use app\models\Wshopbills;

/**
 * AccountsController implements the CRUD actions for Accounts model.
 */
class AccountsController extends Controller
{
    
       public function init() {
        
        if (\Yii::$app->session->get('layout') != null){
            $this->layout = \Yii::$app->session->get('layout');
        }else{
            $this->layout ='accounts';
        }
        
    }
    /**
     * {@inheritdoc}
     */
    public function behaviors()
    {
        return [
            'verbs' => [
                'class' => VerbFilter::className(),
                'actions' => [
                    'delete' => ['POST'],
                ],
            ],
        ];
    }

    /**
     * Lists all Accounts models.
     * @return mixed
     */
    public function actionIndex()
    {
        $searchModel = new AccountsSearch();
        $dataProvider = $searchModel->search(Yii::$app->request->queryParams);

        return $this->render('index', [
            'searchModel' => $searchModel,
            'dataProvider' => $dataProvider,
        ]);
    }

    /**
     * Displays a single Accounts model.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionView($id)
    {
        return $this->render('view', [
            'model' => $this->findModel($id),
        ]);
    }

    /**
     * Creates a new Accounts model.
     * If creation is successful, the browser will be redirected to the 'view' page.
     * @return mixed
     */
    public function actionCreate($id)
    {
        $model = new Accounts();

        if ($model->load(Yii::$app->request->post())) {
            
            $model->date=date('Y-m-d');
            $model->company=\Yii::$app->session->get('company');
            $model->type=$id;
            $model->tin=$model->tin;
            $model->vrn=$model->vrn;
            
            if($model->save()){
                \Yii::$app->session->setFlash('success','Successfull saved new account');
            return $this->redirect(['index']);
            }
        }

        if (\Yii::$app->request->isAjax){
            return $this->renderAjax('create', [
                'model' => $model,
            ]);
        }else{
            return $this->render('create', [
                'model' => $model,'id'=>$id,
            ]);
        }
    }

    /**
     * Updates an existing Accounts model.
     * If update is successful, the browser will be redirected to the 'view' page.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionUpdate($id)
    {
        $model = $this->findModel($id);

        if ($model->load(Yii::$app->request->post())) {
            $model->date=date('Y-m-d');
            
            if($model->save()){
            return $this->redirect(['index']);
            }
        }

        return $this->render('update', [
            'model' => $model,
        ]);
    }

    /**
     * Deletes an existing Accounts model.
     * If deletion is successful, the browser will be redirected to the 'index' page.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionDelete($id)
    {
        $this->findModel($id)->delete();

        return $this->redirect(['index']);
    }

    /**
     * Finds the Accounts model based on its primary key value.
     * If the model is not found, a 404 HTTP exception will be thrown.
     * @param integer $id
     * @return Accounts the loaded model
     * @throws NotFoundHttpException if the model cannot be found
     */
    protected function findModel($id)
    {
        if (($model = Accounts::findOne($id)) !== null) {
            return $model;
        }

        throw new NotFoundHttpException('The requested page does not exist.');
    }
    
    
    public function actionPnl()
    {
        $this->layout='accounts';
        $model = new Accounts();
        
        if (isset($_POST['Accounts'])) {
            
            if($_POST['Accounts']['to'] >= $_POST['Accounts']['from']){
                
                $data = $this->renderPartial('_pnlview',['from'=>$_POST['Accounts']['from'],'to'=>$_POST['Accounts']['to']]);
                
                $pdf = new Pdf([
                    'mode' => Pdf::MODE_CORE,
                    'format' => Pdf::FORMAT_A4,
                    'orientation' => Pdf::ORIENT_PORTRAIT,
                    'destination' => Pdf::DEST_BROWSER,
                    'content' => $data,
                    'cssFile' => '@vendor/kartik-v/yii2-mpdf/src/assets/kv-mpdf-bootstrap.min.css',
                    'cssInline' => '.kv-heading-1{font-size:18px}',
                    'options' => ['title' => 'profit and loss report'],
                    'methods' => [
                        'SetFooter'=>['{PAGENO}'],
                    ]
                ]);
                
                return $pdf->render();
            }else{
                \Yii::$app->session->setFlash('error','From can not be greater than to');
            }
        }
        
        return $this->render('pnl', [
            'model' => $model,
        ]);
    }
    
    
    public function actionExpensereportPdf()
    {
        $this->layout='accounts';
        $model = new Accounts();
        
        if (isset($_POST['Accounts'])) {
            
            if($_POST['Accounts']['to'] >= $_POST['Accounts']['from']){
                
                $data = $this->renderPartial('_expenseview',['from'=>$_POST['Accounts']['from'],'to'=>$_POST['Accounts']['to']]);
                
                $pdf = new Pdf([
                    'mode' => Pdf::MODE_CORE,
                    'format' => Pdf::FORMAT_A4,
                    'orientation' => Pdf::ORIENT_PORTRAIT,
                    'destination' => Pdf::DEST_BROWSER,
                    'content' => $data,
                    'cssFile' => '@vendor/kartik-v/yii2-mpdf/src/assets/kv-mpdf-bootstrap.min.css',
                    'cssInline' => '.kv-heading-1{font-size:18px}',
                    'options' => ['title' => 'expense report'],
                    'methods' => [
                        'SetFooter'=>['{PAGENO}'],
                    ]
                ]);
                
                return $pdf->render();
            }else{
                \Yii::$app->session->setFlash('error','From can not be greater than to');
            }
        }
        
        return $this->render('expense', [
            'model' => $model,
        ]);
    }
    
    
      public function actionExpensereport(){
        
        $this->layout='accounts';
        $model = new Accounts();
        
        $allexpenses=null;
        $allusdexpenses=null;
        $cnt=0;
        
        if (isset($_POST['Accounts'])) {
            
            if($_POST['Accounts']['to'] >= $_POST['Accounts']['from']){
                
                $f=date('Y-m-d',strtotime($_POST['Accounts']['from']));
                $t=date('Y-m-d',strtotime($_POST['Accounts']['to']));
                $cnt=0;
                $totalTsh=0;
                $totalUsd=0;
                
                $expenses= Accountstype::find()->where(['category'=>4])->all();
                if ( $expenses != null){
                    foreach ($expenses as $expense){
                        
                        $accNames= Accounts::getAccountsByType($expense->id);
                        
                        if($accNames != null){
                            foreach ($accNames as $accN){
                                $bills=Bills::find()->where("date >= '$f' and date <= '$t' and company=:c and currency=:kr and paid=:pd", [':kr'=>1,':pd'=>1,':c'=>\Yii::$app->session->get('company')])->all();
                                
                                if ($bills != null){
                                    foreach ($bills as $bill){
                                        $billcontents= Billcontent::find()->where("billId=:bId and accId=:ac",[':ac'=>$accN->id,':bId'=>$bill->id])->all();
                                        if ($billcontents != null){
                                            foreach ($billcontents as $billcontent){ 
                                                $allexpenses[$cnt]['product']=$billcontent->service->name;
                                                $allexpenses[$cnt]['car']=$billcontent->carId;
                                                $allexpenses[$cnt]['price']=$billcontent->amount;
                                                $allexpenses[$cnt]['quantity']=$billcontent->count;
                                                $allexpenses[$cnt]['total']=$billcontent->count*$billcontent->amount;
                                                $allexpenses[$cnt]['account']=$accN->name;
                                                $cnt++;
                                                        }
                                                    } 
                                                }
                                            }
                                        }
                                    }
                                }
                            } 
                            
                            
                            $liabilities= Accountstype::find()->where(['category'=>5])->all();
                            if ( $liabilities != null){
                                foreach ($liabilities as $liability){
                                    
                                    $accNames= Accounts::getAccountsByType($liability->id);
                                    
                                    if($accNames != null){
                                        foreach ($accNames as $accN){
                                            $bills=Bills::find()->where("date >= '$f' and date <= '$t' and company=:c and currency=:kr and paid=:pd", [':kr'=>1,':pd'=>1,':c'=>\Yii::$app->session->get('company')])->all();
                                            
                                            if ($bills != null){
                                                foreach ($bills as $bill){
                                                    $billcontents= Billcontent::find()->where("billId=:bId and accId=:ac",[':bId'=>$bill->id,':ac'=>$accN->id])->all();
                                                    if ($billcontents != null){
                                                        foreach ($billcontents as $billcontent){
                                                            $allexpenses[$cnt]['product']=$billcontent->service->name;
                                                            $allexpenses[$cnt]['car']=$billcontent->carId;
                                                            $allexpenses[$cnt]['price']=$billcontent->amount;
                                                            $allexpenses[$cnt]['quantity']=$billcontent->count;
                                                            $allexpenses[$cnt]['total']=$billcontent->count*$billcontent->amount;
                                                            $allexpenses[$cnt]['account']=$accN->name;
                                                            $cnt++;
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                            
                            $ccc=0;
                            $expenses2= Accountstype::find()->where(['category'=>4])->all();
                            if ( $expenses2 != null){
                                foreach ($expenses2 as $expense){
                                    
                                    $accNames= Accounts::getAccountsByType($expense->id);
                                    
                                    if($accNames != null){
                                        foreach ($accNames as $accN){
                                            $bills=Bills::find()->where("date >= '$f' and date <= '$t' and company=:c and currency=:kr and paid=:pd", [':kr'=>2,':pd'=>1,':c'=>\Yii::$app->session->get('company')])->all();
                                            
                                            if ($bills != null){
                                                foreach ($bills as $bill){
                                                    $billcontents= Billcontent::find()->where("billId=:bId and accId=:ac",[':bId'=>$bill->id,':ac'=>$accN->id])->all();
                                                    if ($billcontents != null){
                                                        foreach ($billcontents as $billcontent){
                                                            $allusdexpenses[$ccc]['product']=$billcontent->service->name;
                                                            $allusdexpenses[$ccc]['car']=$billcontent->carId;
                                                            $allusdexpenses[$ccc]['price']=$billcontent->amount;
                                                            $allusdexpenses[$ccc]['quantity']=$billcontent->count;
                                                            $allusdexpenses[$ccc]['total']=$billcontent->count*$billcontent->amount;
                                                            $allusdexpenses[$ccc]['account']=$accN->name;
                                                            $ccc++;
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                            
                            
                            
                            
                            $liabilities2= Accountstype::find()->where(['category'=>5])->all();
                            if ( $liabilities2 != null){
                                foreach ($liabilities2 as $liability){
                                    
                                    $accNames= Accounts::getAccountsByType($liability->id);
                                    
                                    if($accNames != null){
                                        foreach ($accNames as $accN){
                                            $bills=Bills::find()->where("date >= '$f' and date <= '$t' and company=:c and currency=:kr and paid=:pd", [':kr'=>1,':pd'=>2,':c'=>\Yii::$app->session->get('company')])->all();
                                            
                                            if ($bills != null){
                                                foreach ($bills as $bill){
                                                    $billcontents= Billcontent::find()->where("billId=:bId and accId=:ac",[':ac'=>$accN->id,':bId'=>$bill->id])->all();
                                                    if ($billcontents != null){
                                                        foreach ($billcontents as $billcontent){
                                                            $allusdexpenses[$ccc]['product']=$billcontent->service->name;
                                                            $allusdexpenses[$ccc]['car']=$billcontent->carId;
                                                            $allusdexpenses[$ccc]['price']=$billcontent->amount;
                                                            $allusdexpenses[$ccc]['quantity']=$billcontent->count;
                                                            $allusdexpenses[$ccc]['total']=$billcontent->count*$billcontent->amount;
                                                            $allusdexpenses[$ccc]['account']=$accN->name;
                                                            $ccc++;
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                            
                            
            }else{
                \Yii::$app->session->setFlash('error','From can not be greater than to');
            }
            
            $exporter = (new Spreadsheet([
                'title' => 'Tsh expenses',
                'dataProvider' => new ArrayDataProvider([
                    'allModels' => $allexpenses
                ]),
                
                'columns' => [
                    [
                        'attribute' => 'product',
                        'contentOptions' => [
                            'width' => [
                                '35px'
                            ],
                        ],
                    ],
                    [
                        'attribute' => 'car',
                    ],
                    [
                        'attribute' => 'price',
                    ],
                    [
                        'attribute' => 'quantity',
                    ],
                    [
                        'attribute' => 'total',
                    ],
                    [
                        'attribute' => 'account',
                    ],
                ],
            ]))->render();
            
            
            $exporter->configure([ // update spreadsheet configuration
                'title' => 'Usd expenses',
                'dataProvider' => new ArrayDataProvider([
                    'allModels' =>$allusdexpenses
                ]),
                
                'columns' => [
                    [
                        'attribute' => 'product',
                        'contentOptions' => [
                            'width' => [
                                '35px'
                            ],
                        ],
                    ],
                    [
                        'attribute' => 'car',
                    ],
                    [
                        'attribute' => 'price',
                    ],
                    [
                        'attribute' => 'quantity',
                    ],
                    [
                        'attribute' => 'total',
                    ],
                    [
                        'attribute' => 'account',
                    ],
                ],
                
            ])->render();
            
            return $exporter->send('expenses.xls');
            
        }
        
        return $this->render('expense', [
            'model' => $model,
        ]);
    }
    
    
        
 public function actionWorkshopexpense(){
        
        $this->layout='accounts';
        $model = new Accounts();
        
        $allexpenses=null;
        $allusdexpenses=null;
        $cnt=0;
        
        if (isset($_POST['Accounts'])) {
            
            if($_POST['Accounts']['to'] >= $_POST['Accounts']['from']){
                
                $f=date('Y-m-d',strtotime($_POST['Accounts']['from']));
                $t=date('Y-m-d',strtotime($_POST['Accounts']['to']));
                $cnt=0;
                $totalTsh=0;
                $totalUsd=0;
              
           
                                $bills=Bills::getBillsIdByDates($f,$t,1);
                                $wbills=Wshopbills::find()->where(['billid'=>$bills])->all();
                                if ($wbills != null){
                                    foreach ($wbills as $bill){
                                        $billcontents= Billcontent::find()->where("billId=:bId",[':bId'=>$bill->billid])->all();
                                            if ($billcontents != null){
                                                foreach ($billcontents as $billcontent){
                                                    $allexpenses[$cnt]['product']=$billcontent->service->name;
                                                    $allexpenses[$cnt]['car']=$billcontent->carId;
                                                    $allexpenses[$cnt]['type']=Cars::findOne($billcontent->carId)->type->name;
                                                    $allexpenses[$cnt]['price']=$billcontent->amount;
                                                    $allexpenses[$cnt]['quantity']=$billcontent->count;
                                                    $allexpenses[$cnt]['total']=$billcontent->count*$billcontent->amount;
                                                    $allexpenses[$cnt]['account']=Accounts::findOne($billcontent->accId)->name;
                                                    $allexpenses[$cnt]['supplier']=$bill->bill->client->name;
                                                    $allexpenses[$cnt]['date']=$bill->bill->date;
                                                    $cnt++;
                                                }
                                            }
                                    }
                                }
                      
                
                /*
                
                $liabilities= Accountstype::find()->where(['category'=>5])->all();
                if ( $liabilities != null){
                    foreach ($liabilities as $liability){
                        
                        $accNames= Accounts::getAccountsByType($liability->id);
                        
                        if($accNames != null){
                            foreach ($accNames as $accN){
                                $bills=Bills::getBillsIdByDates($f,$t,1);
                                $wbills=Wshopbills::find()->where(['billid'=>$bills])->all();
                                if ($wbills != null){
                                    foreach ($wbills as $bill){
                                        $billcontents= Billcontent::find()->where("billId=:bId and accId=:ac",[':bId'=>$bill->billid,':ac'=>$accN->id])->all();
                                        if ($billcontents != null){
                                            foreach ($billcontents as $billcontent){
                                                $allexpenses[$cnt]['product']=$billcontent->service->name;
                                                $allexpenses[$cnt]['car']=$billcontent->carId;
                                                $allexpenses[$cnt]['price']=$billcontent->amount;
                                                $allexpenses[$cnt]['quantity']=$billcontent->count;
                                                $allexpenses[$cnt]['total']=$billcontent->count*$billcontent->amount;
                                                $allexpenses[$cnt]['account']=$accN->name;
                                                $cnt++;
                                                }
                                            }
                                        }
                                }
                            }
                        }
                    }
                } 
              
                $ccc=0;
                $expenses2= Accountstype::find()->where(['category'=>4])->all();
                if ( $expenses2 != null){
                    foreach ($expenses2 as $expense){
                        
                        $accNames= Accounts::getAccountsByType($expense->id);
                        
                        if($accNames != null){
                            foreach ($accNames as $accN){
                                $bills=Bills::getBillsIdByDates($f,$t,2);
                                $wbills=Wshopbills::find()->where(['billid'=>$bills])->all();
                                if ($wbills != null){
                                    foreach ($wbills as $bill){
                                      $billcontents= Billcontent::find()->where("billId=:bId and accId=:ac",[':bId'=>$bill->billid,':ac'=>$accN->id])->all();
                                        if ($billcontents != null){
                                            foreach ($billcontents as $billcontent){
                                                $allusdexpenses[$ccc]['product']=$billcontent->service->name;
                                                $allusdexpenses[$ccc]['car']=$billcontent->carId;
                                                $allusdexpenses[$ccc]['price']=$billcontent->amount;
                                                $allusdexpenses[$ccc]['quantity']=$billcontent->count;
                                                $allusdexpenses[$ccc]['total']=$billcontent->count*$billcontent->amount;
                                                $allusdexpenses[$ccc]['account']=$accN->name;
                                                $ccc++;
                                                }
                                            }
                                    }
                                }
                            }
                        }
                    }
                }
                
                
              
                
                $liabilities2= Accountstype::find()->where(['category'=>5])->all();
                if ( $liabilities2 != null){
                    foreach ($liabilities2 as $liability){
                        
                        $accNames= Accounts::getAccountsByType($liability->id);
                        
                        if($accNames != null){
                            foreach ($accNames as $accN){
                                $bills=Bills::getBillsIdByDates($f,$t,2);
                                $wbills=Wshopbills::find()->where(['billid'=>$bills])->all();
                                if ($wbills != null){
                                    foreach ($wbills as $bill){
                                        $billcontents= Billcontent::find()->where("billId=:bId and accId=:ac",[':ac'=>$accN->id,':bId'=>$bill->billid])->all();
                                        if ($billcontents != null){
                                            foreach ($billcontents as $billcontent){
                                                $allusdexpenses[$ccc]['product']=$billcontent->service->name;
                                                $allusdexpenses[$ccc]['car']=$billcontent->carId;
                                                $allusdexpenses[$ccc]['price']=$billcontent->amount;
                                                $allusdexpenses[$ccc]['quantity']=$billcontent->count;
                                                $allusdexpenses[$ccc]['total']=$billcontent->count*$billcontent->amount;
                                                $allusdexpenses[$ccc]['account']=$accN->name;
                                                $ccc++;
                                                }
                                            }
                                    }
                                }
                            }
                        }
                    }
                }   */
                
            }else{
                \Yii::$app->session->setFlash('error','From can not be greater than to');
            }
            
            $exporter = (new Spreadsheet([
                'title' => 'Tsh expenses',
                'dataProvider' => new ArrayDataProvider([
                    'allModels' => $allexpenses
                ]),
                
                'columns' => [
                    [
                        'attribute' => 'product',
                        'contentOptions' => [
                            'width' => [
                                '35px'
                            ],
                        ],
                    ],
                    [
                        'attribute' => 'car',
                    ],
                    [
                        'attribute' => 'type',
                    ],
                    [
                        'attribute' => 'price',
                    ],
                    [
                        'attribute' => 'quantity',
                    ],
                    [
                        'attribute' => 'total',
                    ],
                    [
                        'attribute' => 'account',
                    ],
                    [
                        'attribute' => 'supplier',
                    ],
                    [
                        'attribute' => 'date',
                    ],
                ],
            ]))->render();
            
            
            $exporter->configure([ // update spreadsheet configuration
                'title' => 'Usd expenses',
                'dataProvider' => new ArrayDataProvider([
                    'allModels' =>$allusdexpenses
                ]),
                
                'columns' => [
                    [
                        'attribute' => 'product',
                        'contentOptions' => [
                            'width' => [
                                '35px'
                            ],
                        ],
                    ],
                    [
                        'attribute' => 'car',
                    ],
                    [
                        'attribute' => 'price',
                    ],
                    [
                        'attribute' => 'quantity',
                    ],
                    [
                        'attribute' => 'total',
                    ],
                    [
                        'attribute' => 'account',
                    ],
                ],
                
            ])->render();
            
            return $exporter->send('expenses.xls');
            
        }
        
        return $this->render('workshopexpense', [
            'model' => $model,
        ]);
    }
    
    
}