<?php

use app\models\Accounts;
use app\models\Billcontent;
use yii\helpers\Html;
use yii\bootstrap\Modal;
use yii\grid\GridView;

/* @var $this yii\web\View */
/* @var $searchModel app\models\WshopbillsSearch */
/* @var $dataProvider yii\data\ActiveDataProvider */

$this->title = 'Workshop requests';
$this->params['breadcrumbs'][] = $this->title;
?>
<div class="wshopbills-index">

    <h3><?= Html::encode($this->title) ?></h3>
    <?php // echo $this->render('_search', ['model' => $searchModel]); ?>

      <p align="right">
        <?= Html::button('New request',['value'=>\yii\helpers\Url::toRoute('bills/createworkshop'),'class' => 'btn btn-success','id'=>'modalButton']) ?>
      </p>
      
<?php 
        Modal::begin([
            'options'=>[
                'tabindex' => false,
            ],
            'header'=>'',
            'id'=>'modal',
            'size'=>'modal-lg',
        ]);
        
        echo '<div id="modalContent"></div>';
        
        Modal::end();

?>
      

  <?= GridView::widget([
        'dataProvider' => $dataProvider,
        'filterModel' => $searchModel,
        'columns' => [
            ['class' => 'yii\grid\SerialColumn'],
            [
                'attribute'=>'billby',
                'value'=>function ($model, $key, $index, $widget) {return $model->bill->billby0->name; }
            ],
            [
                'attribute'=>'date',
                'value'=>function ($model, $key, $index, $widget) {return date('d-m-Y',strtotime($model->bill->date)); }
            ],
            [
                'attribute'=>'dueDate',
                'value'=>function ($model, $key, $index, $widget) {return date('d-m-Y',strtotime($model->bill->dueDate)); }
            ],
            [
                'attribute'=>'billamount',
                'value'=>function ($model, $key, $index, $widget) {return number_format(Billcontent::getBillCost($model->billid)).' '.Accounts::getCurrency($model->bill->currency); }
            ],
            //'paid',
            //'company',
            //'currency',
            [
                'label'=>' ',
                'format' => 'raw',
                'value'=>function ($model, $key, $index, $widget) {
                return Html::a('',['billcontent/createworkshop','id'=>$model->billid],['class' => 'glyphicon glyphicon-tasks']);
                },
                ],
                
                [
                    'label'=>' ',
                    'format' => 'raw',
                    'value'=>function ($model, $key, $index, $widget) {
                    return Html::a('',['billcontent/printrequest','id'=>$model->billid],['class' => 'glyphicon glyphicon-download-alt']);
                    },
                    ],
                    
                    [
                        'label'=>' ',
                        'format' => 'raw',
                        'value'=>function ($model, $key, $index, $widget) {
                        return Html::a('',['wshopbills/createpayment','id'=>$model->id],[
                            'class' => 'glyphicon glyphicon-check',
                            'data'=>['confirm'=>'Are you sure it is paid','method'=>'post'],
                        ]);
                        },
                        ],
                        
                        [
                            'label'=>' ',
                            'format' => 'raw',
                            'value'=>function ($model, $key, $index, $widget) {
                            return Html::a('',['bills/update','id'=>$model->billid],[
                                'class' => 'glyphicon glyphicon-edit',
                            ]);
                            },
                            ],
            
            
            ['class' => 'yii\grid\ActionColumn',
                'template'=>'{delete}'
            ],
        ],
    ]); ?>
</div>
