<?php

use app\models\Servicecost;
use yii\helpers\Html;
use yii\widgets\DetailView;
use app\models\Accounts;
use app\models\Uzers;

/* @var $this yii\web\View */
/* @var $model app\models\Services */

$this->title ='Profile';
$this->params['breadcrumbs'][] = ['label' => 'Services', 'url' => ['index']];
$this->params['breadcrumbs'][] = $this->title;
\yii\web\YiiAsset::register($this);
?>
<div class="services-view">

    <h3><?= Html::encode($this->title) ?></h3>

    <p align="right">
        <?= Html::a('Deactivate', ['delete', 'id' => $model->id], [
            'class' => 'btn btn-danger',
            'data' => [
                'confirm' => 'Are you sure you want to deactivate this item?',
                'method' => 'post',
            ],
        ]) ?>
    </p>

    <?= DetailView::widget([
        'model' => $model,
        'attributes' => [
            'name',
            'description',
            [
                'attribute'=>'status',
                'value'=>Uzers::getStatus($model->status),
            ],
            [
                'attribute'=>'date',
                'value'=>date('d-m-Y',strtotime($model->date)),
            ],
            [
                'attribute'=>'purchaseaccId',
                'value'=>Accounts::findOne($model->purchaseaccId)==null?' ':Accounts::findOne($model->purchaseaccId)->name,
            ],
            [
                'attribute'=>'purchasecost',
                'value'=>Servicecost::getServiceCost($model->id)->purchasecost,
                ],
            [
                'attribute'=>'saleaccId',
                'value'=>Accounts::findOne($model->saleaccId)==null?' ':Accounts::findOne($model->saleaccId)->name,
            ],
            
            [
                'attribute'=>'saleprice',
                'value'=>Servicecost::getServiceCost($model->id)->saleamount,
                ],
        ],
    ]) ?>

</div>
