<?php

use app\models\Accounts;
use app\models\Invcontent;
use app\models\Invoices;
use app\models\Invopayments;
use yii\helpers\Html;

/* @var $this yii\web\View */
/* @var $model app\models\Invopayments */

$this->title = 'Record payments';
$this->params['breadcrumbs'][] = ['label' => 'Invopayments', 'url' => ['index']];
$this->params['breadcrumbs'][] = $this->title;
?>
<div class="invopayments-create">

    <h3 align="center"><?= Html::encode($this->title) ?></h3>
    
    <p><b>Invoice to:</b><?php echo Invoices::findOne($id)->acc->name; ?> </br><b>Invoice #: </b><?php echo Invoices::getInvoiceNo(Invoices::findOne($id)->type,$id); ?></br> <b>Currency:</b> <?php echo Accounts::getCurrency(Invoices::findOne($id)->currency); ?> </br><b>Date:</b><?php echo date('d-m-Y',strtotime(Invoices::findOne($id)->date));?> 
    </br><b>Invoice Amount:</b><?php echo number_format(Invcontent::getInvoiceCost($id)); ?> </br><b>Paid Amount:</b><?php echo number_format(Invopayments::getInvoicePaidAmount($id)); ?>  </br><b>Balance:</b><?php echo number_format(Invcontent::getInvoiceCost($id)-Invopayments::getInvoicePaidAmount($id));  ?>
    </p>
    
<br/>  <br/>
    <?= $this->render('_form', [
        'model' => $model,
    ]) ?>

</div>
