<?php

use app\models\Accounts;
use yii\helpers\Html;
use yii\bootstrap\Modal;
use yii\grid\GridView;
use app\models\Invoices;
use app\models\Invcontent;
use app\models\Invopayments;

/* @var $this yii\web\View */
/* @var $searchModel app\models\InvoicesSearch */
/* @var $dataProvider yii\data\ActiveDataProvider */

$this->title = 'All pending invoices';
$this->params['breadcrumbs'][] = $this->title;
?>
<div class="invoices-index">

    <h3><?= Html::encode($this->title) ?></h3>
    <?php // echo $this->render('_search', ['model' => $searchModel]); ?>

   <p align="right">
    <?= Html::a('New invoice', ['create'], ['class' => 'btn btn-success']) ?>
      </p>
      
      
              <?php 
Modal::begin([
    'options'=>[
        'tabindex' => false,
    ],
    'header'=>'',
    'id'=>'modal',
    'size'=>'modal-lg',
]);

echo '<div id="modalContent"></div>';

Modal::end();

?>

    <?= GridView::widget([
        'dataProvider' => $dataProvider,
        'filterModel' => $searchModel,
        'columns' => [
            ['class' => 'yii\grid\SerialColumn'],
            [
                'attribute'=>'accId',
                'value'=>function ($model, $key, $index, $widget) {return $model->acc->name; }
          
            ],
            [
                'attribute'=>'Invo #',
                'value'=>function ($model, $key, $index, $widget) {return Invoices::getInvoiceNo(Invoices::findOne($model->id)->type,$model->id); }
            ],
            [
                'attribute'=>'date',
                'value'=>function ($model, $key, $index, $widget) {return date('d-m-Y',strtotime($model->date)); }
            ],
            [
                'attribute'=>'type',
                'value'=>function ($model, $key, $index, $widget) {return Invoices::getInvoiceType($model->type); },
                'contentOptions' => function($model, $key, $index, $column){
                if ($model->type==1){
                    return ['style' =>'background-color:#197777; color:white;'];
                }elseif ($model->type==2){
                    return ['style' =>'background-color:#101CE0; color:white;']; 
                }elseif ($model->type==3){
                    return ['style' =>'background-color:#383FAF; color:white;']; 
                }
                },
            ],
            [
                'attribute'=>'amount',
                'value'=>function ($model, $key, $index, $widget) {return number_format(Invcontent::getInvoiceCost($model->id)).' '.Accounts::getCurrency($model->currency); }
            ],
            [
                'attribute'=>'paida',
                'value'=>function ($model, $key, $index, $widget) {return number_format(Invopayments::getInvoicePaidAmount($model->id)).' '.Accounts::getCurrency($model->currency); }
            ],
            
            [
                'attribute'=>'balance',
                'value'=>function ($model, $key, $index, $widget) {return number_format(Invcontent::getInvoiceCost($model->id)-Invopayments::getInvoicePaidAmount($model->id)).' '.Accounts::getCurrency($model->currency); }
            ],
            //'company',
            //'type',
            //'tax',
            //'currency',

            [
                'label'=>' ',
                'format' => 'raw',
                'value'=>function ($model, $key, $index, $widget) {
                return Html::a('',['invcontent/create','id'=>$model->id],['class' => 'glyphicon glyphicon-tasks']);
                },
                ],
                
                [
                    'label'=>' ',
                    'format' => 'raw',
                    'value'=>function ($model, $key, $index, $widget) {
                    return Html::a('',['invcontent/printinvoice','id'=>$model->id],['class' => 'glyphicon glyphicon-download-alt']);
                    },
                    ],
                    
                    [
                        'label'=>' ',
                        'format' => 'raw',
                        'value'=>function ($model, $key, $index, $widget) {
                        return Html::a('',['invopayments/create','id'=>$model->id],['class' => 'glyphicon glyphicon-check']);
                        },
                        ],
                        
                        ['class' => 'yii\grid\ActionColumn',
                            'template'=>'{update}'
                        ],
                        
                        
                        ['class' => 'yii\grid\ActionColumn',
                            'template'=>'{delete}'
                        ],
        ],
    ]); ?>
</div>
