<?php

use app\models\Accounts;
use kartik\select2\Select2;
use yii\helpers\ArrayHelper;
use yii\helpers\Html;
use yii\widgets\ActiveForm;

/* @var $this yii\web\View */
/* @var $model app\models\Invoices */
/* @var $form yii\widgets\ActiveForm */
?>

<?php $liaAccounts = ArrayHelper:: map (Accounts::find()->where(['type'=>Accounts::getAccountsByCategory(1)])->all() , 'id' , function($model, $defaultValue){ return $model->name; }); ?>

<div class="invoices-form">

     <?php $form = ActiveForm::begin([
        'fieldConfig' => [
            'template' => " <div class='row'><div class='col-xs-11'>{label}{input}{error}{hint}</div></div>",
        ],
    ]); ?>
    
    <table width="100%">
<tr>

 <td> <?= $form->field($model, 'type')->dropdownList([
        1 => 'Invoice', 
        2 => 'Profoma',
        3 => 'Debit note',
    ],
     [
         'style'=>'length:20px',
         'prompt'=>'-select-'
         
     ]
);?></td>
        <td>
        <?php 

echo $form->field($model, 'accId')->widget(Select2::classname(), [
    'data' => $liaAccounts,
    'language' => 'en',
    'options' => ['placeholder' => 'Select account...'],
    'pluginOptions' => [
        'allowClear' => true,
        'tabindex' => false,
    ],
]);

?>
    </td>
      
       <td> <?= $form->field($model, 'currency')->dropdownList([
        1 => 'Tsh', 
        2 => 'Usd',
    ],
     [
         'style'=>'length:20px',
         'prompt'=>'-select-'
         
     ]
);?></td>

 <td> <?= $form->field($model, 'tax')->dropdownList([
        0 => '0%', 
        1 => '18%',
    ],
     [
         'style'=>'length:20px',
         'prompt'=>'-select-'
         
     ]
);?></td>

</tr>

<tr>

<td>
    <div class="form-group">
        <?= Html::submitButton('Save', ['class' => 'btn btn-success']) ?>
    </div>
    </td><td></td><td></td><td></td>
    </tr></table>

    <?php ActiveForm::end(); ?>

</div>
