<?php

use app\models\Accounts;
use app\models\Invoices;
use app\models\Services;
use kartik\depdrop\DepDrop;
use kartik\select2\Select2;
use yii\helpers\ArrayHelper;
use yii\helpers\Html;
use yii\helpers\Url;
use yii\widgets\ActiveForm;

/* @var $this yii\web\View */
/* @var $model app\models\Invcontent */
/* @var $form yii\widgets\ActiveForm */
?>

<?php  $service = ArrayHelper:: map (Services::find()->where(['status'=>1,'currency'=>Invoices::findOne($id)->currency])->all() , 'id' , function($mod, $defaultValue){ return $mod->name.'-'.Accounts::getCurrency($mod->currency); }); ?>



<div class="invcontent-form">

    <?php $form = ActiveForm::begin([
        'fieldConfig' => [
            'template' => " <div class='row'><div class='col-xs-11'>{label}{input}{error}{hint}</div></div>",
        ],
    ]); ?>
    
<table width="100%">
<tr>
   <td>
     <?php 
     
     echo $form->field($model, 'serviceId')->widget(Select2::classname(), [
         'data' => $service,
         'language' => 'en',
         'options' => ['placeholder' => 'Select service...'],
         'pluginOptions' => [
             'allowClear' => true,
             'tabindex' => false,
         ],
         'pluginEvents' => [
             'change' => "function() {
                                                 $('#invcontent-amount').val('');
                                              var selected = $('#invcontent-serviceid').find(':selected');
                                              selected = selected ? selected[0].value:null;
                                             $.ajax({
                                                    type: 'GET',
                                                    dataType:'json',
                                                    url:'" . \yii\helpers\Url::to(['get-price']) . "?selected=' + selected
                                                }).then(function (data) {
                                                    const node = $('#invcontent-amount');
                                                    node.val(data)
                                                });
             
                                                }",
         ]
     ]);
?></td>

   <td> <?= $form->field($model, 'count')->textInput() ?> </td>

    <td> <?= $form->field($model, 'amount')->textInput() ?></td>
</tr>

<tr>
    <td>
    <div class="form-group">
        <?= Html::submitButton('Save', ['class' => 'btn btn-success']) ?>
    </div>
    </td> <td></td> <td></td>
    
    </tr>
</table>
    <?php ActiveForm::end(); ?>

</div>
