<?php

use yii\helpers\ArrayHelper;
use yii\helpers\Html;
use yii\widgets\ActiveForm;
use app\models\Clients;
use kartik\select2\Select2;

/* @var $this yii\web\View */
/* @var $model app\models\Cfile */
/* @var $form yii\widgets\ActiveForm */
?>

<?php $clients = ArrayHelper:: map (Clients::find()->where(['type'=>1])->all() , 'id' , function($model, $defaultValue){ return $model->name; }); ?>



<div class="cfile-form">

   <?php $form = ActiveForm::begin([
        'fieldConfig' => [
            'template' => " <div class='row'><div class='col-xs-11'>{label}{input}{error}{hint}</div></div>",
        ],
    ]); ?>
    
          <div class="panel panel-default">
               <div class="panel-heading">DELIVERY - CARGO STATUS</div>
               <div class="panel-body">
    
    <table width="100%">
<tr>

        <td>    <?= $form->field($model, 'delivery')->checkbox() ?> </td>
        
        <td>    <?= $form->field($model, 'dangestatus')->checkbox() ?> </td>
        
        </tr></table>
    </div></div>
    
    
     <div class="panel panel-default">
               <div class="panel-heading">GENERAL INFORMATION</div>
               <div class="panel-body">
    
    <table width="100%">
<tr>

        <td>
     <?php 

echo $form->field($model, 'clientId')->widget(Select2::classname(), [
    'data' => $clients,
    'language' => 'en',
    'options' => ['placeholder' => 'Select consignee...'],
    'pluginOptions' => [
        'allowClear' => true,
        'tabindex' => false,
    ],
]);

?>
    </td>
    
        <td>
        <?= $form->field($model, 'shipmenttype')->dropdownList([
        1 => 'SEA/OCEAN', 
        2 => 'AIR',
        3=>'LAND',
    ],
     [
         'style'=>'length:20px',
         'prompt'=>'-select-'
         
     ]
);?></td>

   <td>
           <?= $form->field($model, 'incoterm')->dropdownList([
        1 => 'CFR', 
        2 => 'CIF',
            3=>'FOB',
    ],
     [
         'style'=>'length:20px',
         'prompt'=>'-select-'
         
     ]
);?>
</td>
   </tr>

<tr>
    <td><?= $form->field($model, 'blnumber')->textInput(['maxlength' => true]) ?></td>

    <td><?= $form->field($model, 'shipper')->textInput(['maxlength' => true]) ?></td>



    <td><?= $form->field($model, 'saleman')->textInput(['maxlength' => true]) ?></td>
    </tr></table>

    <table width="100%">
<tr><td> <?= $form->field($model, 'description')->textarea() ?></td></tr>
 </table>
 </div></div>
 
 <table>
 
 <tr><td>
    <div class="form-group">
        <?= Html::submitButton('Save', ['class' => 'btn btn-success']) ?>
    </div>
    </td>
    </tr></table>

    <?php ActiveForm::end(); ?>

</div>
