<?php

use yii\helpers\Html;
use yii\grid\GridView;
use app\models\Cartype;
use app\models\Trucks;
use SebastianBergmann\CodeCoverage\Report\PHP;
use app\models\Uzers;
use yii\bootstrap\Modal;
use PharIo\Manifest\Url;
use PHPUnit\Framework\Constraint\Count;

/* @var $this yii\web\View */
/* @var $searchModel app\models\CarsSearch */
/* @var $dataProvider yii\data\ActiveDataProvider */

$this->title ='All cars';
$this->params['breadcrumbs'][] = $this->title;
?>
<div class="cars-index">

    <h3><?= Html::encode($this->title) ?></h3>
    <?php // echo $this->render('_search', ['model' => $searchModel]); ?>

    <p align="right">
        <?= Html::a('New car', ['create'], ['class' => 'btn btn-success']) ?>
        <?= Html::a('Car models', ['cartype/index'], ['class' => 'btn btn-success']) ?>
    </p>
   

    <?= GridView::widget([
        'dataProvider' => $dataProvider,
        'filterModel' => $searchModel,
        'columns' => [
            ['class' => 'yii\grid\SerialColumn'],
            'plateno',
            [
                'attribute'=>'status',
                'value'=>function ($model, $key, $index, $widget) {
                return Uzers::getStatus($model->status);
                },
            ],
            [
                'attribute'=>'datepurchased',
                'value'=>function ($model, $key, $index, $widget) {
                return date('d-m-Y',strtotime($model->datepurchased));
                },
                ],
                [
                    'attribute'=>'typeId',
                    'value'=>function ($model, $key, $index, $widget) {
                    return $model->type->name.' '.$model->type->model;
                    },
                    ],

            ['class' => 'yii\grid\ActionColumn'],
        ],
    ]); ?>
</div>
