<?php

use app\models\Accounts;
use yii\bootstrap\Modal;
use yii\grid\GridView;
use yii\helpers\Html;
use app\models\Bills;
use app\models\Cfile;
use app\models\Services;

/* @var $this yii\web\View */
/* @var $model app\models\Billcontent */

$this->title = 'Bl #'.Cfile::findOne(\Yii::$app->session->get('fileId'))->blnumber.' payment request';
$this->params['breadcrumbs'][] = ['label' => 'Billcontents', 'url' => ['index']];
$this->params['breadcrumbs'][] = $this->title;
?>
<div class="billcontent-create">

    <h3  align="center"><?= Html::encode($this->title) ?></h3>
    
        <p align="left">
        <?= Html::a('', ['billcontent/printrequest','id'=>$id], ['class' => 'glyphicon glyphicon-download-alt']) ?>
           <p align="right">
        <?= Html::button('New service/product',['value'=>\yii\helpers\Url::toRoute('services/create'),'class' => 'btn btn-success','id'=>'modalButton']) ?>
      </p>
      
    </p>
    
    <?php 
Modal::begin([
    'options'=>[
        'tabindex' => false,
    ],
    'header'=>'',
    'id'=>'modal',
    'size'=>'modal-lg',
]);

echo '<div id="modalContent"></div>';

Modal::end();

?>
    

<p><b>Bill #: </b><?php echo $id; ?></br> <b>Bill by:</b><?php echo Bills::findOne($id)->billby0->name; ?> </br> <b>Currency:</b> <?php echo Accounts::getCurrency(Bills::findOne($id)->currency); ?> 
</br> <b>Billed on: </b><?php echo date('d-m-Y',strtotime(Bills::findOne($id)->date));?></br><b>Due date:</b><?php echo date('d-m-Y',strtotime(Bills::findOne($id)->dueDate));?> </p>

 <?= GridView::widget([
        'dataProvider' => $dataProvider,
        'columns' => [
            ['class' => 'yii\grid\SerialColumn'],
            [
                'attribute'=>'serviceId',
                'value'=>function ($model, $key, $index, $widget) {return Services::findOne($model->serviceId)->name; }
            ],
            [
                'attribute'=>'amount',
                'value'=>function ($model, $key, $index, $widget) {return number_format($model->amount).' '.Accounts::getCurrency(Services::findOne($model->serviceId)->currency); }
            ],
            
            [
                'attribute'=>'count',
                'value'=>function ($model, $key, $index, $widget) {return number_format($model->count); }
            ],
            
            [
                'attribute'=>'total',
                'value'=>function ($model, $key, $index, $widget) {return number_format($model->count*$model->amount).' '.Accounts::getCurrency(Services::findOne($model->serviceId)->currency); }
            ],

            ['class' => 'yii\grid\ActionColumn',
                'template'=>'{update}'
            ],
            ['class' => 'yii\grid\ActionColumn',
                'template'=>'{delete}'
            ],
        ],
    ]); ?>

    <?= $this->render('_form', [
        'model' => $model,'c'=>Bills::findOne($id)->currency,
    ]) ?>

</div>
