<?php

namespace app\models;

use yii\base\Model;
use yii\data\ActiveDataProvider;
use app\models\Wstore;

/**
 * WstoreSearch represents the model behind the search form of `app\models\Wstore`.
 */
class WstoreSearch extends Wstore
{
    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['id', 'billId', 'serviceId', 'quantity', 'byy', 'status'], 'integer'],
            [['date', 'onn'], 'safe'],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function scenarios()
    {
        // bypass scenarios() implementation in the parent class
        return Model::scenarios();
    }

    /**
     * Creates data provider instance with search query applied
     *
     * @param array $params
     *
     * @return ActiveDataProvider
     */
    public function search($params)
    {
        $query = Wstore::find();

        // add conditions that should always apply here

        $dataProvider = new ActiveDataProvider([
            'query' => $query,
        ]);

        $this->load($params);

        if (!$this->validate()) {
            // uncomment the following line if you do not want to return any records when validation fails
            // $query->where('0=1');
            return $dataProvider;
        }

        // grid filtering conditions
        $query->andFilterWhere([
            'id' => $this->id,
            'billId' => $this->billId,
            'serviceId' => $this->serviceId!=null?Services::findOne($this->serviceId)->name:$this->serviceId,
            'quantity' => $this->quantity,
            'date' => $this->date,
            'byy' => $this->byy,
            'onn' => $this->onn,
            'status' => 1,
        ]);

        return $dataProvider;
    }
}
