<?php

namespace app\models;

use Yii;

/**
 * This is the model class for table "wstore".
 *
 * @property int $id
 * @property int $billId
 * @property int $serviceId
 * @property int $quantity
 * @property string $date
 * @property int $byy
 * @property string $onn
 * @property int $status
 *
 * @property Dispatchcontents[] $dispatchcontents
 * @property Bills $bill
 * @property Services $serviceId
 */
class Wstore extends \yii\db\ActiveRecord
{
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return 'wstore';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['billId', 'serviceId', 'quantity', 'date', 'byy', 'onn'], 'required'],
            [['billId', 'serviceId', 'quantity', 'byy', 'status'], 'integer'],
            [['date', 'onn'], 'safe'],
            [['billId'], 'exist', 'skipOnError' => true, 'targetClass' => Bills::className(), 'targetAttribute' => ['billId' => 'id']],
            [['serviceId'], 'exist', 'skipOnError' => true, 'targetClass' => Services::className(), 'targetAttribute' => ['serviceId' => 'id']],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'billId' => 'Bill #',
            'serviceId' => 'Spare part',
            'quantity' => 'Quantity',
            'date' => 'Date',
            'byy' => 'Byy',
            'onn' => 'Onn',
            'status' => 'Status',
        ];
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getDispatchcontents()
    {
        return $this->hasMany(Dispatchcontents::className(), ['storeId' => 'id']);
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getBill()
    {
        return $this->hasOne(Bills::className(), ['id' => 'billId']);
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getService()
    {
        return $this->hasOne(Services::className(), ['id' => 'serviceId']);
    }
    
    public function checkStoreStatus($billId,$serviceId,$date){
        
        $stock= Wstore::find()->
        where(['billId'=>$billId,'serviceId'=>$serviceId,'date'=>$date])->all();
        
        return $stock;
        
    }
    
   
}
