<?php

namespace app\models;

use Yii;

/**
 * This is the model class for table "trafficoffences".
 *
 * @property int $id
 * @property int $responsible
 * @property string $carId
 * @property int $driverId
 * @property int $Amount
 * @property string $ref
 * @property string $location
 * @property string $officer
 * @property string $reason
 * @property string $paiddate
 * @property string $offencedate
 */
class Trafficoffences extends \yii\db\ActiveRecord
{
    /**
     * {@inheritdoc}
     */
    public $from, $to; 
    public static function tableName()
    {
        return 'trafficoffences';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['responsible', 'carId', 'driverId', 'Amount', 'ref', 'location', 'officer', 'reason', 'offencedate'], 'required'],
            [['responsible', 'driverId', 'Amount'], 'integer'],
            [['paiddate', 'offencedate'], 'safe'],
            [['carId'], 'string', 'max' => 7],
            ['paiddate', 'compare', 'compareValue' => date('Y-m-d',strtotime("-90 days")), 'operator' => '>=','message'=>'Payment is too old' ],
            [['ref', 'location', 'officer'], 'string', 'max' => 35],
            [['reason'], 'string', 'max' => 100],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'responsible' => 'Responsible',
            'carId' => 'Car',
            'driverId' => 'Driver',
            'Amount' => 'Amount',
            'ref' => 'Reference',
            'location' => 'Location',
            'officer' => 'Officer',
            'reason' => 'Reason',
            'paiddate' => 'Paiddate',
            'offencedate' => 'Offencedate',
        ];
    }
    
    public function checkDublicate($id){
        $ret=null;
        
        $offence= Trafficoffences::find()
        ->where(['ref'=>$id])
        ->all();
        
        if ($offence != null) {
            foreach ($offence as $of){
                $ret=$of->id;
            }
        }
        
        return $ret;
    }
    
    public function getResponsible($id){
        if ($id==1) return 'Company';
        elseif ($id==2) return 'Driver';
    }
    
    public function calculateCost($ofDate,$pdDate,$amount){
        
        $d1=date_create($ofDate);
        $d2= $pdDate !='0000-00-00'?date_create($pdDate):date_create(date('Y-m-d'));
        
        $interval=date_diff($d1,$d2);
        
        $days=$interval->format('%a');
        $av=intval($days/7);
        
        if($av<=4) return $amount+7500*$av;
        elseif ($av>4) return $amount+7500*4;
        
    }
    
    public function calculateDriverCost($driverId,$from,$to){
        
        $offences= Trafficoffences::find()
        ->where("responsible=2 and driverId='$driverId' and offencedate > '$from' and offencedate < '$to'")->all();
        $total=0;
        
        if ($offences !=null){
            foreach ($offences as $offence){
                $d1=date_create($offence->offencedate);
                $d2= $offence->paiddate != null?date_create($offence->paiddate):date_create(date('Y-m-d'));
                
                $interval=date_diff($d1,$d2);
                
                $days=$interval->format('%a');
                $av=intval($days/7);
                
                if($av<=4) $total=$offence->Amount+7500*$av;
                elseif ($av>4) $total=$offence->Amount+7500*4;
            }
        }
        
        return $total;
    }
    
    public function calculateCarCost($carId,$from,$to){
        
        $offences= Trafficoffences::find()
        ->where("carId='$carId' and offencedate > '$from' and offencedate < '$to'")->all();
        $total=0;
        
        if ($offences !=null){
            foreach ($offences as $offence){
                $d1=date_create($offence->offencedate);
                $d2= $offence->paiddate != null?date_create($offence->paiddate):date_create(date('Y-m-d'));
                
                $interval=date_diff($d1,$d2);
                
                $days=$interval->format('%a');
                $av=intval($days/7);
                
                if($av<=4) $total=$offence->Amount+7500*$av;
                elseif ($av>4) $total=$offence->Amount+7500*4;
            }
        }
        
        return $total;
    }
}
