<?php

namespace app\models;

use Yii;

/**
 * This is the model class for table "routing".
 *
 * @property int $id
 * @property int $packageId
 * @property string $gatepass
 * @property string $routedate
 * @property int $byy
 * @property string $onn
 *
 * @property Packages $package
 * @property Uzers $byy0
 */
class Routing extends \yii\db\ActiveRecord
{
    /**
     * {@inheritdoc}
     */
    public $file;
    
    public static function tableName()
    {
        return 'routing';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['packageId', 'gatepass', 'routedate', 'byy', 'onn'], 'required'],
            [['packageId', 'byy'], 'integer'],
            [['routedate', 'onn'], 'safe'],
            [['gatepass'], 'string', 'max' => 100],
            [['packageId'], 'exist', 'skipOnError' => true, 'targetClass' => Packages::className(), 'targetAttribute' => ['packageId' => 'id']],
            [['byy'], 'exist', 'skipOnError' => true, 'targetClass' => Uzers::className(), 'targetAttribute' => ['byy' => 'id']],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'packageId' => 'Package ID',
            'gatepass' => 'Gatepass',
            'routedate' => 'Routedate',
            'byy' => 'Byy',
            'onn' => 'Onn',
        ];
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getPackage()
    {
        return $this->hasOne(Packages::className(), ['id' => 'packageId']);
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getByy0()
    {
        return $this->hasOne(Uzers::className(), ['id' => 'byy']);
    }
    
    public function getRouteByPackage($id){
        $ret=null;
        
        $route= Routing::find()->where(['packageId'=>$id])->one();
        
        if ($route != null){
            $ret=$route;
        }
        return $ret;
    }
}
