<?php

namespace app\models;

use Yii;

/**
 * This is the model class for table "movements".
 *
 * @property int $id
 * @property int $clientId
 * @property int $movetypeId
 * @property int $truckId
 * @property string $interchangedate
 * @property string $registereddate
 * @property int $driverId
 * @property string $containerno
 * @property int $shippingline
 * @property int $size
 * @property int $byy
 * @property int $fuelId
 *
 * @property Uzers $byy0
 * @property Clients $client
 * @property Cardrivers $driver
 * @property Fuelrequest $fuel
 * @property Movetype $movetype
 * @property Clients $shippingline0
 * @property Trailers $truck
 */
class Movements extends \yii\db\ActiveRecord
{
    /**
     * {@inheritdoc}
     */
    public $from, $to; 
    
    public static function tableName()
    {
        return 'movements';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['clientId', 'movetypeId', 'truckId', 'interchangedate', 'registereddate', 'driverId', 'containerno', 'shippingline', 'size', 'byy', 'fuelId'], 'required'],
            [['clientId', 'movetypeId', 'driverId', 'shippingline', 'size', 'byy', 'fuelId'], 'integer'],
            [['interchangedate', 'registereddate'], 'safe'],
            ['interchangedate', 'compare', 'compareValue' => date('Y-m-d'), 'operator' => '<=','message'=>'Date can not be above today' ],
            ['interchangedate', 'compare', 'compareValue' => date('Y-m-d',strtotime("-60 days")), 'operator' => '>=','message'=>'Date is too old' ],
            [['containerno'], 'string', 'max' => 12],
            [['byy'], 'exist', 'skipOnError' => true, 'targetClass' => Uzers::className(), 'targetAttribute' => ['byy' => 'id']],
            [['clientId'], 'exist', 'skipOnError' => true, 'targetClass' => Clients::className(), 'targetAttribute' => ['clientId' => 'id']],
            [['driverId'], 'exist', 'skipOnError' => true, 'targetClass' => Cardrivers::className(), 'targetAttribute' => ['driverId' => 'id']],
            [['fuelId'], 'exist', 'skipOnError' => true, 'targetClass' => Fuelrequest::className(), 'targetAttribute' => ['fuelId' => 'id']],
            [['movetypeId'], 'exist', 'skipOnError' => true, 'targetClass' => Movetype::className(), 'targetAttribute' => ['movetypeId' => 'id']],
            [['shippingline'], 'exist', 'skipOnError' => true, 'targetClass' => Clients::className(), 'targetAttribute' => ['shippingline' => 'id']],
            [['truckId'], 'exist', 'skipOnError' => true, 'targetClass' => Cars::className(), 'targetAttribute' => ['truckId' => 'plateno']],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'clientId' => 'Client',
            'movetypeId' => 'Movetype',
            'truckId' => 'Truck',
            'interchangedate' => 'Interchange date',
            'registereddate' => 'Registereddate',
            'driverId' => 'Driver',
            'containerno' => 'Container #',
            'shippingline' => 'Shipping line',
            'size' => 'Size',
            'byy' => 'Byy',
            'fuelId' => 'Fuel ',
            'from'=>'From',
            'to'=>'To',
        ];
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getByy0()
    {
        return $this->hasOne(Uzers::className(), ['id' => 'byy']);
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getClient()
    {
        return $this->hasOne(Clients::className(), ['id' => 'clientId']);
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getDriver()
    {
        return $this->hasOne(Cardrivers::className(), ['id' => 'driverId']);
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getFuel()
    {
        return $this->hasOne(Fuelrequest::className(), ['id' => 'fuelId']);
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getMovetype()
    {
        return $this->hasOne(Movetype::className(), ['id' => 'movetypeId']);
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getShippingline0()
    {
        return $this->hasOne(Clients::className(), ['id' => 'shippingline']);
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getTruck()
    {
        return $this->hasOne(Cars::className(), ['plateno' => 'truckId']);
    }
    
    public function checkDublicateMovement($moveId,$cntNo,$date){
        
        $ret=null;
        
        $moves= Movements::find()
        ->where(['movetypeId'=>$moveId,'containerno'=>$cntNo])->one();
        
        if ($moves != null){
            $age= Movements::getMoveAgeByDate($date);
            
            if ($age <= 30) $ret=$moves;
        }
        
        return $ret;
        
    }
    
    public function driverAllMovements($id){
        
        $total=0;
        
        $movetypes=Movetype::find()->all();
        
        if ($movetypes != null){
            foreach ($movetypes as $movetype){
                
                $movements= Movements::find()
                ->where("driverId='$id' and movetypeId='$movetype->id' and company=:c",[':c'=>\Yii::$app->session->get('company')])
                ->all();
                
                $prevdate=null;
                $store=null;
                $trp=0;
                
                if ($movements !=null){
                    foreach ($movements as $movement){
                        if (($prevdate==null) and ($movement->movetype->triptype==1) and ($movement->size==2)){
                            
                            $dayMoves= Movements::find()
                            ->where(['driverId'=>$id,'movetypeId'=>$movetype->id,'size'=>2,'interchangedate'=>$movement->interchangedate])
                            ->all();
                            
                            $trp=$trp+round(count($dayMoves)/2);
                            $prevdate=$movement->interchangedate;
                            
                        }elseif (($prevdate!=null) and ($movement->movetype->triptype==1) and ($movement->size==2)){
                            
                            $dayMoves= Movements::find()
                            ->where(['driverId'=>$id,'movetypeId'=>$movetype->id,'size'=>2,'interchangedate'=>$movement->interchangedate])
                            ->all();
                            
                            $trp=$trp+round(count($dayMoves)/2);
                            $prevdate=$movement->interchangedate;
                            
                        }elseif ($movement->movetype->triptype!=1){
                            $trp=$trp+1;
                        }elseif ($movement->movetype->triptype==1 and $movement->size!=2){
                            $trp=$trp+1;
                        }
                    }
                }
                $total=$total+$trp;
            }
        }
        
        return $total;
    }
    
    public function driverMovementsByTime($id,$from,$to){
        
        $total=0;
        
        $movetypes=Movetype::find()->all();
        
        if ($movetypes != null){
            foreach ($movetypes as $movetype){
                
                $movements= Movements::find()
                ->where("registereddate >= '$from' and registereddate <= '$to' and driverId='$id' and movetypeId='$movetype->id' and company=:c",[':c'=>\Yii::$app->session->get('company')])
                ->orderBy(['interchangedate'=>SORT_DESC])->all();
                
                $prevdate=null;
                $store=null;
                $trp=0;
                
                if ($movements !=null){
                    foreach ($movements as $movement){
                        if (($prevdate==null) and ($movement->movetype->triptype==1) and ($movement->size==2)){
                            $c=0;
                            $dayMoves= Movements::find()
                            ->where(['driverId'=>$id,'movetypeId'=>$movetype->id,'size'=>2,'interchangedate'=>$movement->interchangedate])
                            ->all();
                            
                            if ($dayMoves!=null){
                                foreach ($dayMoves as $move){
                                    if (($move->registereddate>= $from) and ($move->registereddate<=$to)) $c=$c+1;
                                }
                            }
                            $trp=$trp+round($c/2);
                            $prevdate=$movement->interchangedate;
                            
                        }elseif (($prevdate!=null) and ($movement->movetype->triptype==1) and ($movement->size==2)){
                            $c=0;
                            $dayMoves= Movements::find()
                            ->where(['driverId'=>$id,'movetypeId'=>$movetype->id,'size'=>2,'interchangedate'=>$movement->interchangedate])
                            ->all();
                            
                            if ($dayMoves!=null){
                                foreach ($dayMoves as $move){
                                    if (($move->registereddate>= $from) and ($move->registereddate<=$to))  $c=$c+1;
                                }
                            }
                            
                            $trp=$trp+round($c/2);
                            $prevdate=$movement->interchangedate;
                            
                        }elseif ($movement->movetype->triptype!=1){
                            $trp=$trp+1;
                        }elseif ($movement->movetype->triptype==1 and $movement->size!=2){
                            $trp=$trp+1;
                        }
                    }
                }
                $total=$total+$trp;
            }
        }
        
        return $total;
    }
    
    
    public function carMovementsByTime($id,$from,$to){
        
        $total=0;
        
        $movetypes=Movetype::find()->all();
        
        if ($movetypes != null){
            foreach ($movetypes as $movetype){
                
                $movements= Movements::find()
                ->where("registereddate >= '$from' and registereddate <= '$to' and truckId='$id' and movetypeId='$movetype->id' and company=:c",[':c'=>\Yii::$app->session->get('company')])
                ->orderBy(['interchangedate'=>SORT_DESC])->all();
                
                $prevdate=null;
                $store=null;
                $trp=0;
                
                if ($movements !=null){
                    foreach ($movements as $movement){
                        if (($prevdate==null) and ($movement->movetype->triptype==1) and ($movement->size==2)){
                            $c=0;
                            $dayMoves= Movements::find()
                            ->where(['truckId'=>$id,'movetypeId'=>$movetype->id,'size'=>2,'interchangedate'=>$movement->interchangedate])
                            ->all();
                            
                            if ($dayMoves!=null){
                                foreach ($dayMoves as $move){
                                    if (($move->registereddate>= $from) and ($move->registereddate<=$to))  $c=$c+1;
                                }
                            }
                            
                            
                            $trp=$trp+round($c/2);
                            $prevdate=$movement->interchangedate;
                            
                        }elseif (($prevdate!=null) and ($movement->movetype->triptype==1) and ($movement->size==2)){
                            $c=0;
                            $dayMoves= Movements::find()
                            ->where(['truckId'=>$id,'movetypeId'=>$movetype->id,'size'=>2,'interchangedate'=>$movement->interchangedate])
                            ->all();
                            
                            if ($dayMoves!=null){
                                foreach ($dayMoves as $move){
                                    if (($move->registereddate>= $from) and ($move->registereddate<=$to))  $c=$c+1;
                                }
                            }
                            
                            
                            $trp=$trp+round($c/2);
                            $prevdate=$movement->interchangedate;
                            
                        }elseif ($movement->movetype->triptype!=1){
                            $trp=$trp+1;
                        }elseif ($movement->movetype->triptype==1 and $movement->size!=2){
                            $trp=$trp+1;
                        }
                    }
                }
                $total=$total+$trp;
            }
        }
        
        return $total;
    }
    
    public function carAmountOfLoadBySizeTime($id,$from,$to,$size){
       
                $movements= Movements::find()
                ->where("interchangedate >= '$from' and interchangedate <= '$to' and truckId='$id' and size='$size' and company=:c",[':c'=>\Yii::$app->session->get('company')])
                ->all();
        
        return count($movements);
    }
    
    public function carAmountOfIncomeByTime($id,$from,$to){
        $total=0;
        
        $movements= Movements::find()
        ->where("interchangedate >= '$from' and interchangedate <= '$to' and truckId='$id' and company=:c",[':c'=>\Yii::$app->session->get('company')])
        ->all();
        
        if ($movements!=null){
            foreach ($movements as $move){
                
                if ($move->size==2) $total=$total+$move->movetype->twentypay;
                
                elseif ($move->size==4) $total=$total+$move->movetype->fortypay;
                
                else $total=$total+$move->movetype->otherpay;
            }
        }
        
        return $total;
    }
    
    
    public function clientAmountOfLoadBySizeTime($id,$from,$to,$size){
        
        $movements= Movements::find()
        ->where("interchangedate >= '$from' and interchangedate <= '$to' and clientId='$id' and size='$size' and company=:c",[':c'=>\Yii::$app->session->get('company')])
        ->all();
        
        return count($movements);
    }
    
    
    public function clientAmountOfLoadBySizeTimeShippingline($id,$from,$to,$size,$line){
        
        $movements= Movements::find()
        ->where("interchangedate >= '$from' and interchangedate <= '$to' and clientId='$id' and shippingline='$line' and size='$size' and company=:c",[':c'=>\Yii::$app->session->get('company')])
        ->all();
        
        return count($movements);
    }
    
    
    public function driverAmountOfLoadBySizeTime($id,$from,$to,$size){
     
        $ret=0;
                $movements= Movements::find()
                ->where("interchangedate >= '$from' and interchangedate <= '$to' and driverId='$id' and size='$size' and company=:c",[':c'=>\Yii::$app->session->get('company')])
                ->all();
                
                $ret=count($movements);
        
        return $ret;
    }
    
    public function getMoveAgeByDate($date){
        
        $d1= date_create(date('Y-m-d'));
        $d2= date_create($date);
        
        $interval=date_diff($d1,$d2);
        
        return $interval->format('%d');
    }
    
    
}
