<?php

namespace app\models;

use Yii;

/**
 * This is the model class for table "invcontent".
 *
 * @property int $id
 * @property int $invId
 * @property int $serviceId
 * @property int $count
 * @property string $amount
 * @property string $date
 *
 * @property Invoices $inv
 * @property Servicecost $service
 */
class Invcontent extends \yii\db\ActiveRecord
{
    /**
     * {@inheritdoc}
     */
    
    public $cnt;
    
    public static function tableName()
    {
        return 'invcontent';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['invId', 'serviceId', 'amount', 'date'], 'required'],
            [['invId', 'serviceId', 'count'], 'integer'],
            [['amount'], 'number'],
            [['date'], 'safe'],
            [['invId'], 'exist', 'skipOnError' => true, 'targetClass' => Invoices::className(), 'targetAttribute' => ['invId' => 'id']],
            [['serviceId'], 'exist', 'skipOnError' => true, 'targetClass' => Services::className(), 'targetAttribute' => ['serviceId' => 'id']],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'invId' => 'Inv ID',
            'serviceId' => 'Service',
            'count' => 'Quantity',
            'amount' => 'Amount',
            'date' => 'Date',
        ];
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getInv()
    {
        return $this->hasOne(Invoices::className(), ['id' => 'invId']);
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getService()
    {
        return $this->hasOne(Servicecost::className(), ['id' => 'serviceId']);
    }
    
    public function getInvoiceCost($id){
        $ret=0;
        
        $contents=Invcontent::find()->where(['invId'=>$id])->all();
        
        if ($contents!=null) {
            foreach ($contents as $content){
                $ret=$ret+($content->amount*$content->count);
            }
        }
        
        return $ret;
    }
    
    public function checkServiceInInvoice($servid,$invoId){
        
        $ret=null;
        
        $contents=Invcontent::find()->where(['invId'=>$invoId,'serviceId'=>$servid])->all();
        
        if ($contents != null){
            foreach ($contents as $content){
                $ret=$content->id;
            }
        }
        return $ret;
    }
}
