<?php

namespace app\models;

use Yii;
use app\models\Docsupload;
use app\models\Packages;

/**
 * This is the model class for table "cfile".
 *
 * @property int $id
 * @property int $shipmenttype
 * @property int $incoterm
 * @property int $fstatus
 * @property int $acstatus
 * @property string $blnumber
 * @property string $shipper
 * @property int $delivery
 * @property string $saleman
 * @property int $dangestatus
 * @property string $description
 * @property int $byy
 * @property string $onn
 * @property int $clientId
 *
 * @property Clients $client
 * @property Uzers $byy0
 * @property Docsupload[] $docsuploads
 * @property Packages[] $packages
 */
class Cfile extends \yii\db\ActiveRecord
{
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return 'cfile';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['shipmenttype', 'incoterm', 'blnumber', 'shipper', 'delivery', 'saleman', 'byy', 'onn', 'clientId'], 'required'],
            [['shipmenttype', 'incoterm', 'fstatus', 'acstatus', 'delivery', 'dangestatus', 'byy', 'clientId'], 'integer'],
            [['onn'], 'safe'],
            [['blnumber'], 'string', 'max' => 25],
            [['shipper'], 'string', 'max' => 35],
            [['saleman'], 'string', 'max' => 45],
            [['description'], 'string', 'max' => 200],
            [['clientId'], 'exist', 'skipOnError' => true, 'targetClass' => Clients::className(), 'targetAttribute' => ['clientId' => 'id']],
            [['byy'], 'exist', 'skipOnError' => true, 'targetClass' => Uzers::className(), 'targetAttribute' => ['byy' => 'id']],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'shipmenttype' => 'Shipment type',
            'incoterm' => 'Incoterm',
            'fstatus' => 'Fstatus',
            'acstatus' => 'Acstatus',
            'blnumber' => 'Bl number',
            'shipper' => 'Shipper',
            'delivery' => 'Delivery',
            'saleman' => 'Salesman',
            'dangestatus' => 'Dangerous',
            'description' => 'Description',
            'byy' => 'Byy',
            'onn' => 'Onn',
            'clientId' => 'Consignee',
        ];
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getClient()
    {
        return $this->hasOne(Clients::className(), ['id' => 'clientId']);
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getByy0()
    {
        return $this->hasOne(Uzers::className(), ['id' => 'byy']);
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getDocsuploads()
    {
        return $this->hasMany(Docsupload::className(), ['fileId' => 'id']);
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getPackages()
    {
        return $this->hasMany(Packages::className(), ['fileId' => 'id']);
    }
    
    public function getShipmentTypename($id){
        if ($id==1) return 'SEA/OCEAN';
        elseif ($id==2) return 'AIR';
        elseif ($id==3) return 'LAND';
    }
    
    public function getIncotermName($id){
        if ($id==1) return 'CFR';
        elseif ($id==2) return 'CIF';
        elseif ($id==3) return 'FOB';
    }
    
    public function checkDublicate($blNo){
        
        $file=Cfile::find()->where(['blnumber'=>$blNo])->one();
        
        return $file;
    }
}
