<?php

namespace app\models;

use Yii;

/**
 * This is the model class for table "bills".
 *
 * @property int $id
 * @property int $billby
 * @property string $date
 * @property int $userId
 * @property string $dueDate
 * @property int $paid
 * @property int $company
 *
 * @property Billcontent[] $billcontents
 * @property Billpayments[] $billpayments
 * @property Accounts $billby0
 * @property Uzers $user
 */
class Bills extends \yii\db\ActiveRecord
{
    /**
     * {@inheritdoc}
     */
    
    public $billamount;
    
    public static function tableName()
    {
        return 'bills';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['billby', 'date', 'userId', 'dueDate','currency'], 'required'],
            [['billby', 'userId', 'paid', 'company'], 'integer'],
            [['date', 'dueDate'], 'safe'],
            [['billby'], 'exist', 'skipOnError' => true, 'targetClass' => Accounts::className(), 'targetAttribute' => ['billby' => 'id']],
            [['userId'], 'exist', 'skipOnError' => true, 'targetClass' => Uzers::className(), 'targetAttribute' => ['userId' => 'id']],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'billby' => 'Billed by',
            'date' => 'Bill Date',
            'userId' => 'User ID',
            'dueDate' => 'Due Date',
            'paid' => 'Paid',
            'company' => 'Company',
            'billamount'=>'Amount',
            'currency'=>'Currency',
        ];
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getBillcontents()
    {
        return $this->hasMany(Billcontent::className(), ['billId' => 'id']);
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getBillpayments()
    {
        return $this->hasMany(Billpayments::className(), ['billId' => 'id']);
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getBillby0()
    {
        return $this->hasOne(Accounts::className(), ['id' => 'billby']);
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getUser()
    {
        return $this->hasOne(Uzers::className(), ['id' => 'userId']);
    }
    
}
